/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.webservice;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.egso.consumer.Consumer;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.FileHandle;
import org.egso.consumer.api.ImageReader;
import org.egso.consumer.api.Interval;
import org.egso.consumer.api.Query;
import org.egso.consumer.api.ScalarData;
import org.egso.consumer.api.TooBigResultsetException;
import org.egso.consumer.api.Type;
import org.egso.consumer.api.VOTableReader;
import org.egso.consumer.api.async.Session;
import org.egso.consumer.session.EGSOSessionFactory;
import org.egso.consumer.webservice.QueryWS;

public class QueryImpl
implements QueryWS {
    private Session session = new EGSOSessionFactory().login(null);

    private Query resolveQueryId(String queryid) throws ArgumentException {
        return Consumer.getInstance().getQuery(queryid);
    }

    private String registerData(String queryId, Data data) {
        return Consumer.getInstance().putData(queryId, data);
    }

    private Data resolveData(Query q, String remoteDataId) {
        return this.resolveData(q.id(), remoteDataId);
    }

    private Data resolveData(String query_id, String remoteDataId) {
        return Consumer.getInstance().getData(query_id, remoteDataId);
    }

    private String registerType(String queryId, Type type) {
        return Consumer.getInstance().putType(queryId, type);
    }

    private Type resolveType(Query q, String remoteTypeId) {
        return this.resolveType(q.id(), remoteTypeId);
    }

    private Type resolveType(String query_id, String remoteTypeId) {
        return Consumer.getInstance().getType(query_id, remoteTypeId);
    }

    public String newQuery() throws ConsumerException {
        String id = this.session.newQuery().id();
        return id;
    }

    public void disposeQuery(String query_id) throws RemoteException {
        Consumer.getInstance().disposeQuery(query_id);
    }

    public String[] findAll(String queryId) throws RemoteException, ConsumerException {
        Collection all = this.resolveQueryId(queryId).findAll();
        return all.toArray(new String[all.size()]);
    }

    public String[] findAllResults(String queryId) throws RemoteException, ConsumerException {
        Collection allResults = this.resolveQueryId(queryId).findAllResults();
        return allResults.toArray(new String[allResults.size()]);
    }

    public String[] findAllParameters(String queryId) throws RemoteException, ConsumerException {
        Collection allParams = this.resolveQueryId(queryId).findAllParameters();
        return allParams.toArray(new String[allParams.size()]);
    }

    public String[] affectedBy(String queryId, String data_key) throws RemoteException, ConsumerException {
        Collection affected = this.resolveQueryId(queryId).affectedBy(data_key);
        return affected.toArray(new String[affected.size()]);
    }

    public String[] affects(String queryId, String data_key) throws RemoteException, ConsumerException {
        Collection affect = this.resolveQueryId(queryId).affects(data_key);
        return affect.toArray(new String[affect.size()]);
    }

    public String[] requires(String queryId, String data_key) throws RemoteException, ConsumerException {
        Collection require = this.resolveQueryId(queryId).requires(data_key);
        return require.toArray(new String[require.size()]);
    }

    public String[] catalogues(String queryId) throws RemoteException, ConsumerException {
        Collection cats = this.resolveQueryId(queryId).catalogues();
        return cats.toArray(new String[cats.size()]);
    }

    public String[] findByCatalogue(String queryId, String catalogue_key) throws RemoteException, ConsumerException {
        Collection cparams = this.resolveQueryId(queryId).findByCatalogue(catalogue_key);
        return cparams.toArray(new String[cparams.size()]);
    }

    public boolean readonly(String queryId, String data_key) throws RemoteException, ConsumerException {
        return this.resolveQueryId(queryId).readonly(data_key);
    }

    public boolean isSet(String queryId, String data_key) throws RemoteException, ArgumentException {
        return this.resolveQueryId(queryId).isSet(data_key);
    }

    public void unset(String queryId, String data_key) throws RemoteException, ConsumerException {
        this.resolveQueryId(queryId).unset(data_key);
    }

    public void setValue(String queryId, String data_key, String value) throws RemoteException, ConsumerException {
        this.resolveQueryId(queryId).setValue(data_key, (Object)value);
    }

    public void setValues(String queryId, String data_key, String[] values) throws RemoteException, ConsumerException {
        this.resolveQueryId(queryId).setValue(data_key, (Object)values);
    }

    public void set(String queryId, String data_key, String data_id) throws RemoteException, ConsumerException {
        this.resolveQueryId(queryId).set(data_key, this.resolveData(queryId, data_id));
    }

    public String get(String queryId, String data_key) throws RemoteException, ConsumerException {
        return this.registerData(queryId, this.resolveQueryId(queryId).get(data_key));
    }

    public String getResult(String queryId, String data_key) throws RemoteException, TooBigResultsetException, ConsumerException {
        return this.registerData(queryId, this.resolveQueryId(queryId).getResult(data_key));
    }

    public String getQuerySource(String queryId, String data_key) throws RemoteException, ConsumerException {
        return this.resolveQueryId(queryId).getQuerySource(data_key);
    }

    public String getContext(String queryId, String data_key) throws RemoteException, ConsumerException {
        return this.resolveQueryId(queryId).getContext(data_key).toXML();
    }

    public int getEGSOContextRole() throws RemoteException {
        return 1;
    }

    public String getConsumerId() throws RemoteException {
        return Consumer.getConsumerId();
    }

    public String getConsumerVersion() throws RemoteException {
        return Consumer.getConsumerVersion();
    }

    public String getHostAddress() throws RemoteException {
        return Consumer.getHostAddress();
    }

    public int data_interfaces(String queryId, String data_id) throws RemoteException {
        Data data = this.resolveData(queryId, data_id);
        if (data instanceof FileHandle) {
            return 1;
        }
        if (data instanceof ImageReader) {
            return 2;
        }
        if (data instanceof Interval) {
            return 3;
        }
        if (data instanceof ScalarData) {
            return 4;
        }
        if (data instanceof VOTableReader) {
            return 5;
        }
        return 0;
    }

    public int data_size(String queryId, String data_id) throws RemoteException {
        return this.resolveData(queryId, data_id).size();
    }

    public boolean data_readonly(String queryId, String data_id) {
        return this.resolveData(queryId, data_id).readonly();
    }

    public boolean data_containsData(String queryId, String data_id, String contains_queryId, String contains_data_id) throws RemoteException, ArgumentException {
        return this.resolveData(queryId, data_id).contains((Object)this.resolveData(contains_queryId, contains_data_id));
    }

    public boolean data_containsObject(String queryId, String data_id, String contains_value) throws RemoteException, ArgumentException {
        return this.resolveData(queryId, data_id).contains((Object)contains_value);
    }

    public String data_clone(String queryId, String data_id) throws RemoteException {
        return this.registerData(queryId, (Data)this.resolveData(queryId, data_id).clone());
    }

    public String data_prettyPrint(String queryId, String data_id) throws RemoteException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        this.resolveData(queryId, data_id).prettyPrint(ps);
        ps.close();
        return os.toString();
    }

    public void data_set(String queryId, String data_id, String queryId_toset, String data_id_toset) throws RemoteException, ConsumerException {
        this.resolveData(queryId, data_id).set(this.resolveData(queryId_toset, data_id_toset));
    }

    public void data_putObject(String queryId, String data_id, String key, String value) throws RemoteException, ArgumentException {
        this.resolveData(queryId, data_id).put((Object)key, (Object)value);
    }

    public String data_getByIndex(String queryId, String data_id, int index) throws RemoteException, ConsumerException {
        return this.registerData(queryId, this.resolveData(queryId, data_id).get(index));
    }

    public void data_setValue(String queryId, String data_id, String value) throws RemoteException, ConsumerException {
        this.resolveData(queryId, data_id).setValue((Object)value);
    }

    public void data_setValues(String queryId, String data_id, String[] values) throws RemoteException, ConsumerException {
        this.resolveData(queryId, data_id).setValue((Object)values);
    }

    public void data_putData(String queryId, String data_id, String key, String queryId_toset, String data_id_toset) throws RemoteException, ArgumentException {
        this.resolveData(queryId, data_id).put((Object)key, (Object)this.resolveData(queryId_toset, data_id_toset));
    }

    public void data_addObject(String queryId, String data_id, String value) throws RemoteException, ConsumerException {
        this.resolveData(queryId, data_id).add((Object)value);
    }

    public void data_addData(String queryId, String data_id, String queryId_toadd, String data_id_toadd) throws RemoteException, ConsumerException {
        this.resolveData(queryId, data_id).add((Object)this.resolveData(queryId_toadd, data_id_toadd));
    }

    public void data_removeObject(String queryId, String data_id, String value) throws RemoteException, ArgumentException {
        this.resolveData(queryId, data_id).remove((Object)value);
    }

    public void data_removeData(String queryId, String data_id, String queryId_toremove, String data_id_toremove) throws RemoteException, ArgumentException {
        this.resolveData(queryId, data_id).remove((Object)this.resolveData(queryId_toremove, data_id_toremove));
    }

    public String data_getValue(String queryId, String data_id) throws RemoteException, ConsumerException {
        Data value = this.resolveData(queryId, data_id);
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public String data_getByKey(String queryId, String data_id, String key) throws RemoteException, ConsumerException {
        return this.registerData(queryId, this.resolveData(queryId, data_id).get(key));
    }

    public String data_id(String queryId, String data_id) throws RemoteException {
        return this.resolveData(queryId, data_id).id();
    }

    public String[][] data_children(String queryId, String data_id) throws RemoteException {
        Map children = this.resolveData(queryId, data_id).children();
        String[][] cs = new String[children.size()][];
        int i = 0;
        Iterator it = children.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            cs[i] = new String[]{(String)entry.getKey(), this.registerData(queryId, (Data)entry.getValue())};
            ++i;
        }
        return cs;
    }

    public String[] data_elements(String queryId, String data_id) throws RemoteException {
        List elements = this.resolveData(queryId, data_id).elements();
        String[] es = new String[elements.size()];
        Iterator it = elements.iterator();
        int i = 0;
        while (it.hasNext()) {
            Data d = (Data)it.next();
            es[i++] = this.registerData(queryId, d);
        }
        return es;
    }

    public String data_children_putObject(String queryId, String data_id, String key, String value) throws RemoteException {
        return this.registerData(queryId, (Data)this.resolveData(queryId, data_id).children().put(key, value));
    }

    public String data_children_putData(String queryId, String data_id, String key, String queryId_toput, String data_id_toput) throws RemoteException {
        return this.registerData(queryId, this.resolveData(queryId, data_id).children().put(key, this.resolveData(queryId_toput, data_id_toput)));
    }

    public String data_children_remove(String queryId, String data_id, String key) throws RemoteException {
        return this.registerData(queryId, (Data)this.resolveData(queryId, data_id).children().remove(key));
    }

    public boolean data_elements_addObject(String queryId, String data_id, String value) throws RemoteException {
        return this.resolveData(queryId, data_id).elements().add(value);
    }

    public boolean data_elements_addData(String queryId, String data_id, String queryId_toput, String data_id_toput) throws RemoteException {
        return this.resolveData(queryId, data_id).elements().add(this.resolveData(queryId_toput, data_id_toput));
    }

    public String data_elements_remove(String queryId, String data_id, int index) throws RemoteException {
        return this.registerData(queryId, (Data)this.resolveData(queryId, data_id).elements().remove(index));
    }

    public boolean data_isEnum(String queryId, String data_id) throws RemoteException {
        return this.resolveData(queryId, data_id).isEnum();
    }

    public boolean data_isList(String queryId, String data_id) throws RemoteException {
        return this.resolveData(queryId, data_id).isList();
    }

    public boolean data_isCompound(String queryId, String data_id) throws RemoteException {
        return this.resolveData(queryId, data_id).isCompound();
    }

    public String data_typeName(String queryId, String data_id) throws RemoteException {
        return this.resolveData(queryId, data_id).typeName();
    }

    public String data_UCDType(String queryId, String data_id) throws RemoteException {
        return this.resolveData(queryId, data_id).UCDType();
    }

    public String data_unit(String queryId, String data_id) throws RemoteException {
        return this.resolveData(queryId, data_id).unit();
    }

    public String data_newData(String queryId, String data_id) throws RemoteException, ConsumerException {
        return this.registerData(queryId, this.resolveData(queryId, data_id).newData());
    }

    public String data_newData(String queryId, String data_id, String initialValue) throws RemoteException, ConsumerException {
        return this.registerData(queryId, this.resolveData(queryId, data_id).newData((Object)initialValue));
    }

    public String data_valueDomain(String queryId, String data_id) throws RemoteException, ConsumerException {
        return this.registerData(queryId, this.resolveData(queryId, data_id).valueDomain());
    }

    public boolean data_equalsData(String queryId, String data_id, String queryId_other, String data_id_other) throws RemoteException {
        return this.resolveData(queryId, data_id).equals((Object)this.resolveData(queryId_other, data_id_other));
    }

    public boolean data_distinct(String queryId, String data_id) throws RemoteException {
        return this.resolveData(queryId, data_id).distinct();
    }

    public String imagereaderdata_getImageURL(String queryId, String data_id) throws RemoteException, ConsumerException {
        return ((ImageReader)this.resolveData(queryId, data_id)).getImageURL().toExternalForm();
    }

    public String intervaldata_getMin(String queryId, String data_id) throws RemoteException {
        return this.registerData(queryId, (Data)((Interval)this.resolveData(queryId, data_id)).getMin());
    }

    public String intervaldata_getMax(String queryId, String data_id) throws RemoteException {
        return this.registerData(queryId, (Data)((Interval)this.resolveData(queryId, data_id)).getMax());
    }

    public boolean intervaldata_getMinInclusive(String queryId, String data_id) throws RemoteException {
        return ((Interval)this.resolveData(queryId, data_id)).getMinInclusive();
    }

    public boolean intervaldata_getMaxInclusive(String queryId, String data_id) throws RemoteException {
        return ((Interval)this.resolveData(queryId, data_id)).getMaxInclusive();
    }

    public boolean intervaldata_overlaps(String queryId, String data_id, String queryId_other, String data_id_other) throws RemoteException {
        return ((Interval)this.resolveData(queryId, data_id)).overlaps((Interval)this.resolveData(queryId_other, data_id_other));
    }

    public boolean intervaldata_containsInterval(String queryId, String data_id, String queryId_other, String data_id_other) throws RemoteException {
        return ((Interval)this.resolveData(queryId, data_id)).contains((Interval)this.resolveData(queryId_other, data_id_other));
    }

    public boolean intervaldata_containsScalar(String queryId, String data_id, String queryId_other, String data_id_other) throws RemoteException {
        return ((Interval)this.resolveData(queryId, data_id)).contains((ScalarData)this.resolveData(queryId_other, data_id_other));
    }

    public int scalar_compareToObject(String queryId, String data_id, Object other) {
        return ((ScalarData)this.resolveData(queryId, data_id)).compareTo(other);
    }

    public int scalar_compareToData(String queryId, String data_id, String queryId_other, String data_id_other) {
        return ((ScalarData)this.resolveData(queryId, data_id)).compareTo((Object)((ScalarData)this.resolveData(queryId_other, data_id_other)));
    }

    public String data_type(String queryId, String data_id) throws RemoteException {
        return this.registerType(queryId, this.resolveData(queryId, data_id).type());
    }

    public String[][] data_childrenTypes(String queryId, String data_id) throws RemoteException {
        Map ctm = this.resolveData(queryId, data_id).childrenTypes();
        String[][] cts = new String[ctm.size()][];
        int i = 0;
        Iterator it = ctm.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            cts[i] = new String[]{(String)entry.getKey(), this.registerType(queryId, (Type)entry.getValue())};
            ++i;
        }
        return cts;
    }

    public String data_elementsType(String queryId, String data_id) throws RemoteException {
        return this.registerType(queryId, this.resolveData(queryId, data_id).elementsType());
    }

    public String data_childrentypes_putType(String queryId, String data_id, String key, String queryId_toput, String type_id_toput) throws RemoteException {
        return this.registerType(queryId, this.resolveData(queryId, data_id).childrenTypes().put(key, this.resolveType(queryId_toput, type_id_toput)));
    }

    public String data_childrentypes_remove(String queryId, String data_id, String key) throws RemoteException {
        return this.registerType(queryId, (Type)this.resolveData(queryId, data_id).childrenTypes().remove(key));
    }

    public String getType(String queryId, String data_key) throws RemoteException, ConsumerException {
        return this.registerType(queryId, this.resolveQueryId(queryId).getType(data_key));
    }

    public boolean type_isEnum(String queryId, String type_id) throws RemoteException {
        return this.resolveType(queryId, type_id).isEnum();
    }

    public boolean type_isList(String queryId, String type_id) throws RemoteException {
        return this.resolveType(queryId, type_id).isList();
    }

    public boolean type_isCompound(String queryId, String type_id) throws RemoteException {
        return this.resolveType(queryId, type_id).isCompound();
    }

    public String type_typeName(String queryId, String type_id) throws RemoteException {
        return this.resolveType(queryId, type_id).typeName();
    }

    public String type_UCDType(String queryId, String type_id) throws RemoteException {
        return this.resolveType(queryId, type_id).UCDType();
    }

    public String type_unit(String queryId, String type_id) throws RemoteException {
        return this.resolveType(queryId, type_id).unit();
    }

    public String type_newData(String queryId, String type_id) throws RemoteException, ConsumerException {
        return this.registerData(queryId, this.resolveType(queryId, type_id).newData());
    }

    public String type_newData(String queryId, String type_id, String initialValue) throws RemoteException, ConsumerException {
        return this.registerData(queryId, this.resolveType(queryId, type_id).newData((Object)initialValue));
    }

    public String type_elementsType(String queryId, String type_id) throws RemoteException {
        return this.registerType(queryId, this.resolveType(queryId, type_id).elementsType());
    }

    public String type_valueDomain(String queryId, String type_id) throws RemoteException, ConsumerException {
        return this.registerData(queryId, this.resolveType(queryId, type_id).valueDomain());
    }

    public boolean type_equals(String queryId, String type_id, String queryId_other, String type_id_other) throws RemoteException {
        return this.resolveType(queryId, type_id).equals((Object)this.resolveType(queryId_other, type_id_other));
    }

    public boolean type_distinct(String queryId, String type_id) throws RemoteException {
        return this.resolveType(queryId, type_id).distinct();
    }

    public String type_clone(String queryId, String type_id) throws RemoteException {
        return this.registerType(queryId, (Type)this.resolveType(queryId, type_id).clone());
    }

    public String[][] type_childrenTypes(String queryId, String type_id) throws RemoteException {
        Map ctm = this.resolveType(queryId, type_id).childrenTypes();
        String[][] cts = new String[ctm.size()][];
        int i = 0;
        Iterator it = ctm.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            cts[i] = new String[]{(String)entry.getKey(), this.registerType(queryId, (Type)entry.getValue())};
            ++i;
        }
        return cts;
    }

    public String type_childrentypes_putType(String queryId, String type_id, String key, String queryId_toput, String type_id_toput) throws RemoteException {
        return this.registerType(queryId, this.resolveData(queryId, type_id).childrenTypes().put(key, this.resolveType(queryId_toput, type_id_toput)));
    }

    public String type_childrentypes_remove(String queryId, String type_id, String key) throws RemoteException {
        return this.registerType(queryId, (Type)this.resolveData(queryId, type_id).childrenTypes().remove(key));
    }

    public String readVOTable(String queryId, String data_id) throws RemoteException, ConsumerException {
        Reader r = ((VOTableReader)this.resolveData(queryId, data_id)).readVOTable();
        StringBuffer sb = new StringBuffer();
        try {
            int c;
            while ((c = r.read()) > -1) {
                sb.append((char)c);
            }
        }
        catch (IOException ex) {
            throw new ConsumerException((Throwable)ex);
        }
        return sb.toString();
    }
}

