/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.wsclient;

import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.UncheckedConsumerException;
import org.egso.consumer.util.ObservableHashMap;
import org.egso.consumer.util.ObservableList;
import org.egso.consumer.wsclient.WSQuery;
import org.egso.consumer.wsclient.WSType;

public class WSData
implements Data {
    protected final WSQuery query;
    protected final String remoteDataId;

    public WSData(WSQuery q, String dId) {
        this.query = q;
        this.remoteDataId = dId;
    }

    public String dataId() {
        return this.remoteDataId;
    }

    public int size() {
        try {
            return this.query.stub.data_size(this.query.id(), this.dataId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public boolean readonly() {
        try {
            return this.query.stub.data_readonly(this.query.id(), this.dataId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public boolean contains(Object candidate) throws ArgumentException {
        try {
            if (candidate instanceof String) {
                return this.query.stub.data_containsObject(this.query.id(), this.dataId(), (String)candidate);
            }
            if (candidate instanceof WSData) {
                return this.query.stub.data_containsData(this.query.id(), this.dataId(), ((WSData)candidate).query.id(), ((WSData)candidate).dataId());
            }
            if (candidate instanceof Data) {
                throw new ArgumentException("The web service EGSO accepts only its own data instances.");
            }
            throw new ArgumentException("The web service EGSO accepts only strings whereever java Object types appear in the API.");
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public Object clone() {
        try {
            return this.query.lookupRemoteDataId(this.query.stub.data_clone(this.query.id(), this.dataId()));
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public void prettyPrint(PrintStream out) {
        String pp;
        try {
            pp = this.query.stub.data_prettyPrint(this.query.id(), this.dataId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
        out.print(pp);
    }

    public void setValue(Object value) throws ArgumentException, ConsumerException {
        try {
            if (value instanceof String) {
                this.query.stub.data_setValue(this.query.id(), this.dataId(), (String)value);
                return;
            }
            if (value instanceof String[]) {
                this.query.stub.data_setValues(this.query.id(), this.dataId(), (String[])value);
                return;
            }
            if (value instanceof Collection) {
                try {
                    this.query.stub.data_setValues(this.query.id(), this.dataId(), ((Collection)value).toArray(new String[((Collection)value).size()]));
                    return;
                }
                catch (ClassCastException ex) {}
            }
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
        throw new ArgumentException("The EGSO web service accepts only String values to transport.");
    }

    public Object getValue() throws ConsumerException {
        try {
            return this.query.stub.data_getValue(this.query.id(), this.dataId());
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
    }

    public void set(Data value) throws ArgumentException, ConsumerException {
        try {
            this.query.stub.data_set(this.query.id(), this.dataId(), ((WSData)value).query.id(), ((WSData)value).dataId());
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
    }

    public Data get(String key) throws ConsumerException {
        try {
            return this.query.lookupRemoteDataId(this.query.stub.data_getByKey(this.query.id(), this.dataId(), key));
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
    }

    public void put(Object key, Object value) throws ArgumentException {
        if (!(key instanceof String)) {
            throw new ArgumentException("keys always must be String but got " + key.getClass().getName());
        }
        try {
            if (value instanceof Data) {
                if (!(value instanceof WSData)) {
                    throw new ArgumentException("The EGSO web service does not support foreign data impls.");
                }
                this.query.stub.data_putData(this.query.id(), this.dataId(), (String)key, ((WSData)value).query.id(), ((WSData)value).dataId());
                return;
            }
            if (value instanceof String) {
                this.query.stub.data_putObject(this.query.id(), this.dataId(), (String)key, (String)value);
                return;
            }
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
        throw new ArgumentException("value must be either String or Data but got " + value.getClass().getName());
    }

    public Data get(int index) throws ConsumerException {
        try {
            return this.query.lookupRemoteDataId(this.query.stub.data_getByIndex(this.query.id(), this.dataId(), index));
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
    }

    public void add(Object value) throws ConsumerException {
        try {
            if (value instanceof Data) {
                if (!(value instanceof WSData)) {
                    throw new ArgumentException("The EGSO web service does not support foreign data impls.");
                }
                this.query.stub.data_addData(this.query.id(), this.dataId(), ((WSData)value).query.id(), ((WSData)value).dataId());
                return;
            }
            if (value instanceof String) {
                this.query.stub.data_addObject(this.query.id(), this.dataId(), (String)value);
                return;
            }
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
        throw new ArgumentException("value must be either String or Data but got " + value.getClass().getName());
    }

    public void remove(Object value) throws ArgumentException {
        try {
            if (value instanceof Data) {
                if (!(value instanceof WSData)) {
                    throw new ArgumentException("The EGSO web service does not support foreign data impls.");
                }
                this.query.stub.data_removeData(this.query.id(), this.dataId(), ((WSData)value).query.id(), ((WSData)value).dataId());
                return;
            }
            if (value instanceof String) {
                this.query.stub.data_removeObject(this.query.id(), this.dataId(), (String)value);
                return;
            }
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
        throw new ArgumentException("value must be either String or Data but got " + value.getClass().getName());
    }

    public String id() {
        try {
            return this.query.stub.data_id(this.query.id(), this.dataId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public Map children() {
        try {
            String[][] cs = this.query.stub.data_children(this.query.id(), this.dataId());
            HashMap<String, WSData> cm = new HashMap<String, WSData>();
            int i = 0;
            while (i < cs.length) {
                cm.put(cs[i][0], this.query.lookupRemoteDataId(cs[i][1]));
                ++i;
            }
            return new ObservableHashMap(cm){

                public synchronized Object put(Object key, Object value) {
                    try {
                        if (!(key instanceof String)) {
                            throw new UncheckedConsumerException((ConsumerException)((Object)new ArgumentException("unsupported key type: " + (key != null ? key.getClass().getName() : "null") + " " + "(only String allowed as keys")));
                        }
                        if (value instanceof Data) {
                            if (!(value instanceof WSData)) {
                                throw new UncheckedConsumerException((ConsumerException)((Object)new ArgumentException("The EGSO web service does not support foreign data impls.")));
                            }
                            WSData.this.query.lookupRemoteDataId(WSData.this.query.stub.data_children_putData(WSData.this.query.id(), WSData.this.dataId(), (String)key, ((WSData)value).query.id(), ((WSData)value).dataId()));
                        } else if (value instanceof String) {
                            WSData.this.query.lookupRemoteDataId(WSData.this.query.stub.data_children_putObject(WSData.this.query.id(), WSData.this.dataId(), (String)key, (String)value));
                        } else {
                            throw new UncheckedConsumerException((ConsumerException)((Object)new ArgumentException("unsupported value class: " + (value != null ? value.getClass().getName() : "null") + " " + "(only String and Data are allowed.)")));
                        }
                        return super.put(key, value);
                    }
                    catch (RemoteException ex) {
                        throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
                    }
                }

                public synchronized Object remove(Object key) {
                    try {
                        if (!(key instanceof String)) {
                            throw new UncheckedConsumerException((ConsumerException)((Object)new ArgumentException("unsupported key type: " + (key != null ? key.getClass().getName() : "null") + " " + "(only String allowed as keys")));
                        }
                        WSData.this.query.lookupRemoteDataId(WSData.this.query.stub.data_children_remove(WSData.this.query.id(), WSData.this.dataId(), (String)key));
                        return super.remove(key);
                    }
                    catch (RemoteException ex) {
                        throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
                    }
                }
            };
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public List elements() {
        try {
            String[] es = this.query.stub.data_elements(this.query.id(), this.dataId());
            LinkedList<WSData> el = new LinkedList<WSData>();
            int i = 0;
            while (i < es.length) {
                el.add(this.query.lookupRemoteDataId(es[i]));
                ++i;
            }
            return new ObservableList(el){

                public synchronized boolean add(Object element) {
                    try {
                        if (element instanceof Data) {
                            if (!(element instanceof WSData)) {
                                throw new UncheckedConsumerException((ConsumerException)((Object)new ArgumentException("The EGSO web service does not support foreign data impls.")));
                            }
                            WSData.this.query.stub.data_elements_addData(WSData.this.query.id(), WSData.this.dataId(), ((WSData)element).query.id(), ((WSData)element).dataId());
                        } else if (element instanceof String) {
                            WSData.this.query.stub.data_elements_addObject(WSData.this.query.id(), WSData.this.dataId(), (String)element);
                        } else {
                            throw new UncheckedConsumerException((ConsumerException)((Object)new ArgumentException("unsupported element class: " + (element != null ? element.getClass().getName() : "null") + " " + "(only String and Data are allowed.)")));
                        }
                        return super.add(element);
                    }
                    catch (RemoteException ex) {
                        throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
                    }
                }

                public synchronized Object remove(int index) {
                    try {
                        WSData.this.query.lookupRemoteDataId(WSData.this.query.stub.data_elements_remove(WSData.this.query.id(), WSData.this.dataId(), index));
                        return super.remove(index);
                    }
                    catch (RemoteException ex) {
                        throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
                    }
                }
            };
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public boolean isEnum() {
        try {
            return this.query.stub.data_isEnum(this.query.id(), this.dataId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public boolean isList() {
        try {
            return this.query.stub.data_isList(this.query.id(), this.dataId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public boolean isCompound() {
        try {
            return this.query.stub.data_isCompound(this.query.id(), this.dataId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public String typeName() {
        try {
            return this.query.stub.data_typeName(this.query.id(), this.dataId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public String UCDType() {
        try {
            return this.query.stub.data_UCDType(this.query.id(), this.dataId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public String unit() {
        try {
            return this.query.stub.data_unit(this.query.id(), this.dataId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public Data newData() throws ConsumerException {
        try {
            return this.query.lookupRemoteDataId(this.query.stub.data_newData(this.query.id(), this.dataId()));
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public Data newData(Object initialValue) throws ConsumerException {
        if (initialValue != null && !(initialValue instanceof String)) {
            throw new ArgumentException("The EGSO web service accepts only Strings to transport but got " + initialValue.getClass().getName());
        }
        try {
            return this.query.lookupRemoteDataId(this.query.stub.data_newData(this.query.id(), this.dataId(), (String)initialValue));
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public Data valueDomain() throws ConsumerException {
        try {
            return this.query.lookupRemoteDataId(this.query.stub.data_valueDomain(this.query.id(), this.dataId()));
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public boolean distinct() {
        try {
            return this.query.stub.data_distinct(this.query.id(), this.dataId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public Type type() {
        try {
            return this.query.lookupRemoteTypeId(this.query.stub.data_type(this.query.id(), this.dataId()));
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public Type elementsType() {
        try {
            return this.query.lookupRemoteTypeId(this.query.stub.data_elementsType(this.query.id(), this.dataId()));
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public Map childrenTypes() {
        try {
            String[][] cs = this.query.stub.data_childrenTypes(this.query.id(), this.dataId());
            HashMap<String, WSType> cm = new HashMap<String, WSType>();
            int i = 0;
            while (i < cs.length) {
                cm.put(cs[i][0], this.query.lookupRemoteTypeId(cs[i][1]));
                ++i;
            }
            return new ObservableHashMap(cm){

                public synchronized Object put(Object key, Object value) {
                    try {
                        if (!(key instanceof String)) {
                            throw new UncheckedConsumerException((ConsumerException)((Object)new ArgumentException("unsupported key type: " + (key != null ? key.getClass().getName() : "null") + " " + "(only String allowed as keys")));
                        }
                        if (value instanceof Type) {
                            if (!(value instanceof WSType)) {
                                throw new UncheckedConsumerException((ConsumerException)((Object)new ArgumentException("The EGSO web service does not support foreign Type impls.")));
                            }
                        } else {
                            throw new UncheckedConsumerException((ConsumerException)((Object)new ArgumentException("unsupported Type class: " + (value != null ? value.getClass().getName() : "null"))));
                        }
                        WSData.this.query.lookupRemoteTypeId(WSData.this.query.stub.data_childrentypes_putType(WSData.this.query.id(), WSData.this.dataId(), (String)key, ((WSType)value).query.id(), ((WSType)value).typeId()));
                        return super.put(key, value);
                    }
                    catch (RemoteException ex) {
                        throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
                    }
                }

                public synchronized Object remove(Object key) {
                    try {
                        if (!(key instanceof String)) {
                            throw new UncheckedConsumerException((ConsumerException)((Object)new ArgumentException("unsupported key type: " + (key != null ? key.getClass().getName() : "null") + " " + "(only String allowed as keys")));
                        }
                        WSData.this.query.lookupRemoteTypeId(WSData.this.query.stub.data_childrentypes_remove(WSData.this.query.id(), WSData.this.dataId(), (String)key));
                        return super.remove(key);
                    }
                    catch (RemoteException ex) {
                        throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
                    }
                }
            };
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }
}

