/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.wsclient;

import java.rmi.RemoteException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Interval;
import org.egso.consumer.api.ScalarData;
import org.egso.consumer.core.UncheckedConsumerException;
import org.egso.consumer.wsclient.WSData;
import org.egso.consumer.wsclient.WSQuery;

public class WSIntervalData
extends WSData
implements Interval {
    public WSIntervalData(WSQuery q, String id) {
        super(q, id);
    }

    public ScalarData getMin() {
        try {
            return (ScalarData)this.query.lookupRemoteDataId(this.query.stub.intervaldata_getMin(this.query.id(), this.dataId()));
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public ScalarData getMax() {
        try {
            return (ScalarData)this.query.lookupRemoteDataId(this.query.stub.intervaldata_getMax(this.query.id(), this.dataId()));
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public boolean getMinInclusive() {
        try {
            return this.query.stub.intervaldata_getMinInclusive(this.query.id(), this.dataId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public boolean getMaxInclusive() {
        try {
            return this.query.stub.intervaldata_getMaxInclusive(this.query.id(), this.dataId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public boolean overlaps(Interval otherInterval) {
        if (!(otherInterval instanceof WSData)) {
            throw new UncheckedConsumerException(new ConsumerException("The EGSO web service does not accept foreign Data implementations."));
        }
        try {
            return this.query.stub.intervaldata_overlaps(this.query.id(), this.dataId(), ((WSData)otherInterval).query.id(), ((WSData)otherInterval).dataId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public boolean contains(Interval otherInterval) {
        if (!(otherInterval instanceof WSData)) {
            throw new UncheckedConsumerException(new ConsumerException("The EGSO web service does not accept foreign Data implementations."));
        }
        try {
            return this.query.stub.intervaldata_containsInterval(this.query.id(), this.dataId(), ((WSData)otherInterval).query.id(), ((WSData)otherInterval).dataId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public boolean contains(ScalarData point) {
        if (!(point instanceof WSData)) {
            throw new UncheckedConsumerException(new ConsumerException("The EGSO web service does not accept foreign Data implementations."));
        }
        try {
            return this.query.stub.intervaldata_containsScalar(this.query.id(), this.dataId(), ((WSData)point).query.id(), ((WSData)point).dataId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }
}

