/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.wsclient;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.egso.common.context.EGSOContext;
import org.egso.common.context.EGSOContextFactory;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Query;
import org.egso.consumer.api.TooBigResultsetException;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.UncheckedConsumerException;
import org.egso.consumer.webservice.QueryWS;
import org.egso.consumer.wsclient.WSData;
import org.egso.consumer.wsclient.WSFileHandleData;
import org.egso.consumer.wsclient.WSImageReaderData;
import org.egso.consumer.wsclient.WSIntervalData;
import org.egso.consumer.wsclient.WSScalarData;
import org.egso.consumer.wsclient.WSType;
import org.egso.consumer.wsclient.WSVOTableReaderData;
import org.egso.consumer.wsclient.session.WSSession;

public class WSQuery
implements Query {
    public final QueryWS stub;
    private final WSSession session;
    private final String query_id;
    private Map q2d = new HashMap();
    private Map q2t = new HashMap();

    public synchronized WSData lookupRemoteDataId(String remoteDataId) {
        WSData wsdata = (WSData)this.q2d.get(remoteDataId);
        if (wsdata != null) {
            return wsdata;
        }
        try {
            int data_specialisation = this.stub.data_interfaces(this.query_id, remoteDataId);
            if (data_specialisation == 3) {
                wsdata = new WSIntervalData(this, remoteDataId);
            } else if (data_specialisation == 1) {
                wsdata = new WSFileHandleData(this, remoteDataId);
            } else if (data_specialisation == 4) {
                wsdata = new WSScalarData(this, remoteDataId);
            } else if (data_specialisation == 2) {
                wsdata = new WSImageReaderData(this, remoteDataId);
            } else if (data_specialisation == 5) {
                wsdata = new WSVOTableReaderData(this, remoteDataId);
            }
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
        if (wsdata == null) {
            wsdata = new WSData(this, remoteDataId);
        }
        this.q2d.put(remoteDataId, wsdata);
        return wsdata;
    }

    public synchronized WSType lookupRemoteTypeId(String remoteTypeId) {
        WSType wstype = (WSType)this.q2t.get(remoteTypeId);
        if (wstype != null) {
            return wstype;
        }
        wstype = new WSType(this, remoteTypeId);
        this.q2t.put(remoteTypeId, wstype);
        return wstype;
    }

    public WSQuery(QueryWS stub, WSSession session) throws ConsumerException, RemoteException {
        this.stub = stub;
        this.session = session;
        this.query_id = stub.newQuery();
    }

    public void dispose() {
        try {
            this.stub.disposeQuery(this.query_id);
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public String id() {
        return this.query_id;
    }

    public Collection findAll() throws ConsumerException {
        try {
            String[] alla = this.stub.findAll(this.query_id);
            LinkedList<String> allc = new LinkedList<String>();
            int i = 0;
            while (i < alla.length) {
                allc.add(alla[i]);
                ++i;
            }
            return allc;
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
    }

    public Collection findAllResults() throws ConsumerException {
        try {
            String[] alla = this.stub.findAllResults(this.query_id);
            LinkedList<String> allc = new LinkedList<String>();
            int i = 0;
            while (i < alla.length) {
                allc.add(alla[i]);
                ++i;
            }
            return allc;
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
    }

    public Collection findAllParameters() throws ConsumerException {
        try {
            String[] alla = this.stub.findAllParameters(this.query_id);
            LinkedList<String> allc = new LinkedList<String>();
            int i = 0;
            while (i < alla.length) {
                allc.add(alla[i]);
                ++i;
            }
            return allc;
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
    }

    public Collection affectedBy(String data_key) throws ArgumentException, ConsumerException {
        try {
            String[] alla = this.stub.affectedBy(this.query_id, data_key);
            LinkedList<String> allc = new LinkedList<String>();
            int i = 0;
            while (i < alla.length) {
                allc.add(alla[i]);
                ++i;
            }
            return allc;
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
    }

    public Collection affects(String data_key) throws ArgumentException, ConsumerException {
        try {
            String[] alla = this.stub.affects(this.query_id, data_key);
            LinkedList<String> allc = new LinkedList<String>();
            int i = 0;
            while (i < alla.length) {
                allc.add(alla[i]);
                ++i;
            }
            return allc;
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
    }

    public Collection requires(String data_key) throws ConsumerException {
        try {
            String[] alla = this.stub.requires(this.query_id, data_key);
            LinkedList<String> allc = new LinkedList<String>();
            int i = 0;
            while (i < alla.length) {
                allc.add(alla[i]);
                ++i;
            }
            return allc;
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
    }

    public Collection catalogues() throws ConsumerException {
        try {
            String[] alla = this.stub.catalogues(this.query_id);
            LinkedList<String> allc = new LinkedList<String>();
            int i = 0;
            while (i < alla.length) {
                allc.add(alla[i]);
                ++i;
            }
            return allc;
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
    }

    public Collection findByCatalogue(String catalogue_key) throws ConsumerException {
        try {
            String[] alla = this.stub.findByCatalogue(this.query_id, catalogue_key);
            LinkedList<String> allc = new LinkedList<String>();
            int i = 0;
            while (i < alla.length) {
                allc.add(alla[i]);
                ++i;
            }
            return allc;
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
    }

    public boolean readonly(String data_key) throws ArgumentException, ConsumerException {
        try {
            return this.stub.readonly(this.query_id, data_key);
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
    }

    public boolean isSet(String data_key) throws ArgumentException {
        try {
            return this.stub.isSet(this.query_id, data_key);
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public void unset(String data_key) throws ArgumentException, ConsumerException {
        try {
            this.stub.unset(this.query_id, data_key);
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
    }

    public String getQuerySource(String data_key) throws ArgumentException, ConsumerException {
        try {
            return this.stub.getQuerySource(this.query_id, data_key);
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
    }

    public void setValue(String data_key, Object value) throws ArgumentException, ConsumerException {
        try {
            if (value instanceof String) {
                this.stub.setValue(this.query_id, data_key, (String)value);
                return;
            }
            if (value instanceof String[]) {
                this.stub.setValues(this.query_id, data_key, (String[])value);
                return;
            }
            if (value instanceof Object[]) {
                try {
                    String[] strings = new String[((Object[])value).length];
                    int i = 0;
                    while (i < strings.length) {
                        strings[i] = (String)((Object[])value)[i];
                        ++i;
                    }
                    this.setValue(data_key, strings);
                    return;
                }
                catch (ClassCastException ex) {
                }
            } else if (value instanceof Data) {
                this.set(data_key, (Data)value);
                return;
            }
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
        throw new ArgumentException("The web service EGSO accepts only string or string[] objects for this operaton.");
    }

    public Data get(String data_key) throws ArgumentException, ConsumerException {
        try {
            return this.lookupRemoteDataId(this.stub.get(this.query_id, data_key));
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
    }

    public Data getResult(String data_key) throws ArgumentException, TooBigResultsetException, ConsumerException {
        try {
            return this.lookupRemoteDataId(this.stub.getResult(this.query_id, data_key));
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
    }

    public void set(String data_key, Data value) throws ArgumentException, ConsumerException {
        if (!(value instanceof WSData)) {
            throw new ArgumentException("The web service EGSO accepts only its own data instances.");
        }
        try {
            this.stub.set(this.query_id, data_key, ((WSData)value).dataId());
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
    }

    public EGSOContext getContext(String data_key) throws ArgumentException, ConsumerException {
        try {
            int role = this.stub.getEGSOContextRole();
            String consumerId = this.stub.getConsumerId();
            String consumerVersion = this.stub.getConsumerVersion();
            String hostAddress = this.stub.getHostAddress();
            return EGSOContextFactory.newInstance((int)role, (String)consumerId, (String)consumerVersion, (String)hostAddress).createContext(this.stub.getContext(this.query_id, data_key));
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
    }

    public Type getType(String data_key) throws ArgumentException, ConsumerException {
        try {
            return this.lookupRemoteTypeId(this.stub.getType(this.id(), data_key));
        }
        catch (RemoteException ex) {
            throw new ConsumerException((Throwable)ex);
        }
    }
}

