/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.wsclient;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.UncheckedConsumerException;
import org.egso.consumer.util.ObservableHashMap;
import org.egso.consumer.wsclient.WSQuery;

public class WSType
implements Type {
    protected final WSQuery query;
    protected final String remoteTypeId;

    public WSType(WSQuery q, String dId) {
        this.query = q;
        this.remoteTypeId = dId;
    }

    public String typeId() {
        return this.remoteTypeId;
    }

    public boolean isEnum() {
        try {
            return this.query.stub.type_isEnum(this.query.id(), this.typeId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public boolean isList() {
        try {
            return this.query.stub.type_isList(this.query.id(), this.typeId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public boolean isCompound() {
        try {
            return this.query.stub.type_isCompound(this.query.id(), this.typeId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public String typeName() {
        try {
            return this.query.stub.type_typeName(this.query.id(), this.typeId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public String UCDType() {
        try {
            return this.query.stub.type_UCDType(this.query.id(), this.typeId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public String unit() {
        try {
            return this.query.stub.type_unit(this.query.id(), this.typeId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public Data newData() throws ConsumerException {
        try {
            return this.query.lookupRemoteDataId(this.query.stub.type_newData(this.query.id(), this.typeId()));
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public Data newData(Object initialValue) throws ConsumerException {
        if (initialValue != null && !(initialValue instanceof String)) {
            throw new ConsumerException("The EGSO webservice supports String for transportation exclusively.");
        }
        try {
            return this.query.lookupRemoteDataId(this.query.stub.type_newData(this.query.id(), this.typeId(), (String)initialValue));
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public Type elementsType() {
        try {
            return this.query.lookupRemoteTypeId(this.query.stub.type_elementsType(this.query.id(), this.typeId()));
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public Data valueDomain() throws ConsumerException {
        try {
            return this.query.lookupRemoteDataId(this.query.stub.type_valueDomain(this.query.id(), this.typeId()));
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public boolean distinct() {
        try {
            return this.query.stub.type_distinct(this.query.id(), this.typeId());
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public Object clone() {
        try {
            return this.query.lookupRemoteTypeId(this.query.stub.type_clone(this.query.id(), this.typeId()));
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }

    public Map childrenTypes() {
        try {
            String[][] cs = this.query.stub.type_childrenTypes(this.query.id(), this.typeId());
            HashMap<String, WSType> cm = new HashMap<String, WSType>();
            int i = 0;
            while (i < cs.length) {
                cm.put(cs[i][0], this.query.lookupRemoteTypeId(cs[i][1]));
                ++i;
            }
            return new ObservableHashMap(cm){

                public synchronized Object put(Object key, Object value) {
                    try {
                        if (!(key instanceof String)) {
                            throw new UncheckedConsumerException((ConsumerException)((Object)new ArgumentException("unsupported key type: " + (key != null ? key.getClass().getName() : "null") + " " + "(only String allowed as keys")));
                        }
                        if (value instanceof Type) {
                            if (!(value instanceof WSType)) {
                                throw new UncheckedConsumerException((ConsumerException)((Object)new ArgumentException("The EGSO web service does not support foreign Type impls.")));
                            }
                        } else {
                            throw new UncheckedConsumerException((ConsumerException)((Object)new ArgumentException("unsupported Type class: " + (value != null ? value.getClass().getName() : "null"))));
                        }
                        WSType.this.query.lookupRemoteTypeId(WSType.this.query.stub.type_childrentypes_putType(WSType.this.query.id(), WSType.this.typeId(), (String)key, ((WSType)value).query.id(), ((WSType)value).typeId()));
                        return super.put(key, value);
                    }
                    catch (RemoteException ex) {
                        throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
                    }
                }

                public synchronized Object remove(Object key) {
                    try {
                        if (!(key instanceof String)) {
                            throw new UncheckedConsumerException((ConsumerException)((Object)new ArgumentException("unsupported key type: " + (key != null ? key.getClass().getName() : "null") + " " + "(only String allowed as keys")));
                        }
                        WSType.this.query.lookupRemoteTypeId(WSType.this.query.stub.type_childrentypes_remove(WSType.this.query.id(), WSType.this.typeId(), (String)key));
                        return super.remove(key);
                    }
                    catch (RemoteException ex) {
                        throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
                    }
                }
            };
        }
        catch (RemoteException ex) {
            throw new UncheckedConsumerException(new ConsumerException((Throwable)ex));
        }
    }
}

