/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap.impl;

import com.sun.org.apache.xerces.internal.dom.ElementNSImpl;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.xml.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.messaging.saaj.soap.SOAPDocument;
import com.sun.xml.messaging.saaj.soap.SOAPDocumentImpl;
import com.sun.xml.messaging.saaj.soap.impl.TextImpl;
import com.sun.xml.messaging.saaj.soap.name.NameImpl;
import com.sun.xml.messaging.saaj.util.JaxmURI;
import com.sun.xml.messaging.saaj.util.NamespaceContextIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Text;

public class ElementImpl
extends ElementNSImpl
implements SOAPElement,
SOAPBodyElement {
    private AttributeManager encodingStyleAttribute = new AttributeManager();
    protected Name elementQName;
    protected static Logger log = Logger.getLogger("javax.xml.messaging.saaj.soap.impl", "com.sun.xml.messaging.saaj.soap.impl.LocalStrings");

    public void detachNode() {
        org.w3c.dom.Node parent = this.getParentNode();
        if (parent != null) {
            parent.removeChild(this);
        }
        this.encodingStyleAttribute.clearName();
        this.tryToFindEncodingStyleAttributeName();
    }

    protected void findEncodingStyleAttributeName() throws SOAPException {
        String soapNamespacePrefix;
        String soapNamespace = this.getSOAPNamespace();
        if (soapNamespace != null && (soapNamespacePrefix = this.getNamespacePrefix(soapNamespace)) != null) {
            this.setEncodingStyleNamespace(soapNamespace, soapNamespacePrefix);
        }
    }

    protected void initialize() {
        this.tryToFindEncodingStyleAttributeName();
    }

    public void recycleNode() {
        this.detachNode();
    }

    public void removeContents() {
        org.w3c.dom.Node currentChild = this.getFirstChild();
        while (currentChild != null) {
            org.w3c.dom.Node temp = currentChild.getNextSibling();
            if (currentChild instanceof Node) {
                ((Node)currentChild).detachNode();
            } else {
                org.w3c.dom.Node parent = currentChild.getParentNode();
                if (parent != null) {
                    parent.removeChild(currentChild);
                }
            }
            currentChild = temp;
        }
    }

    public void tryToFindEncodingStyleAttributeName() {
        try {
            this.findEncodingStyleAttributeName();
        }
        catch (SOAPException e) {}
    }

    protected TextImpl getValueNode() {
        Iterator i = this.getChildElements();
        while (i.hasNext()) {
            org.w3c.dom.Node n = (org.w3c.dom.Node)i.next();
            if (n.getNodeType() != 3) continue;
            this.normalize();
            TextImpl valueNode = (TextImpl)n;
            return valueNode;
        }
        return null;
    }

    public NamespaceContextIterator getNamespaceContextNodes() {
        return this.getNamespaceContextNodes(true);
    }

    public NamespaceContextIterator getNamespaceContextNodes(boolean traverseStack) {
        return new NamespaceContextIterator(this, traverseStack);
    }

    public String getEncodingStyle() {
        this.tryToFindEncodingStyleAttributeName();
        return this.encodingStyleAttribute.getValue();
    }

    protected String getSOAPNamespace() {
        String soapNamespace = null;
        ElementImpl antecedent = this;
        while (antecedent != null) {
            Name antecedentName = antecedent.getElementName();
            String antecedentNamespace = antecedentName.getURI();
            if ("http://schemas.xmlsoap.org/soap/envelope/".equals(antecedentNamespace) || "http://schemas.xmlsoap.org/soap/envelope/".equals(antecedentNamespace)) {
                soapNamespace = antecedentNamespace;
                break;
            }
            antecedent = antecedent.getParentElement();
        }
        return soapNamespace;
    }

    public String getValue() {
        TextImpl valueNode = this.getValueNode();
        return valueNode == null ? null : valueNode.getValue();
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        try {
            JaxmURI uri = new JaxmURI(encodingStyle);
        }
        catch (JaxmURI.MalformedURIException m) {
            log.log(Level.SEVERE, "SAAJ0105.impl.encoding.style.mustbe.valid.URI", new String[]{encodingStyle});
            throw new IllegalArgumentException("Encoding style (" + encodingStyle + ") should be a valid URI");
        }
        this.encodingStyleAttribute.setValue(encodingStyle);
        this.tryToFindEncodingStyleAttributeName();
    }

    public void setValue(String value) {
        org.w3c.dom.Node valueNode = this.getValueNodeStrict();
        if (valueNode != null) {
            valueNode.setNodeValue(value);
        } else {
            try {
                this.addTextNode(value);
            }
            catch (SOAPException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public boolean removeNamespaceDeclaration(String prefix) {
        Attr declaration = this.getNamespaceAttr(prefix);
        if (declaration == null) {
            return false;
        }
        this.removeAttributeNode(declaration);
        return true;
    }

    public Iterator getAllAttributes() {
        Iterator i = ElementImpl.getAllAttributesFrom(this);
        ArrayList<Name> list = new ArrayList<Name>();
        while (i.hasNext()) {
            Name name = (Name)i.next();
            if ("xmlns".equalsIgnoreCase(name.getPrefix())) continue;
            list.add(name);
        }
        return list.iterator();
    }

    protected Iterator getChildElementNodes() {
        return new Iterator(){
            Iterator eachNode;
            org.w3c.dom.Node next;
            org.w3c.dom.Node last;

            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                org.w3c.dom.Node target = this.last;
                this.last = null;
                ElementImpl.this.removeChild(target);
            }

            public boolean hasNext() {
                if (this.next == null) {
                    while (this.eachNode.hasNext()) {
                        org.w3c.dom.Node node = (org.w3c.dom.Node)this.eachNode.next();
                        if (!(node instanceof SOAPElement)) continue;
                        this.next = node;
                        break;
                    }
                }
                return this.next != null;
            }
            {
                this.eachNode = ElementImpl.this.getChildElements();
                this.next = null;
                this.last = null;
            }

            public Object next() {
                if (this.hasNext()) {
                    this.last = this.next;
                    this.next = null;
                    return this.last;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Iterator getChildElements() {
        return ElementImpl.getChildElementsFrom(this);
    }

    public Iterator getNamespacePrefixes() {
        return this.doGetNamespacePrefixes(false);
    }

    public Iterator getVisibleNamespacePrefixes() {
        return this.doGetNamespacePrefixes(true);
    }

    protected Iterator doGetNamespacePrefixes(final boolean deep) {
        return new Iterator(){
            String next = null;
            String last = null;
            NamespaceContextIterator eachNamespace = ElementImpl.this.getNamespaceContextNodes(deep);

            void findNext() {
                while (this.next == null && this.eachNamespace.hasNext()) {
                    String attributeKey = this.eachNamespace.nextNamespaceAttr().getNodeName();
                    if (!attributeKey.startsWith("xmlns:")) continue;
                    this.next = attributeKey.substring("xmlns:".length());
                }
            }

            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                this.eachNamespace.remove();
                this.next = null;
                this.last = null;
            }

            public boolean hasNext() {
                this.findNext();
                return this.next != null;
            }

            public Object next() {
                this.findNext();
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.last = this.next;
                this.next = null;
                return this.last;
            }
        };
    }

    public Name getElementName() {
        return this.elementQName;
    }

    public void ensureNamespaceIsDeclared(Name name) throws SOAPException {
        if (this.isNamespaceAware(name)) {
            String prefix = name.getPrefix();
            String uri = name.getURI();
            this.ensureNamespaceIsDeclared(prefix, uri);
        }
    }

    protected boolean isNamespaceAware(Name name) {
        return !"".equals(name.getURI());
    }

    public boolean removeAttribute(Name name) {
        String localName;
        String uri = name.getURI();
        String nonzeroLengthUri = uri == null || uri.length() == 0 ? null : uri;
        Attr attribute = this.getAttributeNodeNS(nonzeroLengthUri, localName = name.getQualifiedName());
        if (attribute == null) {
            return false;
        }
        this.removeAttributeNode(attribute);
        return true;
    }

    public SOAPElement getParentElement() {
        org.w3c.dom.Node parentNode = this.getParentNode();
        if (parentNode instanceof SOAPDocument) {
            return null;
        }
        return (SOAPElement)parentNode;
    }

    public void setParentElement(SOAPElement element) throws SOAPException {
        if (element == null) {
            log.severe("SAAJ0106.impl.no.null.to.parent.elem");
            throw new SOAPException("Cannot pass NULL to setParentElement");
        }
        element.addChildElement((SOAPElement)this);
        this.findEncodingStyleAttributeName();
    }

    public Document getOwnerDocument() {
        SOAPDocument ownerSOAPDocument = (SOAPDocument)((Object)super.getOwnerDocument());
        if (ownerSOAPDocument == null) {
            return null;
        }
        return ownerSOAPDocument.getDocument();
    }

    protected org.w3c.dom.Node getValueNodeStrict() {
        org.w3c.dom.Node node = this.getFirstChild();
        if (node != null) {
            if (node.getNextSibling() == null && node.getNodeType() == 3) {
                return node;
            }
            log.severe("SAAJ0107.impl.elem.child.not.single.text");
            throw new IllegalStateException();
        }
        return null;
    }

    protected void addNode(org.w3c.dom.Node newElement) throws SOAPException {
        this.insertBefore(newElement, null);
        if (this.getOwnerDocument() instanceof DocumentFragment) {
            return;
        }
        if (newElement instanceof ElementImpl) {
            ElementImpl element = (ElementImpl)newElement;
            Name elementName = element.getElementName();
            element.ensureNamespaceIsDeclared(element.getElementName());
        }
    }

    protected String getNamespaceForTagName(String tagName) {
        String prefix = NameImpl.getPrefixFromTagName(tagName);
        return this.getNamespaceURI(prefix);
    }

    protected String getNamespacePrefix(String uri) {
        NamespaceContextIterator eachNamespace = this.getNamespaceContextNodes();
        while (eachNamespace.hasNext()) {
            Attr namespaceDecl = eachNamespace.nextNamespaceAttr();
            if (!namespaceDecl.getNodeValue().equals(uri)) continue;
            String prefixDecl = namespaceDecl.getNodeName();
            int index = prefixDecl.indexOf(58);
            return prefixDecl.substring(index + 1);
        }
        return null;
    }

    public String getNamespaceURI(String prefix) {
        if ("xmlns".equals(prefix)) {
            return NamespaceContext.XMLNS_URI;
        }
        String namespaceUri = null;
        Attr namespaceDecl = this.getNamespaceAttr(prefix);
        if (namespaceDecl != null) {
            namespaceUri = namespaceDecl.getNodeValue();
        }
        return namespaceUri;
    }

    public void ensureNamespaceIsDeclared(String prefix, String uri) {
        block2: {
            String alreadyDeclaredUri = this.getNamespaceURI(prefix);
            if (alreadyDeclaredUri != null && alreadyDeclaredUri.equals(uri)) break block2;
            try {
                this.addNamespaceDeclaration(prefix, uri);
            }
            catch (SOAPException e) {}
        }
    }

    protected void setEncodingStyleNamespace(String soapNamespace, String soapNamespacePrefix) throws SOAPException {
        NameImpl encodingStyleAttributeName = NameImpl.create("encodingStyle", soapNamespacePrefix, soapNamespace);
        this.encodingStyleAttribute.setName(encodingStyleAttributeName);
    }

    public String getAttributeValue(Name name) {
        return ElementImpl.getAttributeValueFrom(this, name);
    }

    private void addAttributeBare(Name name, String value) {
        String uri = name.getURI();
        uri = uri.length() == 0 ? null : uri;
        String qualifiedName = name.getQualifiedName();
        if (qualifiedName.equals("xmlns")) {
            uri = NamespaceContext.XMLNS_URI;
        }
        if (uri == null && name.getPrefix().length() > 0) {
            this.setAttribute(qualifiedName, value);
        } else {
            this.setAttributeNS(uri, qualifiedName, value);
        }
    }

    public Iterator getChildElements(final Name name) {
        return new Iterator(){
            Iterator eachElement;
            org.w3c.dom.Node next;
            org.w3c.dom.Node last;

            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                org.w3c.dom.Node target = this.last;
                this.last = null;
                ElementImpl.this.removeChild(target);
            }

            public boolean hasNext() {
                if (this.next == null) {
                    while (this.eachElement.hasNext()) {
                        org.w3c.dom.Node element = (org.w3c.dom.Node)this.eachElement.next();
                        String elementUri = element.getNamespaceURI();
                        elementUri = elementUri == null ? "" : elementUri;
                        String nameUri = name.getURI();
                        String elementName = element.getLocalName();
                        String nameLocal = name.getLocalName();
                        if (!elementUri.equals(nameUri) || !elementName.equals(nameLocal)) continue;
                        this.next = element;
                        break;
                    }
                }
                return this.next != null;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.next;
                this.next = null;
                return this.last;
            }
            {
                this.eachElement = ElementImpl.this.getChildElementNodes();
                this.next = null;
                this.last = null;
            }
        };
    }

    protected static Iterator getAllAttributesFrom(final Element element) {
        final NamedNodeMap attributes = element.getAttributes();
        return new Iterator(){
            int attributesLength;
            int attributeIndex;
            String currentName;

            public void remove() {
                if (this.currentName == null) {
                    throw new IllegalStateException();
                }
                attributes.removeNamedItem(this.currentName);
            }

            public boolean hasNext() {
                return this.attributeIndex < this.attributesLength;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                org.w3c.dom.Node current = attributes.item(this.attributeIndex++);
                this.currentName = current.getNodeName();
                String prefix = NameImpl.getPrefixFromTagName(this.currentName);
                if (prefix.length() == 0) {
                    return NameImpl.createFromUnqualifiedName(this.currentName);
                }
                Name attributeName = NameImpl.createFromQualifiedName(this.currentName, ElementImpl.getNamespaceURIFrom(element, prefix));
                return attributeName;
            }
            {
                this.attributesLength = attributes.getLength();
                this.attributeIndex = 0;
            }
        };
    }

    protected static Iterator getChildElementsFrom(final Element element) {
        return new Iterator(){
            org.w3c.dom.Node next;
            org.w3c.dom.Node nextNext;
            org.w3c.dom.Node last;

            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                org.w3c.dom.Node target = this.last;
                this.last = null;
                element.removeChild(target);
            }

            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                if (this.next == null && this.nextNext != null) {
                    this.next = this.nextNext;
                }
                return this.next != null;
            }

            public Object next() {
                if (this.hasNext()) {
                    this.last = this.next;
                    this.next = null;
                    if (element instanceof ElementImpl && this.last instanceof Element) {
                        this.last = ((ElementImpl)element).convertToSoapElement((Element)this.last);
                    }
                    this.nextNext = this.last.getNextSibling();
                    return this.last;
                }
                throw new NoSuchElementException();
            }
            {
                this.next = element.getFirstChild();
                this.nextNext = null;
                this.last = null;
            }
        };
    }

    public ElementImpl(SOAPDocumentImpl ownerDoc, Name name) {
        super(ownerDoc, name.getURI(), name.getQualifiedName(), name.getLocalName());
        this.elementQName = name;
        this.initialize();
    }

    protected SOAPElement findChild(NameImpl name) {
        Iterator eachChild = this.getChildElementNodes();
        while (eachChild.hasNext()) {
            SOAPElement child = (SOAPElement)eachChild.next();
            if (!child.getElementName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public SOAPElement addChildElement(String localName) throws SOAPException {
        return this.addChildElement(NameImpl.createFromUnqualifiedName(localName));
    }

    protected SOAPElement addText(String text) throws SOAPException {
        Text textNode = this.getOwnerDocument().createTextNode(text);
        this.addNode(textNode);
        return this;
    }

    public SOAPElement addTextNode(String text) throws SOAPException {
        if (text.startsWith("<![CDATA[") || text.startsWith("<![cdata[")) {
            return (SOAPElement)this.addCDATA(text.substring("<![CDATA[".length(), text.length() - 2));
        }
        return this.addText(text);
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        NameImpl n = (NameImpl)name;
        return this.addElement(n);
    }

    protected SOAPElement addElement(Name name) throws SOAPException {
        SOAPElement newElement = this.createElement(name);
        this.addNode((org.w3c.dom.Node)newElement);
        return this.circumventBug5034339(newElement);
    }

    protected SOAPElement createElement(Name name) {
        if (this.isNamespaceAware(name)) {
            return (SOAPElement)this.getOwnerDocument().createElementNS(name.getURI(), name.getQualifiedName());
        }
        return (SOAPElement)this.getOwnerDocument().createElement(name.getQualifiedName());
    }

    public SOAPElement addChildElement(SOAPElement element) throws SOAPException {
        String elementURI = element.getElementName().getURI();
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(elementURI) || "http://www.w3.org/2002/06/soap-envelope".equals(elementURI)) {
            log.severe("SAAJ0103.impl.cannot.add.fragements");
            throw new SOAPExceptionImpl("Cannot add fragments which contain elements which are in the SOAP namespace");
        }
        element = (SOAPElement)this.importElement((Element)element);
        this.addNode((org.w3c.dom.Node)element);
        return this.convertToSoapElement((Element)this.circumventBug5034339(element));
    }

    protected SOAPElement circumventBug5034339(SOAPElement element) {
        String prefix;
        String defaultNamespace;
        Name elementName = element.getElementName();
        if (!this.isNamespaceAware(elementName) && (defaultNamespace = element.getNamespaceURI(prefix = elementName.getPrefix())) != null) {
            NameImpl newElementName = NameImpl.create(elementName.getLocalName(), elementName.getPrefix(), defaultNamespace);
            SOAPElement newElement = this.createElement(newElementName);
            this.replaceChild((org.w3c.dom.Node)newElement, (org.w3c.dom.Node)element);
            return newElement;
        }
        return element;
    }

    protected SOAPElement convertToSoapElement(Element element) {
        if (element instanceof SOAPElement) {
            return (SOAPElement)element;
        }
        return ElementImpl.replaceElementWithSOAPElement(element, (ElementImpl)this.createElement(NameImpl.copyElementName(element)));
    }

    protected Attr getNamespaceAttr(String prefix) {
        NamespaceContextIterator eachNamespace = this.getNamespaceContextNodes();
        if (!"".equals(prefix)) {
            prefix = ":" + prefix;
        }
        while (eachNamespace.hasNext()) {
            Attr namespaceDecl = eachNamespace.nextNamespaceAttr();
            if (!(!"".equals(prefix) ? namespaceDecl.getNodeName().endsWith(prefix) : namespaceDecl.getNodeName().equals("xmlns"))) continue;
            return namespaceDecl;
        }
        return null;
    }

    protected Element importElement(Element element) {
        Document document = this.getOwnerDocument();
        Document oldDocument = element.getOwnerDocument();
        if (!oldDocument.equals(document)) {
            return (Element)document.importNode(element, true);
        }
        return element;
    }

    protected Text addCDATA(String text) throws SOAPException {
        CDATASection cdata = this.getOwnerDocument().createCDATASection(text);
        this.addNode(cdata);
        return cdata;
    }

    public ElementImpl(SOAPDocumentImpl ownerDoc, String uri, String qualifiedName) {
        super(ownerDoc, uri, qualifiedName);
        this.elementQName = NameImpl.createFromQualifiedName(qualifiedName, uri);
        this.initialize();
    }

    public static String getNamespaceURIFrom(Element impl, String prefix) {
        if ("xmlns".equals(prefix)) {
            return NamespaceContext.XMLNS_URI;
        }
        Attr namespaceDecl = ElementImpl.getNamespaceAttrFrom(impl, prefix);
        if (namespaceDecl != null) {
            return namespaceDecl.getNodeValue();
        }
        return null;
    }

    protected static String getAttributeValueFrom(Element element, Name name) {
        boolean mustUseGetAttributeNodeNS;
        String uri = name.getURI();
        String nonzeroLengthUri = uri == null || uri.length() == 0 ? null : uri;
        Attr attribute = null;
        boolean bl = mustUseGetAttributeNodeNS = name.getPrefix() == null && nonzeroLengthUri != null;
        if (mustUseGetAttributeNodeNS) {
            attribute = element.getAttributeNodeNS(nonzeroLengthUri, name.getLocalName());
        } else {
            boolean useGetAttributeNodeNSAsFallback;
            attribute = element.getAttributeNode(name.getQualifiedName());
            boolean bl2 = useGetAttributeNodeNSAsFallback = attribute == null && nonzeroLengthUri != null;
            if (useGetAttributeNodeNSAsFallback) {
                attribute = element.getAttributeNodeNS(nonzeroLengthUri, name.getLocalName());
            }
        }
        return attribute == null ? null : attribute.getValue();
    }

    protected static SOAPElement replaceElementWithSOAPElement(Element element, ElementImpl copy) {
        Iterator eachAttribute = ElementImpl.getAllAttributesFrom(element);
        while (eachAttribute.hasNext()) {
            Name name = (Name)eachAttribute.next();
            copy.addAttributeBare(name, ElementImpl.getAttributeValueFrom(element, name));
        }
        Iterator eachChild = ElementImpl.getChildElementsFrom(element);
        while (eachChild.hasNext()) {
            org.w3c.dom.Node nextChild = (org.w3c.dom.Node)eachChild.next();
            copy.insertBefore(nextChild, null);
        }
        org.w3c.dom.Node parent = element.getParentNode();
        if (parent != null) {
            parent.replaceChild(copy, element);
        }
        return copy;
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        String uri = this.getNamespaceURI(prefix);
        if (uri == null) {
            log.log(Level.SEVERE, "SAAJ0101.impl.parent.of.body.elem.mustbe.body", new String[]{prefix});
            throw new SOAPExceptionImpl("Unable to locate namespace for prefix " + prefix);
        }
        return this.addChildElement(localName, prefix, uri);
    }

    public SOAPElement addNamespaceDeclaration(String prefix, String uri) throws SOAPException {
        log.log(Level.FINE, "SAAJ0150.impl.added.attr", new String[]{"xmlns = " + prefix + " uri = " + uri});
        if (prefix.length() > 0) {
            this.setAttributeNS(NamespaceContext.XMLNS_URI, "xmlns:" + prefix, uri);
        } else {
            this.setAttributeNS(NamespaceContext.XMLNS_URI, "xmlns", uri);
        }
        this.tryToFindEncodingStyleAttributeName();
        return this;
    }

    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        this.addAttributeBare(name, value);
        this.ensureNamespaceIsDeclared(name);
        return this;
    }

    protected static Attr getNamespaceAttrFrom(Element element, String prefix) {
        NamespaceContextIterator eachNamespace = new NamespaceContextIterator(element);
        while (eachNamespace.hasNext()) {
            Attr namespaceDecl = eachNamespace.nextNamespaceAttr();
            String declaredPrefix = NameImpl.getLocalNameFromTagName(namespaceDecl.getNodeName());
            if (!declaredPrefix.equals(prefix)) continue;
            return namespaceDecl;
        }
        return null;
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        return this.addChildElement(NameImpl.create(localName, prefix, uri));
    }

    class AttributeManager {
        Name attributeName = null;
        String attributeValue = null;

        private void clearAttribute() {
            if (this.attributeName != null) {
                ElementImpl.this.removeAttribute(this.attributeName);
            }
        }

        public void clearName() {
            this.clearAttribute();
            this.attributeName = null;
        }

        private void reconcileAttribute() throws SOAPException {
            if (this.attributeName != null) {
                ElementImpl.this.removeAttribute(this.attributeName);
                if (this.attributeValue != null) {
                    ElementImpl.this.addAttribute(this.attributeName, this.attributeValue);
                }
            }
        }

        AttributeManager() {
        }

        public String getValue() {
            return this.attributeValue;
        }

        public void setValue(String value) throws SOAPException {
            this.attributeValue = value;
            this.reconcileAttribute();
        }

        public Name getName() {
            return this.attributeName;
        }

        public void setName(Name newName) throws SOAPException {
            this.clearAttribute();
            this.attributeName = newName;
            this.reconcileAttribute();
        }
    }
}

