/*
 * Decompiled with CFR 0.152.
 */
package org.egso.common.configuration;

import java.io.File;
import java.net.URL;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalXMLConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Logger;

class NamedConfiguration {
    private static final String[] DEFAULT_PREFIX_SEQUENCE = new String[]{"test", "local", "default"};
    private static final String DEFAULT_DELIMITER = "-";
    private String delimiter = "-";
    private String[] prefixSequence = DEFAULT_PREFIX_SEQUENCE;
    private String name = null;
    private String path = null;
    private String module = null;
    private String submodule = null;
    private Configuration configuration = null;
    static /* synthetic */ Class class$org$egso$common$configuration$NamedConfigurationFactory;

    protected NamedConfiguration(String name, String path, String module, String submodule) {
        if (name == null) {
            throw new IllegalArgumentException("'name' of configuration must not be null.");
        }
        if (path == null) {
            throw new IllegalArgumentException("'path' of configuration must not be null.");
        }
        if (module == null) {
            throw new IllegalArgumentException("'module' of configuration must not be null.");
        }
        this.name = name;
        this.path = !path.endsWith("/") && !path.endsWith("\\") ? path + "/" : path;
        this.module = module;
        this.submodule = submodule;
        this.initialize();
    }

    private synchronized void initialize() {
        CompositeConfiguration config = null;
        config = new CompositeConfiguration();
        for (int i = 0; i < this.prefixSequence.length; ++i) {
            String fileNamePart1;
            File configFile;
            boolean found = false;
            StringBuffer sb = new StringBuffer();
            sb.append(this.path).append(this.prefixSequence[i]).append(this.delimiter).append(this.module);
            if (this.submodule != null) {
                sb.append(this.delimiter).append(this.submodule);
            }
            if ((configFile = this.findConfigFile((fileNamePart1 = sb.toString()) + ".xml")) != null) {
                found = true;
                try {
                    HierarchicalXMLConfiguration xmlConfig = new HierarchicalXMLConfiguration();
                    xmlConfig.load(configFile);
                    config.addConfiguration((Configuration)xmlConfig);
                }
                catch (Exception e) {
                    Logger.getLogger((Class)(class$org$egso$common$configuration$NamedConfigurationFactory == null ? NamedConfiguration.class$("org.egso.common.configuration.NamedConfigurationFactory") : class$org$egso$common$configuration$NamedConfigurationFactory)).warn((Object)(e.getClass().getName() + " while loading configuration '" + configFile.getName() + "' :" + e.getMessage()), (Throwable)e);
                }
            }
            if ((configFile = this.findConfigFile(fileNamePart1 + ".properties")) != null) {
                found = true;
                try {
                    config.addConfiguration((Configuration)new PropertiesConfiguration(configFile.getName()));
                }
                catch (Exception e) {
                    Logger.getLogger((Class)(class$org$egso$common$configuration$NamedConfigurationFactory == null ? NamedConfiguration.class$("org.egso.common.configuration.NamedConfigurationFactory") : class$org$egso$common$configuration$NamedConfigurationFactory)).warn((Object)(e.getClass().getName() + " while loading configuration '" + configFile.getName() + "' :" + e.getMessage()), (Throwable)e);
                }
            }
            if (i != this.prefixSequence.length - 1 || found) continue;
            Logger.getLogger((Class)(class$org$egso$common$configuration$NamedConfigurationFactory == null ? NamedConfiguration.class$("org.egso.common.configuration.NamedConfigurationFactory") : class$org$egso$common$configuration$NamedConfigurationFactory)).warn((Object)("no default configuration with prefix '" + this.prefixSequence[i] + this.delimiter + "' found!"));
        }
        this.configuration = config;
    }

    public void release() {
        this.name = null;
        this.module = null;
        this.submodule = null;
        this.path = null;
        this.configuration = null;
    }

    private File findConfigFile(String fileName) {
        URL fileUrl = null;
        fileUrl = this.getClass().getResource(fileName.startsWith("/") || fileName.startsWith("\\") ? fileName : "/" + fileName);
        if (fileUrl != null) {
            return new File(fileUrl.getFile());
        }
        File file = new File(fileName);
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getModule() {
        return this.module;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getSubmodule() {
        return this.submodule;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

