/*
 * Decompiled with CFR 0.152.
 */
package org.egso.common.configuration;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.egso.common.configuration.NamedConfiguration;

public class NamedConfigurationFactory {
    private static Map configMap = new HashMap();

    public static Configuration addNamedConfiguration(String configName, String path, String module, String submodule) {
        if (NamedConfigurationFactory.getConfigurationByName(configName) != null) {
            throw new IllegalArgumentException("Configuration with name " + configName + " already exists.");
        }
        NamedConfiguration namedConfig = new NamedConfiguration(configName, path, module, submodule);
        configMap.put(configName, namedConfig);
        return namedConfig.getConfiguration();
    }

    public static Configuration addNamedConfiguration(String configName, String path, String module) {
        return NamedConfigurationFactory.addNamedConfiguration(configName, path, module, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeNamedConfiguration(String configName) {
        Map map = configMap;
        synchronized (map) {
            NamedConfiguration config = (NamedConfiguration)configMap.get(configName);
            if (config != null) {
                config.release();
                configMap.remove(config);
            }
        }
    }

    public Configuration replaceConfiguration(String configName, String path, String module, String submodule) {
        NamedConfigurationFactory.removeNamedConfiguration(configName);
        return NamedConfigurationFactory.addNamedConfiguration(configName, path, module, submodule);
    }

    public Configuration replaceConfiguration(String configName, String path, String module) {
        NamedConfigurationFactory.removeNamedConfiguration(configName);
        return NamedConfigurationFactory.addNamedConfiguration(configName, path, module);
    }

    public static Configuration getConfigurationByName(String configName) {
        NamedConfiguration config = (NamedConfiguration)configMap.get(configName);
        if (config != null) {
            return config.getConfiguration();
        }
        return null;
    }

    private NamedConfigurationFactory() {
    }
}

