/*
 * Decompiled with CFR 0.152.
 */
package org.egso.common.context;

import java.io.ByteArrayInputStream;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EGSOContext {
    public static final int CONTEXT_UNKNOWN = 0;
    public static final int CONTEXT_QUERY = 1;
    public static final int CONTEXT_RESULT = 2;
    public static final int CONTEXT_SERVICE = 3;
    public static final int CONTEXT_FILES = 4;
    public static final int PARAMETER_WARNING = 0;
    public static final int PARAMETER_USERINFO = 1;
    public static final int PARAMETER_SYSTEMINFO = 2;
    public static final int PARAMETER_DEBUG = 3;
    public static final int ROLE_PROVIDER = 0;
    public static final int ROLE_CONSUMER = 1;
    public static final int ROLE_BROKER = 2;
    public static final int ROLE_UNKNOWN = 3;
    public static final int EXCEPTION_CRITICAL = 0;
    public static final int EXCEPTION_ERROR = 1;
    public static final int EXCEPTION_WARNING = 2;
    private static final String[] typeNames = new String[]{"unknown", "query", "result", "service", "files"};
    private static final String[] paramNames = new String[]{"warning", "userinfo", "systeminfo", "debug"};
    private static final String[] exceptionNames = new String[]{"critical", "error", "warning"};
    private static final String[] roleNames = new String[]{"provider", "consumer", "broker", "unknown"};
    private int type = 0;
    private String id = null;
    private Hashtable parameters = null;
    private Vector routes = null;
    private Vector exceptions = null;
    private String rolename = null;
    private String roleip = null;
    private String roleversion = null;
    private int roletype = 3;

    EGSOContext(int cxt_type, int roleType, String roleName, String roleVersion, String roleIP) {
        this.type = cxt_type;
        this.roletype = roleType;
        this.rolename = roleName;
        this.roleversion = roleVersion;
        this.roleip = roleIP;
        this.init(null);
    }

    EGSOContext(int cxt_type, int roleType, String cxtID, String roleName, String roleVersion, String roleIP) {
        this.type = cxt_type;
        this.id = cxtID;
        this.roletype = roleType;
        this.rolename = roleName;
        this.roleversion = roleVersion;
        this.roleip = roleIP;
        this.init(null);
    }

    EGSOContext(String xml, int roleType, String roleName, String roleVersion, String roleIP) {
        this.roletype = roleType;
        this.rolename = roleName;
        this.roleversion = roleVersion;
        this.roleip = roleIP;
        this.init(xml);
    }

    public void setID(String newID) {
        this.id = newID;
    }

    public void setType(int cxtType) {
        this.type = cxtType;
    }

    public String getID() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeAsString() {
        return typeNames[this.type];
    }

    public Collection getExceptions() {
        return this.exceptions;
    }

    public Collection getExceptionsAsXML() {
        Vector<String> results = new Vector<String>();
        StringBuffer sb = new StringBuffer();
        String[] tmp = null;
        Iterator it = this.exceptions.iterator();
        while (it.hasNext()) {
            tmp = (String[])it.next();
            sb = new StringBuffer();
            sb.append("<exception role=\"" + tmp[0] + "\" origin=\"" + tmp[1] + "\" type=\"" + tmp[2] + "\">");
            sb.append("<message>" + tmp[3] + "</message><class>" + tmp[4] + "</class>");
            sb.append("<stacktrace>" + tmp[5] + "</stacktrace></exception>");
            results.add(sb.toString());
        }
        return results;
    }

    public Collection getExceptions(String criteria, int value) {
        if ((criteria = criteria.toLowerCase()).equals("role")) {
            return this.getExceptions(criteria, roleNames[value], true);
        }
        if (criteria.equals("type")) {
            return this.getExceptions(criteria, exceptionNames[value], true);
        }
        return new Vector();
    }

    public Collection getExceptions(String criteria, String value) {
        return this.getExceptions(criteria, value, false);
    }

    public Collection getExceptionsAsXML(String criteria, String value) {
        return this.getExceptions(criteria, value, true);
    }

    public Collection getExceptionsAsXML(String criteria, int value) {
        if ((criteria = criteria.toLowerCase()).equals("role")) {
            return this.getExceptions(criteria, roleNames[value], true);
        }
        if (criteria.equals("type")) {
            return this.getExceptions(criteria, exceptionNames[value], true);
        }
        return new Vector();
    }

    private Collection getExceptions(String criteria, String value, boolean xml) {
        Vector<Object> results = new Vector<Object>();
        criteria = criteria.toLowerCase();
        value = value.toLowerCase();
        int index = 0;
        if (criteria.equals("role")) {
            index = 0;
        } else if (criteria.equals("origin")) {
            index = 1;
        } else if (criteria.equals("type")) {
            index = 2;
        } else if (criteria.equals("message")) {
            index = 3;
        } else if (criteria.equals("classname")) {
            index = 4;
        } else if (criteria.equals("stacktrace")) {
            index = 5;
        } else {
            return results;
        }
        String[] tmp = null;
        Iterator it = this.exceptions.iterator();
        while (it.hasNext()) {
            tmp = (String[])it.next();
            if (!tmp[index].toLowerCase().equals(value)) continue;
            if (xml) {
                StringBuffer sb = new StringBuffer();
                sb.append("<exception role=\"" + tmp[0] + "\" origin=\"" + tmp[1] + "\" type=\"" + tmp[2] + "\">");
                sb.append("<message>" + tmp[3] + "</message><class>" + tmp[4] + "</class>");
                sb.append("<stacktrace>" + tmp[5] + "</stacktrace></exception>");
                results.add(sb.toString());
                continue;
            }
            results.add(tmp);
        }
        return results;
    }

    public Collection getRoutesAsXML() {
        Vector<String> results = new Vector<String>();
        String[] tmp = null;
        Iterator it = this.routes.iterator();
        while (it.hasNext()) {
            tmp = (String[])it.next();
            results.add("<route role=\"" + tmp[0] + "\" rolename=\"" + tmp[1] + "\" role-ip=\"" + tmp[2] + "\" role-version=\"" + tmp[3] + "\" time=\"" + tmp[4] + "\" action=\"" + tmp[5] + "\">" + tmp[6] + "</route>");
        }
        return results;
    }

    public Collection getRoutes() {
        return this.routes;
    }

    public Collection getRoutes(String criteria, int value) {
        if ((criteria = criteria.toLowerCase()).equals("role")) {
            return this.getRoutes(criteria, roleNames[value], false);
        }
        return new Vector();
    }

    public Collection getRoutes(String criteria, String value) {
        return this.getRoutes(criteria, value, false);
    }

    public Collection getRoutesAsXML(String criteria, String value) {
        return this.getRoutes(criteria, value, true);
    }

    public Collection getRoutesAsXML(String criteria, int value) {
        if ((criteria = criteria.toLowerCase()).equals("role")) {
            return this.getRoutes(criteria, roleNames[value], true);
        }
        return new Vector();
    }

    private Collection getRoutes(String criteria, String value, boolean xml) {
        int index;
        Vector<Object> results = new Vector<Object>();
        criteria = criteria.toLowerCase();
        value = value.toLowerCase();
        String[] crits = new String[]{"role", "rolename", "role-ip", "role-version", "time", "action", "description"};
        boolean found = false;
        for (index = 0; !found && index < crits.length; ++index) {
            found = criteria.equals(crits[index]);
        }
        --index;
        if (!found) {
            return results;
        }
        String[] tmp = null;
        Iterator it = this.routes.iterator();
        while (it.hasNext()) {
            tmp = (String[])it.next();
            if (!tmp[index].toLowerCase().equals(value)) continue;
            if (xml) {
                results.add("<route role=\"" + tmp[0] + "\" rolename=\"" + tmp[1] + "\" role-ip=\"" + tmp[2] + "\" role-version=\"" + tmp[3] + "\" time=\"" + tmp[4] + "\" action=\"" + tmp[5] + "\">" + tmp[6] + "</route>");
                continue;
            }
            results.add(tmp);
        }
        return results;
    }

    public int getNumberOfRoutes() {
        return this.routes.size();
    }

    public int getNumberOfExceptions() {
        return this.exceptions.size();
    }

    public Collection getParameterNames() {
        Vector<String> names = new Vector<String>();
        Enumeration e = this.parameters.keys();
        while (e.hasMoreElements()) {
            names.add((String)e.nextElement());
        }
        return names;
    }

    public String getParameter(String name) {
        String[] obj = (String[])this.parameters.get(name);
        if (obj != null) {
            return obj[1];
        }
        return null;
    }

    public String getParameterAsXML(String name) {
        String[] obj = (String[])this.parameters.get(name);
        if (obj != null) {
            return "<parameter type=\"" + obj[0] + "\" name=\"" + name + "\" value=\"" + obj[1] + "\"/>";
        }
        return null;
    }

    public Collection getParameters(int paramType) {
        Vector<String> results = new Vector<String>();
        String val = paramNames[paramType];
        String key = null;
        String[] tmp = null;
        Enumeration e = this.parameters.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            tmp = (String[])this.parameters.get(key);
            if (!tmp[0].equals(val)) continue;
            results.add("<parameter type=\"" + tmp[0] + "\" name=\"" + key + "\" value=\"" + tmp[1] + "\"/>");
        }
        return results;
    }

    private void init(String xml) {
        this.parameters = new Hashtable();
        this.exceptions = new Vector();
        this.routes = new Vector();
        if (xml == null) {
            return;
        }
        Element node = null;
        try {
            DocumentBuilderFactory facto = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = facto.newDocumentBuilder();
            InputSource is = new InputSource(new ByteArrayInputStream(xml.getBytes()));
            node = builder.parse(is).getDocumentElement();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
        NodeList nl = node.getChildNodes();
        NodeList nl2 = null;
        NodeList nl3 = null;
        NodeList nl4 = null;
        Node n = null;
        Node n2 = null;
        Node n3 = null;
        Node n4 = null;
        String tmp = null;
        String text = null;
        String[] tempo = null;
        NamedNodeMap nnm = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            int k;
            int j;
            n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            tmp = n.getNodeName().toLowerCase();
            if (tmp.equals("id")) {
                this.id = n.getAttributes().getNamedItem("value").getNodeValue();
                continue;
            }
            if (tmp.equals("type")) {
                int x;
                tmp = n.getAttributes().getNamedItem("value").getNodeValue().toLowerCase();
                boolean found = false;
                for (x = 0; !found && x < typeNames.length; ++x) {
                    found = typeNames[x].equals(tmp);
                }
                if (found) {
                    this.type = x - 1;
                    continue;
                }
                this.type = 0;
                throw new RuntimeException("Type '" + tmp + "' unknown for a Context.");
            }
            if (tmp.equals("parameters")) {
                nl2 = n.getChildNodes();
                for (j = 0; j < nl2.getLength(); ++j) {
                    n2 = nl2.item(j);
                    if (n2.getNodeType() != 1) continue;
                    nnm = n2.getAttributes();
                    this.parameters.put(nnm.getNamedItem("name").getNodeValue(), new String[]{nnm.getNamedItem("type").getNodeValue(), nnm.getNamedItem("value").getNodeValue()});
                }
                continue;
            }
            if (tmp.equals("exceptions")) {
                nl2 = n.getChildNodes();
                for (j = 0; j < nl2.getLength(); ++j) {
                    n2 = nl2.item(j);
                    if (n2.getNodeType() != 1) continue;
                    nnm = n2.getAttributes();
                    tempo = new String[6];
                    tempo[0] = nnm.getNamedItem("role").getNodeValue();
                    tempo[1] = nnm.getNamedItem("origin").getNodeValue();
                    tempo[2] = nnm.getNamedItem("type").getNodeValue().toLowerCase();
                    nl3 = n2.getChildNodes();
                    for (k = 0; k < nl3.getLength(); ++k) {
                        n3 = nl3.item(k);
                        if (n3.getNodeType() != 1) continue;
                        nl4 = n3.getChildNodes();
                        text = n3.getNodeName().toLowerCase();
                        if (text.equals("message") || text.equals("class")) {
                            int index = text.equals("message") ? 3 : 4;
                            text = "";
                            for (int l = 0; l < nl4.getLength(); ++l) {
                                n4 = nl4.item(l);
                                if (n4.getNodeType() == 3) {
                                    text = text + n4.getNodeValue().trim();
                                }
                                tempo[index] = text;
                            }
                            continue;
                        }
                        for (int l = 0; l < nl4.getLength(); ++l) {
                            n4 = nl4.item(l);
                            if (n4.getNodeType() != 4) continue;
                            tempo[5] = "<![CDATA[ " + n4.getNodeValue().trim() + " ]]>";
                        }
                    }
                    this.exceptions.add(tempo);
                }
                continue;
            }
            if (!tmp.equals("traceroute")) continue;
            nl2 = n.getChildNodes();
            for (j = 0; j < nl2.getLength(); ++j) {
                n2 = nl2.item(j);
                if (n2.getNodeType() != 1) continue;
                tempo = new String[7];
                nnm = n2.getAttributes();
                tempo[0] = nnm.getNamedItem("role").getNodeValue();
                tempo[1] = nnm.getNamedItem("rolename").getNodeValue();
                tempo[2] = nnm.getNamedItem("role-ip").getNodeValue();
                tempo[3] = nnm.getNamedItem("role-version").getNodeValue();
                tempo[4] = nnm.getNamedItem("time").getNodeValue();
                tempo[5] = nnm.getNamedItem("action").getNodeValue();
                nl3 = n2.getChildNodes();
                text = "";
                for (k = 0; k < nl3.getLength(); ++k) {
                    n4 = nl3.item(k);
                    if (n4.getNodeType() != 3) continue;
                    text = text + n4.getNodeValue().trim();
                }
                tempo[6] = text;
                this.routes.add(tempo);
            }
        }
        if (this.type == -1) {
            throw new RuntimeException("The type of the query must be defined in the XML description.");
        }
    }

    public void addException(String exception) {
        String[] tmp = new String[6];
        int start = exception.indexOf("role=\"") + 6;
        if (start == 5) {
            throw new RuntimeException("Misformed exception: Attribute 'role' is not defined in the node exception.");
        }
        int end = exception.indexOf("\"", start);
        tmp[0] = exception.substring(start, end);
        start = exception.indexOf("origin=\"") + 8;
        if (start == 7) {
            throw new RuntimeException("Misformed exception: Attribute 'origin' is not defined in the node exception.");
        }
        end = exception.indexOf("\"", start);
        tmp[1] = exception.substring(start, end);
        start = exception.indexOf("type=\"") + 6;
        if (start == 5) {
            throw new RuntimeException("Misformed exception: Attribute 'type' is not defined in the node exception.");
        }
        end = exception.indexOf("\"", start);
        tmp[2] = exception.substring(start, end);
        tmp[3] = exception.substring(exception.indexOf("<message>") + 9, exception.indexOf("</message>"));
        tmp[4] = exception.substring(exception.indexOf("<class>") + 7, exception.indexOf("</class>"));
        tmp[5] = exception.substring(exception.indexOf("<stacktrace>") + 12, exception.indexOf("</stacktrace>")).trim();
        if (!tmp[5].startsWith("<![CDATA[")) {
            tmp[5] = "<![CDATA[" + tmp[5] + " ]]>";
        }
        this.exceptions.add(tmp);
    }

    public void addException(String origin, int exceptionType, String message, String classname, String trace) {
        this.exceptions.add(new String[]{roleNames[this.roletype], origin, exceptionNames[exceptionType], message, classname, "<![CDATA[ " + trace + " ]]>"});
    }

    public void removeAllExceptions() {
        this.exceptions = new Vector();
    }

    public void addRoute(String action, String description) {
        DateFormat df = DateFormat.getDateTimeInstance(3, 2, Locale.UK);
        this.routes.add(new String[]{roleNames[this.roletype], this.rolename, this.roleip, this.roleversion, df.format(new Date()), action, description});
    }

    public void addRoute(String action, String description, Date time) {
        DateFormat df = DateFormat.getDateTimeInstance(3, 2, Locale.UK);
        this.routes.add(new String[]{roleNames[this.roletype], this.rolename, this.roleip, this.roleversion, df.format(time), action, description});
    }

    public void removeAllRoutes() {
        this.routes = new Vector();
    }

    public String addParameter(String name, String value) {
        String[] tmp = this.parameters.put(name, new String[]{"SYSTEMINFO", value});
        if (tmp != null) {
            return tmp[1];
        }
        return null;
    }

    public String addParameter(String name, int paramType, String value) {
        String[] tmp = this.parameters.put(name, new String[]{paramNames[paramType], value});
        if (tmp != null) {
            return tmp[1];
        }
        return null;
    }

    public String removeParameter(String param) {
        String[] tmp = (String[])this.parameters.remove(param);
        if (tmp != null) {
            return tmp[1];
        }
        return null;
    }

    public void removeAllParameters() {
        this.parameters = new Hashtable();
    }

    public int numberOfParameters() {
        return this.parameters.size();
    }

    public String toString() {
        return this.toXML();
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<context>");
        if (this.id != null) {
            sb.append("<id value=\"" + this.id + "\"/>");
        }
        sb.append("<type value=\"" + typeNames[this.type] + "\"/><parameters>");
        String[] tmp = null;
        String key = null;
        Enumeration e = this.parameters.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            tmp = (String[])this.parameters.get(key);
            sb.append("<parameter type=\"" + tmp[0] + "\" name=\"" + key + "\" value=\"" + tmp[1] + "\"/>");
        }
        sb.append("</parameters><traceroute>");
        Iterator it = this.routes.iterator();
        while (it.hasNext()) {
            tmp = (String[])it.next();
            sb.append("<route role=\"" + tmp[0] + "\" rolename=\"" + tmp[1] + "\" role-ip=\"" + tmp[2] + "\" role-version=\"" + tmp[3] + "\" time=\"" + tmp[4] + "\" action=\"" + tmp[5] + "\">" + tmp[6] + "</route>");
        }
        sb.append("</traceroute><exceptions>");
        it = this.exceptions.iterator();
        while (it.hasNext()) {
            tmp = (String[])it.next();
            sb.append("<exception role=\"" + tmp[0] + "\" origin=\"" + tmp[1] + "\" type=\"" + tmp[2] + "\">");
            sb.append("<message>" + tmp[3] + "</message><class>" + tmp[4] + "</class>");
            sb.append("<stacktrace>" + tmp[5] + "</stacktrace></exception>");
        }
        sb.append("</exceptions></context>");
        return sb.toString();
    }

    public String toXML(boolean indentation) {
        Iterator it;
        if (!indentation) {
            return this.toXML();
        }
        String[] tmp = null;
        String key = null;
        String indent = "  ";
        StringBuffer sb = new StringBuffer();
        sb.append("<context>\n");
        if (this.id != null) {
            sb.append(indent + "<id value=\"" + this.id + "\"/>\n");
        }
        sb.append(indent + "<type value=\"" + typeNames[this.type] + "\"/>\n");
        if (this.parameters.size() == 0) {
            sb.append(indent + "<parameters/>\n");
        } else {
            sb.append(indent + "<parameters>\n");
            Enumeration e = this.parameters.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                tmp = (String[])this.parameters.get(key);
                sb.append(indent + indent + "<parameter type=\"" + tmp[0] + "\" name=\"" + key + "\" value=\"" + tmp[1] + "\"/>\n");
            }
            sb.append(indent + "</parameters>\n");
        }
        if (this.routes.size() == 0) {
            sb.append(indent + "<traceroute/>\n");
        } else {
            sb.append(indent + "<traceroute>\n");
            it = this.routes.iterator();
            while (it.hasNext()) {
                tmp = (String[])it.next();
                sb.append(indent + indent + "<route role=\"" + tmp[0] + "\" rolename=\"" + tmp[1] + "\" role-ip=\"" + tmp[2] + "\" role-version=\"" + tmp[3] + "\" time=\"" + tmp[4] + "\" action=\"" + tmp[5] + "\">" + tmp[6] + "</route>\n");
            }
            sb.append(indent + "</traceroute>\n");
        }
        if (this.exceptions.size() == 0) {
            sb.append(indent + "<exceptions/>\n");
        } else {
            sb.append(indent + "<exceptions>\n");
            it = this.exceptions.iterator();
            while (it.hasNext()) {
                tmp = (String[])it.next();
                sb.append(indent + indent + "<exception role=\"" + tmp[0] + "\" origin=\"" + tmp[1] + "\" type=\"" + tmp[2] + "\">\n");
                sb.append(indent + indent + indent + "<message>" + tmp[3] + "</message>\n");
                sb.append(indent + indent + indent + "<class>" + tmp[4] + "</class>\n");
                sb.append(indent + indent + indent + "<stacktrace>\n" + tmp[5] + "\n" + indent + indent + indent + "</stacktrace>\n");
                sb.append(indent + indent + "</exception>\n");
            }
            sb.append(indent + "</exceptions>\n");
        }
        sb.append("</context>");
        return sb.toString();
    }
}

