/*
 * Decompiled with CFR 0.152.
 */
package org.egso.common.context;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.egso.common.context.EGSOContext;

public class EGSOContextFactory {
    private int roleType = 3;
    private String ipRole = null;
    private String roleName = null;
    private String roleVersion = null;

    private EGSOContextFactory(int roletype, String rolename, String roleversion, String ip) {
        this.roleType = roletype;
        this.roleName = rolename;
        this.roleVersion = roleversion;
        if (ip == null) {
            try {
                this.ipRole = InetAddress.getLocalHost().toString();
            }
            catch (UnknownHostException uhe) {
                System.out.println("EGSOContextFactory - Error can't found the IP");
                this.ipRole = "127.0.0.1";
            }
        } else {
            this.ipRole = ip;
        }
    }

    public static EGSOContextFactory newInstance(int roletype, String rolename, String roleversion) {
        return new EGSOContextFactory(roletype, rolename, roleversion, null);
    }

    public static EGSOContextFactory newInstance(int roletype, String rolename, String roleversion, String ip) {
        return new EGSOContextFactory(roletype, rolename, roleversion, ip);
    }

    public EGSOContext createContext(int type) {
        return new EGSOContext(type, this.roleType, this.roleName, this.roleVersion, this.ipRole);
    }

    public EGSOContext createContext(int type, String id) {
        return new EGSOContext(type, this.roleType, id, this.roleName, this.roleVersion, this.ipRole);
    }

    public EGSOContext createContext(String xml) {
        return new EGSOContext(xml, this.roleType, this.roleName, this.roleVersion, this.ipRole);
    }
}

