/*
 * Decompiled with CFR 0.152.
 */
package org.egso.common.externalinteraction;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.egso.common.CommonConfig;
import org.egso.common.Disposable;
import org.egso.common.externalinteraction.InteractionManager;
import org.egso.common.externalinteraction.InteractionManagerException;
import org.egso.common.externalinteraction.SessionFactoryImpl;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.comms.eis.adapter.AdapterException;
import org.egso.comms.eis.adapter.InteractionMediator;
import org.egso.comms.eis.adapter.Session;
import org.egso.comms.eis.adapter.SessionFactory;
import org.egso.comms.nds.types.ApplicationList;

public class ECIInteractionManagerImpl
extends AbstractLogEnabled
implements InteractionManager,
Disposable {
    private static ECIInteractionManagerImpl eciInteractionManager = null;
    private List openSessions = new Vector();
    private InteractionMediator interactionMediator = null;

    private ECIInteractionManagerImpl() throws Exception {
        this.initialize();
    }

    public static synchronized InteractionManager getInstance() throws Exception {
        if (eciInteractionManager == null) {
            eciInteractionManager = new ECIInteractionManagerImpl();
        }
        return eciInteractionManager;
    }

    private synchronized void initialize() throws Exception {
        this.interactionMediator = new InteractionMediator();
        this.interactionMediator.init();
        SessionFactoryImpl sessionFactory = null;
        if (CommonConfig.configuration.getBoolean("utils.interactionmediatoradapter.isServer")) {
            sessionFactory = new SessionFactoryImpl();
            this.interactionMediator.setSessionFactory((SessionFactory)sessionFactory);
            this.getLogger().info((Object)"InteractionMediator is in servermode: SessionFactory was acquired.");
        } else {
            this.getLogger().info((Object)"InteractionMediator is in client mode.");
        }
    }

    public synchronized void dispose() {
        Iterator iter = this.openSessions.iterator();
        while (iter.hasNext()) {
            Session session = (Session)iter.next();
            try {
                session.close();
            }
            catch (Throwable throwable) {}
        }
        eciInteractionManager = null;
        if (this.interactionMediator != null) {
            try {
                this.interactionMediator.destroy();
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while cleaning up interaction Mediator", e);
            }
        }
    }

    public Session getSession(String name, String password, String recipient) throws InteractionManagerException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"create new session.");
        }
        try {
            Session session = this.interactionMediator.createSession(recipient);
            this.openSessions.add(session);
            return session;
        }
        catch (Exception e) {
            throw new InteractionManagerException("Exception while creating session: " + e.getMessage(), e);
        }
    }

    public Session getSession(String name, String password, URI partner) throws InteractionManagerException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"create new session.");
        }
        try {
            Session session = this.interactionMediator.createSession(partner);
            this.openSessions.add(session);
            return session;
        }
        catch (Exception e) {
            throw new InteractionManagerException("Exception while creating session: " + e.getMessage(), e);
        }
    }

    public void releaseSession(Session session) {
        int pos = this.openSessions.indexOf(session);
        if (pos == -1) {
            String message = "Unknown Sessions cannot be released (EISInteractionManager.releaseSession())";
            this.getLogger().warn((Object)"Unknown Sessions cannot be released (EISInteractionManager.releaseSession())");
            return;
        }
        Session currentSession = (Session)this.openSessions.get(pos);
        this.openSessions.remove(pos);
        currentSession.close();
    }

    public ApplicationList selectApplicationByType(URI type) throws InteractionManagerException {
        try {
            return this.interactionMediator.selectApplicationByType(type);
        }
        catch (AdapterException e) {
            throw new InteractionManagerException(e.getMessage(), e);
        }
    }

    public Session createSession(String partner) throws InteractionManagerException {
        Session session;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Creating a new client side Session for partner: " + partner));
        }
        try {
            session = this.interactionMediator.createSession(partner);
            Object var4_4 = null;
        }
        catch (AdapterException e) {
            try {
                throw new InteractionManagerException("AdapterException while getting a session: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                block6: {
                    Object var4_5 = null;
                    if (!this.getLogger().isDebugEnabled()) break block6;
                    this.getLogger().debug((Object)"Client side Session created.");
                }
                throw throwable;
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Client side Session created.");
        }
        return session;
    }

    public String getId() {
        return this.interactionMediator.getId();
    }
}

