/*
 * Decompiled with CFR 0.152.
 */
package org.egso.common.externalinteraction;

import java.net.URI;
import org.egso.common.CommonConfig;
import org.egso.common.Disposable;
import org.egso.common.externalinteraction.InteractionManagerException;
import org.egso.common.externalinteraction.InteractionMediatorAdapter;
import org.egso.common.externalinteraction.SessionFactoryImpl;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.comms.eis.adapter.AdapterException;
import org.egso.comms.eis.adapter.InteractionMediator;
import org.egso.comms.eis.adapter.Session;
import org.egso.comms.eis.adapter.SessionFactory;
import org.egso.comms.nds.types.ApplicationList;

public class InteractionMediatorAdapterImpl
extends AbstractLogEnabled
implements InteractionMediatorAdapter,
Disposable {
    private InteractionMediator interactionMediator = null;

    public InteractionMediatorAdapterImpl() throws Exception {
        this.initialize();
    }

    private void initialize() throws Exception {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Initializing new InteractionMediator().");
        }
        this.interactionMediator = new InteractionMediator();
        this.interactionMediator.init();
        SessionFactoryImpl sessionFactory = null;
        if (CommonConfig.configuration.getBoolean("utils.interactionmediatoradapter.isServer")) {
            sessionFactory = new SessionFactoryImpl();
            this.interactionMediator.setSessionFactory((SessionFactory)sessionFactory);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"InteractionMediator is in servermode: SessionFactory was acquired.");
            }
        }
    }

    public void dispose() {
        if (this.interactionMediator != null) {
            try {
                this.interactionMediator.destroy();
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while cleaning up interaction Mediator", e);
            }
        }
    }

    public Session createSession(String partner) throws InteractionManagerException {
        Session session;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Creating a new client side Session for partner: " + partner));
        }
        try {
            session = this.interactionMediator.createSession(partner);
            Object var4_4 = null;
        }
        catch (AdapterException e) {
            try {
                throw new InteractionManagerException("AdapterException while getting a session: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                block6: {
                    Object var4_5 = null;
                    if (!this.getLogger().isDebugEnabled()) break block6;
                    this.getLogger().debug((Object)"Client side Session created.");
                }
                throw throwable;
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Client side Session created.");
        }
        return session;
    }

    public ApplicationList selectApplicationByType(URI type) throws InteractionManagerException {
        try {
            return this.interactionMediator.selectApplicationByType(type);
        }
        catch (AdapterException e) {
            throw new InteractionManagerException(e.getMessage(), e);
        }
    }
}

