/*
 * Decompiled with CFR 0.152.
 */
package org.egso.common.network;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.egso.common.externalinteraction.InteractionManager;
import org.egso.common.externalinteraction.InteractionManagerException;
import org.egso.common.externalinteraction.InteractionManagerFactory;
import org.egso.comms.nds.types.ApplicationList;

public class ApplicationDiscovery {
    public static String APPLICATION_TYPE_BROKER = "urn:org.egso.comms/broker";
    public static String APPLICATION_TYPE_PROVIDER = "urn:org.egso.comms/provider";
    public static String APPLICATION_TYPE_CONSUMER = "urn:org.egso.comms/consumer";
    InteractionManager interactionManager = null;

    private void initialize() {
        this.interactionManager = InteractionManagerFactory.getInteractionManager();
    }

    public ApplicationDiscovery() {
        this.initialize();
    }

    public List getConsumerApplications() throws InteractionManagerException {
        try {
            return this.selectApplicationByType(new URI(APPLICATION_TYPE_CONSUMER));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(APPLICATION_TYPE_CONSUMER + " is not a valid URI: " + e.getMessage());
        }
    }

    public List getBrokerApplications() throws InteractionManagerException {
        try {
            return this.selectApplicationByType(new URI(APPLICATION_TYPE_BROKER));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(APPLICATION_TYPE_BROKER + " is not a valid URI: " + e.getMessage());
        }
    }

    public List getProviderApplications() throws InteractionManagerException {
        try {
            return this.selectApplicationByType(new URI(APPLICATION_TYPE_PROVIDER));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(APPLICATION_TYPE_PROVIDER + " is not a valid URI: " + e.getMessage());
        }
    }

    public List getAllRoles() throws InteractionManagerException {
        Vector allRoles = new Vector();
        allRoles.addAll(this.getConsumerApplications());
        allRoles.addAll(this.getBrokerApplications());
        allRoles.addAll(this.getProviderApplications());
        return allRoles;
    }

    private List selectApplicationByType(URI type) throws InteractionManagerException {
        if (type == null) {
            throw new NullPointerException("Argument 'type' must not be null");
        }
        List<Object> retList = new Vector();
        ApplicationList apps = this.interactionManager.selectApplicationByType(type);
        retList = Arrays.asList(apps.getApplications());
        return retList;
    }
}

