/*
 * Decompiled with CFR 0.152.
 */
package org.egso.common.utils.uniqueid;

public class UniqueId {
    private static long lastId = 0L;

    public static String getUniqueId() {
        long id = System.currentTimeMillis();
        if (lastId >= id) {
            id = ++lastId;
        } else {
            lastId = id;
        }
        String s = Long.toHexString(id);
        return s;
    }

    public static String getUniqueId(int len) throws IllegalArgumentException {
        if (len < 8 || len > 16) {
            throw new IllegalArgumentException("Illegal value: len=" + len + " (8 <= len <= 16)");
        }
        String s = UniqueId.getUniqueId();
        int l = s.length();
        if (l < len) {
            return "0000000000000000".substring(len - l) + s;
        }
        return s.substring(l - len);
    }
}

