/*
 * Decompiled with CFR 0.152.
 */
package org.egso.common.votable;

import cds.savot.model.ResourceSet;
import cds.savot.model.SavotField;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotTD;
import cds.savot.model.SavotTR;
import cds.savot.model.SavotTable;
import cds.savot.model.SavotVOTable;
import cds.savot.model.TRSet;
import cds.savot.writer.WriteDocument;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class EGSOVOTable
extends SavotVOTable {
    private SavotVOTable votable = null;

    EGSOVOTable(SavotVOTable vot) {
        this.votable = vot;
    }

    public List getFieldNames() {
        ResourceSet set = this.votable.getResources();
        Vector<String> fields = new Vector<String>();
        if (set.getItemCount() == 0) {
            return fields;
        }
        SavotResource res = (SavotResource)set.getItemAt(0);
        if (res.getTableCount() == 0) {
            return fields;
        }
        SavotTable table = (SavotTable)res.getTables().getItemAt(0);
        Iterator it = table.getFields().getItems().iterator();
        while (it.hasNext()) {
            fields.add(((SavotField)it.next()).getName());
        }
        return fields;
    }

    public List getAllValues(String fieldName) {
        ResourceSet set = this.votable.getResources();
        Vector<String> values = new Vector<String>();
        if (set.getItemCount() == 0) {
            return values;
        }
        SavotResource res = null;
        SavotTable table = null;
        Iterator it = set.getItems().iterator();
        while (it.hasNext()) {
            res = (SavotResource)it.next();
            Iterator it2 = res.getTables().getItems().iterator();
            while (it2.hasNext()) {
                table = (SavotTable)it2.next();
                int index = -1;
                boolean found = false;
                Iterator it3 = table.getFields().getItems().iterator();
                while (!found && it3.hasNext()) {
                    found = ((SavotField)it3.next()).getName().equals(fieldName);
                    ++index;
                }
                if (!found) continue;
                Iterator it4 = table.getData().getTableData().getTRs().getItems().iterator();
                while (it4.hasNext()) {
                    values.add(((SavotTD)((SavotTR)it4.next()).getTDs().getItemAt(index)).getContent());
                }
            }
        }
        return values;
    }

    public List getAllRows() {
        Vector values = new Vector();
        ResourceSet set = this.votable.getResources();
        if (set == null) {
            return values;
        }
        Vector<String> row = new Vector<String>();
        if (set.getItemCount() == 0) {
            return values;
        }
        SavotResource res = null;
        SavotTable table = null;
        try {
            Iterator it = set.getItems().iterator();
            while (it.hasNext()) {
                res = (SavotResource)it.next();
                Iterator it2 = res.getTables().getItems().iterator();
                while (it2.hasNext()) {
                    table = (SavotTable)it2.next();
                    Iterator it3 = table.getData().getTableData().getTRs().getItems().iterator();
                    while (it3.hasNext()) {
                        row = new Vector();
                        Iterator it4 = ((SavotTR)it3.next()).getTDs().getItems().iterator();
                        while (it4.hasNext()) {
                            row.add(((SavotTD)it4.next()).getContent());
                        }
                        values.add(row);
                    }
                }
            }
        }
        catch (NullPointerException npe) {
            return values;
        }
        return values;
    }

    public List getRow(int row) throws ArrayIndexOutOfBoundsException {
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException("The index can't be negative");
        }
        ResourceSet set = this.votable.getResources();
        Vector<String> values = new Vector<String>();
        if (set.getItemCount() == 0) {
            return values;
        }
        SavotResource res = null;
        SavotTable table = null;
        TRSet trs = null;
        Iterator it = set.getItems().iterator();
        while (it.hasNext()) {
            res = (SavotResource)it.next();
            Iterator it2 = res.getTables().getItems().iterator();
            while (it2.hasNext()) {
                table = (SavotTable)it2.next();
                trs = table.getData().getTableData().getTRs();
                if (row >= trs.getItemCount()) {
                    throw new ArrayIndexOutOfBoundsException("Can't reach the " + row + "-th element of the row (last index=" + (trs.getItemCount() - 1) + ").");
                }
                Iterator it3 = ((SavotTR)trs.getItemAt(row)).getTDs().getItems().iterator();
                while (it3.hasNext()) {
                    values.add(((SavotTD)it3.next()).getContent());
                }
            }
        }
        return values;
    }

    public List getRows(String fieldName, String fieldValue) {
        return this.getRows(fieldName, fieldValue, false);
    }

    public List getRows(String fieldName, String fieldValue, boolean isCaseSensitive) {
        ResourceSet set = this.votable.getResources();
        Vector values = new Vector();
        Vector<String> row = null;
        if (set.getItemCount() == 0) {
            return values;
        }
        SavotResource res = null;
        SavotTable table = null;
        SavotTR tr = null;
        String tmp = null;
        Iterator it = set.getItems().iterator();
        while (it.hasNext()) {
            res = (SavotResource)it.next();
            Iterator it2 = res.getTables().getItems().iterator();
            while (it2.hasNext()) {
                table = (SavotTable)it2.next();
                int index = -1;
                boolean found = false;
                Iterator it3 = table.getFields().getItems().iterator();
                while (!found && it3.hasNext()) {
                    found = ((SavotField)it3.next()).getName().equals(fieldName);
                    ++index;
                }
                if (!found) continue;
                Iterator it4 = table.getData().getTableData().getTRs().getItems().iterator();
                while (it4.hasNext()) {
                    row = new Vector<String>();
                    tr = (SavotTR)it4.next();
                    tmp = ((SavotTD)tr.getTDs().getItemAt(index)).getContent();
                    if ((!isCaseSensitive || !tmp.equals(fieldValue)) && (isCaseSensitive || !tmp.equalsIgnoreCase(fieldValue))) continue;
                    Iterator it5 = tr.getTDs().getItems().iterator();
                    while (it5.hasNext()) {
                        row.add(((SavotTD)it5.next()).getContent());
                    }
                    values.add(row);
                }
            }
        }
        return values;
    }

    public int getNumberOfRows() {
        ResourceSet set = this.votable.getResources();
        if (set.getItemCount() == 0) {
            return 0;
        }
        int num = 0;
        SavotResource res = null;
        SavotTable table = null;
        Iterator it = set.getItems().iterator();
        while (it.hasNext()) {
            res = (SavotResource)it.next();
            Iterator it2 = res.getTables().getItems().iterator();
            while (it2.hasNext()) {
                table = (SavotTable)it2.next();
                num += table.getData().getTableData().getTRs().getItemCount();
            }
        }
        return num;
    }

    public String toString() {
        WriteDocument wd = new WriteDocument();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        wd.generateDocument(this.votable, (OutputStream)output);
        return output.toString().replaceAll("\n", "");
    }
}

