/*
 * Decompiled with CFR 0.152.
 */
package org.egso.common.votable;

import cds.savot.pull.SavotPullEngine;
import cds.savot.pull.SavotPullParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.egso.common.votable.EGSOVOTable;
import org.xml.sax.InputSource;

public class VOTableFactory {
    private VOTableFactory() {
    }

    public static VOTableFactory newInstance() {
        return new VOTableFactory();
    }

    public EGSOVOTable createVOTable(String content) {
        SavotPullParser parser = new SavotPullParser((InputStream)new ByteArrayInputStream(content.getBytes()), SavotPullEngine.FULL, "ISO-8859-1");
        return new EGSOVOTable(parser.getVOTable());
    }

    public EGSOVOTable createVOTable(File file) {
        SavotPullParser parser = new SavotPullParser(file.getPath(), SavotPullEngine.FULL);
        return new EGSOVOTable(parser.getVOTable());
    }

    public EGSOVOTable createVOTable(InputStream is) {
        SavotPullParser parser = new SavotPullParser(is, SavotPullEngine.FULL, "ISO-8859-1");
        return new EGSOVOTable(parser.getVOTable());
    }

    public EGSOVOTable createVOTable(InputSource is) {
        SavotPullParser parser = new SavotPullParser(is.getByteStream(), SavotPullEngine.FULL, "ISO-8859-1");
        return new EGSOVOTable(parser.getVOTable());
    }
}

