/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.api;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;

public class ParameterRequiredException
extends ConsumerException {
    private final String data_key;
    private final Collection missingParams;

    public ParameterRequiredException(String data_key, Collection missingParameters, String message) throws ArgumentException {
        super(message);
        this.data_key = data_key;
        ParameterRequiredException.testStringOnly(missingParameters);
        this.missingParams = Collections.unmodifiableCollection(missingParameters);
    }

    public ParameterRequiredException(String data_key, Collection missingParameters, Throwable cause) throws ArgumentException {
        super(cause);
        this.data_key = data_key;
        ParameterRequiredException.testStringOnly(missingParameters);
        this.missingParams = Collections.unmodifiableList(new LinkedList());
    }

    public ParameterRequiredException(String data_key, Collection missingParameters, String message, Throwable cause) throws ArgumentException {
        super(message, cause);
        this.data_key = data_key;
        ParameterRequiredException.testStringOnly(missingParameters);
        this.missingParams = Collections.unmodifiableCollection(missingParameters);
    }

    public synchronized String getCauseData_key() {
        return this.data_key;
    }

    public synchronized Collection getMissingParameters() {
        return this.missingParams;
    }

    private static void testStringOnly(Collection c) throws ArgumentException {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (element instanceof String) continue;
            throw new ArgumentException("illegal parameter ref. expected String but got " + (element == null ? "null" : element.getClass().getName()));
        }
    }
}

