/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.core;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Type;
import org.egso.consumer.api.VOTableReader;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.UncheckedConsumerException;
import org.egso.consumer.util.Compare;
import org.egso.consumer.util.ObservableHashMap;
import org.egso.consumer.util.ObservableList;

public class GenericData
extends AbstractLogEnabled
implements Data,
Cloneable {
    private final GenericType type;
    private ObservableList elements = null;
    private ChildrenMap children = null;
    private boolean readonly = false;
    private String id;

    private synchronized void initElements(Collection initialCollection) {
        if (this.elements != null) {
            return;
        }
        if (!this.isList()) {
            return;
        }
        this.elements = new ElementsList(initialCollection);
    }

    public GenericData(GenericType type) throws ArgumentException {
        if (type == null) {
            ArgumentException aex = new ArgumentException("type must not be null!");
            this.getLogger().warn((Object)aex);
            throw aex;
        }
        this.type = type;
    }

    public GenericData(GenericData data) throws ConsumerException {
        this((GenericType)data.type());
        this.set(data);
    }

    public GenericData(GenericType type, Object initialValue) throws ConsumerException {
        this(type);
        this.setValue(initialValue);
    }

    public GenericData(GenericType type, String id) throws ConsumerException {
        this(type);
        this.setId(id);
    }

    public final synchronized boolean readonly() {
        return this.readonly;
    }

    private void checkReadonly() throws ConsumerException {
        if (this.readonly()) {
            ConsumerException cex = new ConsumerException("illegal attempt to add an element to a readonly data");
            this.getLogger().warn((Object)cex);
            throw cex;
        }
    }

    private void checkReadonlyThrowsUnchecked() {
        try {
            this.checkReadonly();
        }
        catch (ConsumerException ex) {
            throw new UncheckedConsumerException(ex);
        }
    }

    public void setValue(Object value) throws ArgumentException, ConsumerException {
        if (value instanceof String) {
            if (this.isList()) {
                ArgumentException aex = new ArgumentException("its considered to be wrong to set a list's id rather than the elements' ids");
                this.getLogger().debug((Object)aex);
                throw aex;
            }
            this.setId((String)value);
        } else if (this.isList() && value instanceof Object[]) {
            Object[] values = (Object[])value;
            for (int i = 0; i < values.length; ++i) {
                this.add(values[i]);
            }
        } else if (this.isList() && value instanceof Collection) {
            Collection values = (Collection)value;
            Iterator it = values.iterator();
            while (it.hasNext()) {
                Object element = it.next();
                this.add(element);
            }
        } else {
            ArgumentException aex = new ArgumentException("new value was not applied due to missing conversion operation. overload it in a subclass (probably in " + this.getClass().getName() + ")");
            this.getLogger().warn((Object)aex);
            throw aex;
        }
        this.checkInValueDomain();
    }

    public synchronized Type type() {
        return this.type;
    }

    public Data get(int i) throws ConsumerException {
        try {
            return (Data)this.elements().get(i);
        }
        catch (UncheckedConsumerException ex) {
            ex.unwrap();
            return null;
        }
    }

    public Data get(String key) throws ConsumerException {
        try {
            return (Data)this.children().get(key);
        }
        catch (UncheckedConsumerException ex) {
            ex.unwrap();
            return null;
        }
    }

    public void put(Object key, Object value) throws ArgumentException {
        try {
            this.children().put(key, value);
        }
        catch (UncheckedConsumerException ex) {
            ex.unwrapArgEx();
        }
    }

    public void add(Object value) throws ArgumentException, ConsumerException {
        if (!this.isList()) {
            ConsumerException cex = new ConsumerException("elements can be added only to Data instances of set type");
            this.getLogger().warn((Object)cex);
            throw cex;
        }
        try {
            this.elements().add(value);
        }
        catch (UncheckedConsumerException ex) {
            ex.unwrap();
        }
    }

    public void remove(Object value) throws ArgumentException {
        try {
            if (this.isList() && this.elements().remove(value)) {
                return;
            }
            if (this.isCompound() && this.children().remove(value) != null) {
                return;
            }
        }
        catch (UncheckedConsumerException ex) {
            ex.unwrapArgEx();
        }
    }

    public synchronized int size() {
        int s = 0;
        if (this.isCompound()) {
            s += this.children().size();
        }
        if (this.isList()) {
            s += this.elements().size();
        }
        return s;
    }

    public synchronized Map children() {
        this.initChildren(null);
        return this.children;
    }

    private synchronized void initChildren(Map initialMap) {
        if (this.children != null) {
            return;
        }
        if (!this.isList() && !this.isCompound()) {
            return;
        }
        this.children = new ChildrenMap(initialMap);
    }

    public synchronized List elements() {
        this.initElements(null);
        return this.elements;
    }

    public boolean isEnum() {
        return this.type().isEnum();
    }

    public boolean isList() {
        return this.type().isList();
    }

    public boolean isCompound() {
        return this.type().isCompound();
    }

    public String typeName() {
        return this.type().typeName();
    }

    public String UCDType() {
        return this.type().UCDType();
    }

    public String unit() {
        return this.type().unit();
    }

    public Data newData() throws ConsumerException {
        return this.type().newData();
    }

    public Data newData(Object initialValue) throws ConsumerException {
        return this.type().newData(initialValue);
    }

    public Map childrenTypes() {
        return this.type().childrenTypes();
    }

    public boolean distinct() {
        return this.type().distinct();
    }

    public Type elementsType() {
        return this.type().elementsType();
    }

    public Data valueDomain() throws ConsumerException {
        return this.type().valueDomain();
    }

    public synchronized void setReadonly(boolean b) {
        this.readonly = b;
    }

    public final Object clone() {
        return this.clone(null, false);
    }

    synchronized Object clone(Map clonedList, boolean cloneTypes) {
        Iterator it;
        Object cachedClone;
        if (clonedList == null) {
            clonedList = new HashMap<GenericData, GenericData>();
        }
        if ((cachedClone = clonedList.get(this)) != null) {
            return cachedClone;
        }
        GenericData clone = null;
        try {
            clone = (GenericData)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            // empty catch block
        }
        clonedList.put(this, clone);
        if (this.elements != null) {
            LinkedList<GenericData> elements = new LinkedList<GenericData>();
            it = this.elements.iterator();
            while (it.hasNext()) {
                GenericData ed = (GenericData)it.next();
                GenericData edc = (GenericData)clonedList.get(ed);
                if (edc == null) {
                    edc = (GenericData)ed.clone(clonedList, cloneTypes);
                }
                elements.add(edc);
            }
            clone.elements = null;
            clone.initElements(elements);
        }
        if (this.children != null) {
            HashMap<String, GenericData> children = new HashMap<String, GenericData>();
            it = this.children.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String cn = (String)entry.getKey();
                GenericData cd = (GenericData)entry.getValue();
                GenericData cdc = null;
                if (cd != null) {
                    cdc = (GenericData)clonedList.get(cd);
                }
                if (cdc == null) {
                    try {
                        cdc = (GenericData)clone.get(cd.id());
                        if (cdc != null) {
                            continue;
                        }
                    }
                    catch (ConsumerException ex) {
                        // empty catch block
                    }
                }
                if (cdc == null) {
                    cdc = (GenericData)cd.clone(clonedList, cloneTypes);
                }
                children.put(cn, cdc);
            }
            clone.children = null;
            clone.initChildren(children);
        }
        return this.cloneNr(clone);
    }

    protected Object cloneNr(GenericData gdClone) {
        return gdClone;
    }

    public final boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (otherObject == this) {
            return true;
        }
        if (!(otherObject instanceof GenericData)) {
            return false;
        }
        return this.equals((GenericData)otherObject);
    }

    private boolean equals(GenericData otherData) {
        return this.equals(otherData, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean equals(GenericData otherData, Map thisStopList, Map otherStopList) {
        LinkedList<GenericData> otherEquals;
        LinkedList<GenericData> thisEquals;
        if (otherData == null) {
            return false;
        }
        if (this == otherData) {
            return true;
        }
        if (thisStopList == null) {
            thisStopList = new HashMap();
        }
        if (otherStopList == null) {
            otherStopList = new HashMap();
        }
        if ((thisEquals = (LinkedList<GenericData>)thisStopList.get(this)) == null) {
            thisEquals = new LinkedList<GenericData>();
            thisStopList.put(this, thisEquals);
        }
        if ((otherEquals = (LinkedList<GenericData>)otherStopList.get(otherData)) == null) {
            otherEquals = new LinkedList<GenericData>();
            otherStopList.put(otherData, otherEquals);
        }
        Iterator teIt = thisEquals.iterator();
        while (teIt.hasNext()) {
            Object teOther = teIt.next();
            if (otherData != teOther) continue;
            return true;
        }
        if (otherData.objectHashCode() < this.objectHashCode()) {
            return otherData.equals(this, otherStopList, thisStopList);
        }
        thisEquals.add(otherData);
        otherEquals.add(this);
        GenericData genericData = this;
        synchronized (genericData) {
            GenericData genericData2 = otherData;
            synchronized (genericData2) {
                if (this.id == null && otherData.id != null) {
                    return false;
                }
                if (this.id != null && !this.id.equals(otherData.id)) {
                    return false;
                }
                if (!((GenericType)this.type()).equals((GenericType)otherData.type(), thisStopList, otherStopList)) {
                    return false;
                }
                if (this.isCompound()) {
                    if (!Compare.compareCollections(this.children().keySet(), otherData.children().keySet())) {
                        return false;
                    }
                    Iterator cit = this.children().entrySet().iterator();
                    while (cit.hasNext()) {
                        Data otherChildData;
                        Map.Entry thisDataChildMapping = cit.next();
                        String child_key = (String)thisDataChildMapping.getKey();
                        Data thisChildData = (Data)thisDataChildMapping.getValue();
                        if (thisChildData == (otherChildData = (Data)otherData.children().get(child_key))) continue;
                        Collection tdEquals = (Collection)thisStopList.get(thisChildData);
                        boolean foundEqual = false;
                        if (tdEquals != null) {
                            Iterator tdIt = tdEquals.iterator();
                            while (tdIt.hasNext()) {
                                Object tdElem = tdIt.next();
                                if (tdElem != otherChildData) continue;
                                foundEqual = true;
                                break;
                            }
                        }
                        if (foundEqual) continue;
                        if (!((GenericData)thisChildData).equals((GenericData)otherChildData, thisStopList, otherStopList)) {
                            return false;
                        }
                        if (((GenericData)otherChildData).equals((GenericData)thisChildData, otherStopList, thisStopList)) continue;
                        return false;
                    }
                }
                if (this.isList() && !GenericData.compareCollectionsCountAwareForEquals(this.elements(), otherData.elements(), thisStopList, otherStopList)) {
                    return false;
                }
                return this.equalsNr(otherData);
            }
        }
    }

    protected boolean equalsNr(GenericData otherData) {
        return true;
    }

    public static boolean compareCollectionsCountAwareForEquals(Collection c1, Collection c2, Map c1StopList, Map c2StopList) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null != (c2 == null)) {
            return false;
        }
        c1 = new LinkedList(c1);
        c2 = new LinkedList(c2);
        Iterator it1 = c1.iterator();
        block0: while (it1.hasNext()) {
            GenericData e1 = (GenericData)it1.next();
            Iterator it2 = c2.iterator();
            while (it2.hasNext()) {
                GenericData e2 = (GenericData)it2.next();
                if (!e1.equals(e2, c1StopList, c2StopList)) continue;
                it1.remove();
                it2.remove();
                continue block0;
            }
            return false;
        }
        if (c1.size() > 0) {
            return false;
        }
        return c2.size() <= 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    private synchronized int hashCode(int depthLeft) {
        GenericData entry;
        Iterator<Object> it;
        if (depthLeft-- == 0) {
            return 0;
        }
        int hc = 1137 * ((Object)this.type()).hashCode();
        if (this.children() != null) {
            it = this.children().values().iterator();
            while (it.hasNext()) {
                entry = (GenericData)it.next();
                hc += entry.hashCode(depthLeft);
            }
        }
        if (this.isList() && this.elements() != null) {
            it = this.elements().iterator();
            while (it.hasNext()) {
                entry = (GenericData)it.next();
                hc += entry.hashCode(depthLeft);
            }
        }
        return hc;
    }

    public int objectHashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "GenericData(id=" + this.id() + " type=" + this.typeName() + " elements=" + (this.isList() ? "" + this.elements().size() : "") + " children=" + (this.isCompound() ? "" + this.children().keySet() : "") + " readonly=" + this.readonly() + ")";
    }

    public String id() {
        return this.id;
    }

    public void setId(String id) throws ArgumentException {
        if (id == null) {
            ArgumentException aex = new ArgumentException("illegal attempt to set an id to null.");
            this.getLogger().warn((Object)aex);
            throw aex;
        }
        this.id = id;
    }

    public void checkDistinct() {
        if (this.type().distinct() && this.isList()) {
            HashSet<GenericData> unicums = new HashSet<GenericData>();
            Iterator it = this.elements().iterator();
            while (it.hasNext()) {
                GenericData element = (GenericData)it.next();
                if (unicums.contains(element)) {
                    it.remove();
                    continue;
                }
                unicums.add(element);
            }
        }
    }

    public void prettyPrint(PrintStream out) {
        GenericData.prettyPrintInt(out, this, "");
        out.println();
    }

    private static void prettyPrintInt(PrintStream out, Data data, String indent) {
        Iterator<Object> it;
        out.println(indent + "\ufffd\ufffd data" + (data.id() != null ? " id='" + data.id() + "'" : "") + " type='" + data.typeName() + "'" + (data.size() > 0 ? " size=" + data.size() : ""));
        if (data.isList()) {
            it = data.elements().iterator();
            while (it.hasNext()) {
                Data element = (Data)it.next();
                if (element == data) {
                    out.println(indent + "  \ufffd\ufffd data self" + (data.id() != null ? " id='" + data.id() + "'" : ""));
                    continue;
                }
                GenericData.prettyPrintInt(out, element, indent + "  ");
            }
        }
        if (data.isCompound()) {
            it = data.children().keySet().iterator();
            while (it.hasNext()) {
                String child_key = (String)it.next();
                try {
                    if (data.get(child_key) == data) {
                        out.println(indent + "  \ufffd\ufffd child self key='" + child_key + "' ");
                        continue;
                    }
                    out.println(indent + "  \ufffd\ufffd child key='" + child_key + "' ");
                    GenericData.prettyPrintInt(out, data.get(child_key), indent + "    ");
                }
                catch (ConsumerException ex) {
                    out.print(indent + (Object)((Object)ex));
                }
            }
        }
        if (data instanceof VOTableReader) {
            out.println("\nthe data as vo table:");
            try {
                char c;
                Reader r = ((VOTableReader)((Object)data)).readVOTable();
                int col = 0;
                while ((c = (char)r.read()) != '\uffff') {
                    if (c == '\n' || c == '\r') {
                        out.println();
                        col = 0;
                        continue;
                    }
                    if (++col > 100) {
                        out.println(c);
                        col = 0;
                        continue;
                    }
                    out.print(c);
                }
            }
            catch (ConsumerException ex) {
                out.println(indent + (Object)((Object)ex));
            }
            catch (IOException ex) {
                out.println(indent + ex);
            }
        }
    }

    public Object getValue() throws ConsumerException {
        return this.id();
    }

    public synchronized void set(Data value) throws ArgumentException, ConsumerException {
        this.checkReadonly();
        if (value == null || !(value instanceof GenericData)) {
            ArgumentException aex = new ArgumentException("foreign Data impl not supported: expected " + this.getClass().getName() + " " + "but got " + (value != null ? value.getClass().getName() : "null"));
            this.getLogger().warn((Object)aex);
            throw aex;
        }
        if (!((Object)this.type()).equals(value.type())) {
            ArgumentException aex = new ArgumentException("inapplicable value: expected type " + this.typeName() + " " + "but got " + value.typeName());
            this.getLogger().warn((Object)aex);
            throw aex;
        }
        this.id = value.id();
        this.children = null;
        Map vChildren = value.children();
        if (vChildren != null) {
            this.initChildren(vChildren);
        }
        this.elements = null;
        List vElements = value.elements();
        if (vElements != null) {
            this.initElements(vElements);
        }
        this.checkInValueDomain();
    }

    public synchronized boolean contains(Object candidate) throws ArgumentException {
        try {
            if (candidate == null) {
                return false;
            }
            if (this.isList() && this.elements().contains(candidate)) {
                return true;
            }
            return this.isCompound() && this.children().containsValue(candidate);
        }
        catch (UncheckedConsumerException ex) {
            ex.unwrapArgEx();
            return false;
        }
    }

    public void checkInValueDomain() throws ArgumentException {
        ((GenericType)this.type()).checkInValueDomain(this);
    }

    private class ChildrenMap
    extends ObservableHashMap {
        private ChildrenMap(Map m) {
            super(m);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object put(Object key, Object value) {
            GenericData genericData = GenericData.this;
            synchronized (genericData) {
                GenericData.this.checkReadonlyThrowsUnchecked();
                if (!GenericData.this.childrenTypes().containsKey(key)) {
                    ConsumerException cex = new ConsumerException("unknown child attribute '" + key + "'");
                    this.getLogger().warn((Object)cex);
                    throw new UncheckedConsumerException(cex);
                }
                if (value == null) {
                    this.remove(key);
                    return null;
                }
                if (!(value instanceof Data)) {
                    try {
                        Data data = ((GenericType)GenericData.this.childrenTypes().get(key)).newData(value);
                        return this.put(key, data);
                    }
                    catch (ConsumerException ex) {
                        throw new UncheckedConsumerException(ex);
                    }
                }
                if (!((Object)((GenericData)value).type()).equals(GenericData.this.childrenTypes().get(key))) {
                    ConsumerException cex = new ConsumerException("wrong data type: expected " + GenericData.this.childrenTypes().get(key) + "but got " + ((GenericData)value).typeName());
                    this.getLogger().warn((Object)cex);
                    throw new UncheckedConsumerException(cex);
                }
                return super.put(key, value);
            }
        }

        Object superPut(Data element) {
            if (element.id() == null) {
                return null;
            }
            return super.put(element.id(), element);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(Object key) {
            GenericData genericData = GenericData.this;
            synchronized (genericData) {
                GenericData.this.checkReadonlyThrowsUnchecked();
                if (!GenericData.this.childrenTypes().containsKey(key)) {
                    ConsumerException cex = new ConsumerException("unknown child attribute " + key);
                    this.getLogger().warn((Object)cex);
                    throw new UncheckedConsumerException(cex);
                }
                return super.remove(key);
            }
        }

        Object superRemove(GenericData data) {
            if (data.id() == null) {
                return null;
            }
            return super.remove(data.id());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            GenericData genericData = GenericData.this;
            synchronized (genericData) {
                GenericData.this.checkReadonlyThrowsUnchecked();
                Iterator it = GenericData.this.childrenTypes().keySet().iterator();
                while (it.hasNext()) {
                    String child = (String)it.next();
                    this.remove(child);
                }
            }
        }

        public boolean containsValue(Object elem) {
            if (elem == null) {
                return false;
            }
            try {
                if (!(elem instanceof Data)) {
                    return GenericData.this.contains(GenericData.this.newData(elem));
                }
                if (!(elem instanceof GenericData)) {
                    ArgumentException aex = new ArgumentException("illegal data argument: expected class '" + GenericData.this.getClass().getName() + "' but got " + (elem == null ? "null" : "'" + elem.getClass().getName() + "'"));
                    this.getLogger().warn((Object)aex);
                    throw aex;
                }
                return super.containsValue(elem);
            }
            catch (ConsumerException cex) {
                throw new UncheckedConsumerException(cex);
            }
        }
    }

    private class ElementsList
    extends ObservableList {
        private ElementsList(Collection l) {
            super(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Object elem) {
            GenericData genericData = GenericData.this;
            synchronized (genericData) {
                ConsumerException cex;
                GenericData.this.checkReadonlyThrowsUnchecked();
                if (elem == null) {
                    ConsumerException cex2 = new ConsumerException("illegal attempt to add null as an element");
                    this.getLogger().warn((Object)cex2);
                    throw new UncheckedConsumerException(cex2);
                }
                if (GenericData.this.elementsType() == null) {
                    cex = new ConsumerException("illegal attempt to add an element to a non-list data (elements' type was not set)");
                    this.getLogger().warn((Object)cex);
                }
                if (elem instanceof String) {
                    try {
                        Data resolvedElem = null;
                        Data vd = GenericData.this.elementsType().valueDomain();
                        if (vd != null && vd.isList()) {
                            resolvedElem = vd.get((String)elem);
                            if (resolvedElem != null) {
                                return this.add(resolvedElem);
                            }
                            ArgumentException cex3 = new ArgumentException("could not resolve id '" + elem + "' to a valid " + "data instance by searching within the value domain!");
                            this.getLogger().warn((Object)cex3.getMessage(), (Throwable)((Object)cex3));
                            throw cex3;
                        }
                    }
                    catch (ConsumerException ex) {
                        throw new UncheckedConsumerException(ex);
                    }
                }
                if (!(elem instanceof Data)) {
                    try {
                        return this.add(GenericData.this.elementsType().newData(elem));
                    }
                    catch (ConsumerException ex) {
                        throw new UncheckedConsumerException(ex);
                    }
                }
                if (!((Object)((GenericData)elem).type()).equals(GenericData.this.elementsType())) {
                    cex = new ConsumerException("wrong data type: expected " + GenericData.this.elementsType().typeName() + " but got " + ((GenericData)elem).typeName());
                    this.getLogger().warn((Object)cex);
                    throw new UncheckedConsumerException(cex);
                }
                try {
                    if (GenericData.this.elementsType().valueDomain() != GenericData.this) {
                        ((GenericType)GenericData.this.elementsType()).checkInValueDomain((Data)elem);
                    }
                }
                catch (ConsumerException cex4) {
                    throw new UncheckedConsumerException(cex4);
                }
                if (GenericData.this.distinct() && this.contains(elem)) {
                    return false;
                }
                try {
                    ((GenericData)elem).checkInValueDomain();
                }
                catch (ArgumentException ex) {
                    throw new UncheckedConsumerException(ex);
                }
                try {
                    GenericData.this.checkInValueDomain();
                }
                catch (ConsumerException ex) {
                    ArgumentException aex = new ArgumentException("the current data (id=" + GenericData.this.id() + ") is not consistent with respect to its value domain!", (Throwable)((Object)ex));
                    this.getLogger().warn((Object)aex.getMessage(), (Throwable)((Object)aex));
                    throw new UncheckedConsumerException(aex);
                }
                boolean ret = super.add(elem);
                try {
                    GenericData.this.checkInValueDomain();
                }
                catch (ConsumerException ex) {
                    super.remove(elem);
                    ArgumentException aex = new ArgumentException("the current data (id=" + GenericData.this.id() + ") is not consistent with respect to its value domain when " + "adding new data (id=" + ((GenericData)elem).id() + ") to elements!", (Throwable)((Object)ex));
                    this.getLogger().debug((Object)aex.getMessage(), (Throwable)((Object)aex));
                    throw new UncheckedConsumerException(aex);
                }
                GenericData data = (GenericData)elem;
                if (data.id() != null && GenericData.this.childrenTypes().get(data.id()) == null) {
                    ((ChildrenMap)GenericData.this.children()).superPut(data);
                }
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object elem) {
            GenericData genericData = GenericData.this;
            synchronized (genericData) {
                if (GenericData.this.readonly()) {
                    ConsumerException cex = new ConsumerException("illegal attempt to add an element to a readonly data");
                    this.getLogger().warn((Object)cex);
                    throw new UncheckedConsumerException(cex);
                }
                if (!(elem instanceof Data)) {
                    try {
                        return this.remove(GenericData.this.elementsType().newData(elem));
                    }
                    catch (ConsumerException ex) {
                        throw new UncheckedConsumerException(ex);
                    }
                }
                try {
                    ((GenericData)elem).checkInValueDomain();
                }
                catch (ArgumentException ex) {
                    throw new UncheckedConsumerException(ex);
                }
                try {
                    GenericData.this.checkInValueDomain();
                }
                catch (ConsumerException ex) {
                    ConsumerException cex = new ConsumerException("the current data (id=" + GenericData.this.id() + ") is not consistent with respect to its value domain!", (Throwable)((Object)ex));
                    this.getLogger().warn((Object)cex.getMessage(), (Throwable)((Object)cex));
                    throw new UncheckedConsumerException(cex);
                }
                boolean ret = super.remove(elem);
                try {
                    GenericData.this.checkInValueDomain();
                }
                catch (ConsumerException ex) {
                    super.add(elem);
                    ArgumentException aex = new ArgumentException("the current data (id=" + GenericData.this.id() + ") is not consistent with respect to its value domain when " + "adding new data (id=" + ((GenericData)elem).id() + ") to elements!", (Throwable)((Object)ex));
                    this.getLogger().debug((Object)aex.getMessage(), (Throwable)((Object)aex));
                    throw new UncheckedConsumerException(aex);
                }
                GenericData data = (GenericData)elem;
                if (data.id() != null && GenericData.this.childrenTypes().get(data.id()) == null) {
                    GenericData.this.children.superRemove(data);
                }
                return ret;
            }
        }

        public synchronized void clear() {
            GenericData.this.checkReadonlyThrowsUnchecked();
            super.clear();
        }

        public boolean contains(Object elem) {
            if (elem == null) {
                return false;
            }
            try {
                if (!(elem instanceof Data)) {
                    return this.contains(GenericData.this.newData(elem));
                }
                if (!(elem instanceof GenericData)) {
                    ArgumentException aex = new ArgumentException("illegal data argument: expected class '" + GenericData.this.getClass().getName() + "' but got " + (elem == null ? "null" : "'" + elem.getClass().getName() + "'"));
                    this.getLogger().warn((Object)aex);
                    throw aex;
                }
                return super.contains(elem);
            }
            catch (ConsumerException cex) {
                throw new UncheckedConsumerException(cex);
            }
        }
    }
}

