/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import org.egso.common.context.EGSOContext;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Query;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.Updator;
import org.egso.consumer.valid.DataKeyValidator;

public class GenericQuery
extends AbstractLogEnabled
implements Query {
    public static final String PARAMETER_SUFFIX = "";
    public static final String RESULT_SUFFIX = "-result";
    private Map params = new HashMap();
    private Collection exposedParamsKeyset = null;
    private boolean autoupdate = true;
    private long modCount = 0L;
    private String id = "QHC" + this.hashCode();
    private String mostRecentQuery = null;
    private EGSOContext mostRecentContext = null;

    public synchronized Collection findAll() {
        if (this.exposedParamsKeyset == null) {
            this.exposedParamsKeyset = Collections.unmodifiableCollection(this.params.keySet());
        }
        return this.exposedParamsKeyset;
    }

    public Collection affectedBy(String data_key) throws ArgumentException {
        TreeSet dep = new TreeSet(this.getQueryData(data_key).getDependsOn());
        return Collections.unmodifiableCollection(dep);
    }

    public synchronized Collection affects(String data_key) {
        TreeSet<String> idList = new TreeSet<String>();
        Iterator param_it = this.findAll().iterator();
        while (param_it.hasNext()) {
            try {
                QueryData qp = this.getQueryData((String)param_it.next());
                if (!qp.getDependsOn().contains(data_key)) continue;
                idList.add(qp.getDataKey());
            }
            catch (ArgumentException ex) {
                this.getLogger().warn((Object)("impossible exception: " + (Object)((Object)ex)), (Throwable)((Object)ex));
            }
        }
        return Collections.unmodifiableCollection(idList);
    }

    public boolean readonly(String data_key) throws ArgumentException {
        return this.getQueryData(data_key).isReadonly();
    }

    public Type getType(String data_key) throws ArgumentException {
        return this.getQueryData(data_key).getType();
    }

    public Data get(String data_key) throws ArgumentException, ConsumerException {
        Data ret;
        QueryData qp = this.getQueryData(data_key);
        if (this.autoupdate) {
            qp.update();
        }
        if (!(ret = qp.getData()).readonly()) {
            ret = (Data)qp.getData().clone();
        }
        return ret;
    }

    public synchronized void set(String data_key, Data value) throws ArgumentException, ConsumerException {
        QueryData qd = this.getQueryData(data_key);
        if (value == null) {
            this.unset(data_key);
        } else {
            if (!value.readonly()) {
                value = (Data)((GenericData)value).clone();
            }
            qd.setData(value);
        }
    }

    public synchronized void setValue(String data_key, Object value) throws ArgumentException, ConsumerException {
        if (value == null) {
            this.unset(data_key);
        } else if (value instanceof Data) {
            this.set(data_key, (Data)value);
        } else {
            QueryData qd = this.getQueryData(data_key);
            Data newVal = qd.getData();
            if (newVal == null) {
                newVal = qd.getType().newData();
            }
            newVal.setValue(value);
            qd.setData(newVal);
            qd.makeDirty();
            qd.update();
        }
    }

    public synchronized long getModCount() {
        return this.modCount;
    }

    public synchronized long incModCount() {
        return this.modCount++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryData getQueryData(String data_key) throws ArgumentException {
        QueryData qd;
        GenericQuery genericQuery = this;
        synchronized (genericQuery) {
            qd = (QueryData)((Object)this.params.get(data_key));
        }
        if (qd == null) {
            ArgumentException aex = new ArgumentException("param not found: " + data_key);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)aex);
            }
            throw aex;
        }
        return qd;
    }

    public QueryData getQueryResultData(String data_key) throws ArgumentException {
        return this.getQueryData(this.unResult(data_key) + RESULT_SUFFIX);
    }

    synchronized void putQueryData(QueryData theParam) throws ArgumentException {
        String data_key = theParam.getDataKey();
        DataKeyValidator.validateDataKey(data_key);
        QueryData prev = this.params.put(data_key, theParam);
        this.exposedParamsKeyset = null;
        if (prev != null) {
            this.getLogger().warn((Object)("overwrote QueryData with key '" + data_key + "'!!!"));
        }
    }

    synchronized void unputQueryData(QueryData theParam) throws ArgumentException {
        String data_key = theParam.getDataKey();
        DataKeyValidator.validateDataKey(data_key);
        this.params.remove(data_key);
    }

    public Data getResult(String data_key) throws ConsumerException {
        if (data_key.endsWith(RESULT_SUFFIX)) {
            return this.get(data_key);
        }
        return this.get(data_key + RESULT_SUFFIX);
    }

    public String unResult(String result_key) {
        if (result_key.indexOf(RESULT_SUFFIX) > 0) {
            return result_key.substring(0, result_key.length() - RESULT_SUFFIX.length());
        }
        return result_key;
    }

    public Collection findAllResults() {
        TreeSet<String> params = new TreeSet<String>();
        Iterator it = this.findAll().iterator();
        while (it.hasNext()) {
            String param = (String)it.next();
            if (!param.endsWith(RESULT_SUFFIX)) continue;
            params.add(param);
        }
        return Collections.unmodifiableCollection(params);
    }

    public Collection findAllParameters() {
        TreeSet<String> params = new TreeSet<String>();
        Iterator it = this.findAll().iterator();
        while (it.hasNext()) {
            String param = (String)it.next();
            if (param.endsWith(RESULT_SUFFIX)) continue;
            params.add(param);
        }
        return Collections.unmodifiableCollection(params);
    }

    public void update(String data_key) throws ArgumentException, ConsumerException {
        QueryData qd = this.getQueryData(data_key);
        qd.makeDirty();
        qd.update();
        qd = this.getQueryResultData(data_key);
        qd.makeDirty();
        qd.update();
    }

    public boolean isSet(String data_key) throws ArgumentException {
        return this.getQueryData(data_key).isSet();
    }

    public void unset(String datakey) throws ArgumentException, ConsumerException {
        this.getQueryData(datakey).unset();
    }

    public String id() {
        return this.id;
    }

    public void setId(String newId) {
        this.id = newId;
    }

    public void makeDirty(String data_key) throws ArgumentException {
        QueryData qd = this.getQueryData(data_key);
        qd.makeDirty();
    }

    public synchronized Collection catalogues() throws ArgumentException {
        TreeSet cats = new TreeSet();
        Iterator it = this.findAll().iterator();
        while (it.hasNext()) {
            String field = (String)it.next();
            cats.addAll(this.getQueryData(field).getCatalogues());
        }
        return cats;
    }

    public synchronized Collection catalogues(Collection parameters) throws ArgumentException {
        TreeSet result = new TreeSet();
        Iterator it = parameters.iterator();
        while (it.hasNext()) {
            String param = (String)it.next();
            result.addAll(this.getQueryData(param).getCatalogues());
        }
        return Collections.unmodifiableCollection(result);
    }

    public synchronized Collection findByCatalogue(String catalogue_key) throws ConsumerException {
        TreeSet<String> params = new TreeSet<String>();
        Iterator it = this.findAll().iterator();
        while (it.hasNext()) {
            String field = (String)it.next();
            QueryData qd = this.getQueryData(field);
            if (!qd.getCatalogues().contains(catalogue_key)) continue;
            params.add(field);
        }
        return params;
    }

    public Collection requires(String data_key) throws ArgumentException {
        return new TreeSet(this.getQueryData(data_key).getRequires());
    }

    public Collection stillRequires(String data_key) throws ArgumentException {
        TreeSet x = new TreeSet(this.getQueryData(data_key).getRequires());
        Iterator it = x.iterator();
        while (it.hasNext()) {
            String req_key = (String)it.next();
            if (!this.isSet(req_key)) continue;
            it.remove();
        }
        return x;
    }

    private synchronized void setMostRecentQuery(String querySource) {
        this.mostRecentQuery = querySource;
    }

    private synchronized String getMostRecentQuery() {
        return this.mostRecentQuery;
    }

    private synchronized void setMostRecentContext(EGSOContext context) {
        this.mostRecentContext = context;
    }

    private synchronized EGSOContext getMostRecentContext() {
        return this.mostRecentContext;
    }

    public String getQuerySource(String data_key) throws ArgumentException, ConsumerException {
        QueryData qd;
        if (data_key == null) {
            String mrq = this.getMostRecentQuery();
            if (mrq == null) {
                return null;
            }
            return mrq;
        }
        if (!data_key.endsWith(RESULT_SUFFIX)) {
            data_key = data_key + RESULT_SUFFIX;
        }
        if ((qd = this.getQueryData(data_key)) == null) {
            return null;
        }
        return qd.getMostRecentQueryD();
    }

    public EGSOContext getContext(String data_key) throws ArgumentException {
        QueryData qd;
        if (data_key == null) {
            EGSOContext mrc = this.getMostRecentContext();
            return mrc;
        }
        if (!data_key.endsWith(RESULT_SUFFIX)) {
            data_key = data_key + RESULT_SUFFIX;
        }
        if ((qd = this.getQueryData(data_key)) == null) {
            return null;
        }
        return qd.getMostRecentContextD();
    }

    public synchronized void applyUpdate(String data_key, Data data, String querySource, EGSOContext context) throws ConsumerException {
        this.setMostRecentContext(context);
        this.setMostRecentQuery(querySource);
        this.getQueryData(data_key).applyUpdate(data, querySource, context);
    }

    public synchronized void applyUpdate(String data_key, Data data) throws ConsumerException {
        this.setMostRecentContext(null);
        this.setMostRecentQuery(null);
        this.getQueryData(data_key).applyUpdate(data, null, null);
    }

    public class QueryResult
    extends QueryData {
        public QueryResult(String catalogue, String id, GenericType type) throws ArgumentException {
            super(catalogue, id + GenericQuery.RESULT_SUFFIX, type);
            this.setReadonly(true);
        }

        public String toString() {
            return "QueryResult(" + super.toString() + ")";
        }
    }

    public class QueryParameter
    extends QueryData {
        public QueryParameter(String catalogue, String id, GenericType type) throws ArgumentException {
            super(catalogue, id + GenericQuery.PARAMETER_SUFFIX, type);
            this.setReadonly(false);
        }

        public String toString() {
            return "QueryParameter(" + super.toString() + ")";
        }
    }

    public abstract class QueryData
    extends AbstractLogEnabled {
        private final String data_key;
        private boolean readonly = false;
        private GenericType type = null;
        private GenericData data = null;
        private Collection dependsOn = null;
        private Collection requires = null;
        private long modStamp = 0L;
        private Updator updator = null;
        private Collection catalogues = new LinkedList();
        private String mostRecentQueryD = null;
        private EGSOContext mostRecentContextD = null;

        public QueryData(String catalogue, String data_key, GenericType type) throws ArgumentException {
            DataKeyValidator.validateDataKey(data_key);
            this.data_key = data_key;
            if (type == null) {
                ArgumentException aex = new ArgumentException("type expected instead of null");
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)aex);
                }
                throw aex;
            }
            this.type = type;
            if (catalogue != null) {
                this.addCatalogue(catalogue);
            }
            GenericQuery.this.putQueryData(this);
        }

        public QueryData(String catalogue, String id, GenericData data) throws ArgumentException {
            this(catalogue, id, (GenericType)data.type());
            this.data = data;
            this.modStamp();
        }

        public synchronized String getDataKey() {
            return this.data_key;
        }

        public synchronized boolean isReadonly() {
            return this.readonly;
        }

        public synchronized void setReadonly(boolean b) {
            this.readonly = b;
        }

        public synchronized Collection getDependsOn() {
            if (this.dependsOn == null) {
                this.dependsOn = new LinkedList();
            }
            return this.dependsOn;
        }

        public synchronized Collection getRequires() {
            if (this.requires == null) {
                this.requires = new LinkedList();
            }
            return this.requires;
        }

        public synchronized Type getType() {
            return this.type;
        }

        public synchronized GenericData getData() throws ConsumerException {
            if (this.data == null && !this.isReadonly()) {
                return (GenericData)this.getType().newData();
            }
            return this.data;
        }

        public synchronized void setDependsOn(Collection collection) {
            this.dependsOn = new LinkedList(collection);
        }

        public synchronized void setRequires(Collection collection) {
            this.requires = new LinkedList(collection);
        }

        public synchronized void setType(Type type) {
            this.type = (GenericType)type;
        }

        synchronized void setData(Data data) {
            this.data = (GenericData)data;
            this.modStamp();
        }

        protected synchronized void modStamp() {
            this.modStamp = GenericQuery.this.incModCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean dependsOnDirty() throws ArgumentException {
            GenericQuery genericQuery = GenericQuery.this;
            synchronized (genericQuery) {
                Iterator it = GenericQuery.this.affectedBy(this.getDataKey()).iterator();
                while (it.hasNext()) {
                    String data_key = (String)it.next();
                    try {
                        if (GenericQuery.this.getQueryData(data_key).getModStamp() <= this.modStamp) continue;
                        return true;
                    }
                    catch (ArgumentException ex) {
                        this.getLogger().error((Object)ex);
                    }
                }
            }
            return false;
        }

        synchronized long getModStamp() {
            return this.modStamp;
        }

        synchronized void setModStamp(long l) {
            this.modStamp = l;
        }

        public boolean update() throws ConsumerException {
            if (!this.dependsOnDirty() && this.getModStamp() > 0L) {
                return false;
            }
            Updator updator = this.getUpdator();
            if (updator != null) {
                updator.update(GenericQuery.this, this.getDataKey());
            }
            return true;
        }

        synchronized Updator getUpdator() {
            return this.updator;
        }

        public synchronized void setUpdator(Updator updator) {
            this.updator = updator;
        }

        public synchronized boolean addDependsOn(String dependsOn_data_key) {
            if (this.dependsOn == null) {
                this.dependsOn = new LinkedList();
            }
            return this.dependsOn.add(dependsOn_data_key);
        }

        public synchronized boolean addRequires(String requires_data_key) {
            if (this.requires == null) {
                this.requires = new LinkedList();
            }
            this.addDependsOn(requires_data_key);
            return this.requires.add(requires_data_key);
        }

        public synchronized String toString() {
            return "QueryData(data_key=" + this.getDataKey() + " readonly=" + this.isReadonly() + " type=" + this.getType() + " value=" + this.data + " dependsOn=" + this.getDependsOn() + " modStamp=" + this.modStamp + ")";
        }

        public synchronized void unset() {
            this.data = null;
            this.modStamp();
        }

        public synchronized boolean isSet() {
            return this.data != null;
        }

        synchronized void makeDirty() {
            this.modStamp = 0L;
        }

        public synchronized boolean addCatalogue(String catalogue) {
            return this.catalogues.add(catalogue);
        }

        public synchronized boolean removeCatalogue(String catalogue) {
            return this.catalogues.remove(catalogue);
        }

        public synchronized Collection getCatalogues() {
            return Collections.unmodifiableCollection(this.catalogues);
        }

        private synchronized void setMostRecentQueryD(String querySource) {
            this.mostRecentQueryD = querySource;
        }

        private synchronized String getMostRecentQueryD() {
            return this.mostRecentQueryD;
        }

        private synchronized void setMostRecentContextD(EGSOContext context) {
            this.mostRecentContextD = context;
        }

        private synchronized EGSOContext getMostRecentContextD() {
            return this.mostRecentContextD;
        }

        synchronized void applyUpdate(Data data, String querySource, EGSOContext context) {
            this.setData(data);
            this.setMostRecentQueryD(querySource);
            this.setMostRecentContextD(context);
            try {
                GenericQuery.this.unset(GenericQuery.this.unResult(this.data_key));
            }
            catch (ConsumerException e) {
                // empty catch block
            }
        }

        public void unput() throws ArgumentException {
            GenericQuery.this.unputQueryData(this);
        }
    }
}

