/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.eci;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.IOUtils;
import org.egso.common.configuration.NamedConfigurationFactory;
import org.egso.common.context.EGSOContext;
import org.egso.common.context.EGSOContextFactory;
import org.egso.common.externalinteraction.InteractionManager;
import org.egso.common.externalinteraction.InteractionManagerException;
import org.egso.common.externalinteraction.InteractionManagerFactory;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.common.network.ApplicationDiscovery;
import org.egso.common.services.broker.QueryBroker;
import org.egso.common.services.provider.CoSECProvider;
import org.egso.comms.eis.adapter.Session;
import org.egso.comms.nds.types.Application;
import org.egso.consumer.ConfigurationLiterals;
import org.egso.consumer.Consumer;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.MultipleException;
import org.egso.consumer.eci.ECIFacade;
import org.egso.consumer.eci.QueryBrokerResponseImpl;
import org.egso.consumer.plot.CosecException;

public class ECIConnector
extends AbstractLogEnabled
implements ECIFacade,
ConfigurationLiterals {
    static final int ROLE_CONSUMER = 1;
    static final int ROLE_BROKER = 2;
    static final int ROLE_PROVIDER = 3;
    static /* synthetic */ Class class$org$egso$common$services$broker$QueryBroker;
    static /* synthetic */ Class class$org$egso$common$services$broker$ResponseQueryBroker;
    static /* synthetic */ Class class$org$egso$common$services$provider$CoSECProvider;

    private List getApps(int role) throws ConsumerException {
        Configuration config;
        switch (role) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new ArgumentException("role type " + role + " not supported.");
            }
        }
        try {
            Consumer.getInstance();
        }
        catch (Exception e) {
            throw new ConsumerException("Exception while intialising the consumer: " + e.getMessage(), e);
        }
        ApplicationDiscovery directory = null;
        LinkedList entries = null;
        directory = new ApplicationDiscovery();
        try {
            switch (role) {
                case 2: {
                    entries = directory.getBrokerApplications();
                    break;
                }
                case 1: {
                    entries = directory.getConsumerApplications();
                    break;
                }
                case 3: {
                    entries = directory.getProviderApplications();
                }
            }
        }
        catch (InteractionManagerException ex) {
            throw new ConsumerException(ex);
        }
        String enforceBroker = null;
        if (role == 2 && (enforceBroker = (config = NamedConfigurationFactory.getConfigurationByName((String)"org.egso.consumer")).getString("consumer.eci.enforce-broker", null)) != null && this.getLogger().isInfoEnabled()) {
            this.getLogger().info((Object)("broker " + enforceBroker + " enforced!"));
        }
        entries = new LinkedList(entries);
        Iterator it = entries.iterator();
        String applist = null;
        while (it.hasNext()) {
            Application entry = (Application)it.next();
            if (!entry.isAlive()) {
                it.remove();
                continue;
            }
            if (role == 2 && enforceBroker != null && !enforceBroker.equals(entry.getId())) {
                it.remove();
                continue;
            }
            applist = (applist == null ? "" : applist + ", ") + entry.getName() + " [" + entry.getId() + "]";
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("detected " + entries.size() + " eci apps of role " + role + (role == 2 ? " (broker)" : "") + (role == 3 ? " (provider)" : "") + (role == 1 ? " (consumer)" : "") + ": " + applist + (enforceBroker != null && role == 2 ? " (other brokers may be hidden due to the enforced broker)" : "")));
        }
        return entries;
    }

    private Session getSession(Application recipient) throws ConsumerException {
        try {
            Consumer.getInstance();
        }
        catch (Exception e) {
            throw new ConsumerException("Exception while intialising the consumer: " + e.getMessage(), e);
        }
        Session session = null;
        InteractionManager interactionManager = InteractionManagerFactory.getInteractionManager();
        try {
            session = interactionManager.getSession("philipp", "pasword", recipient.getId());
            session = interactionManager.getSession("philipp", "pasword", recipient.getId());
        }
        catch (InteractionManagerException e) {
            throw new ConsumerException("InteractionManagerException while setting up a session: " + e.getMessage(), e);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Session created for " + recipient));
        }
        return session;
    }

    private Session getSession(URI partner) throws ConsumerException {
        Session session = null;
        InteractionManager interactionManager = InteractionManagerFactory.getInteractionManager();
        try {
            session = interactionManager.getSession("philipp", "pasword", partner);
            session = interactionManager.getSession("philipp", "pasword", partner);
        }
        catch (InteractionManagerException e) {
            throw new ConsumerException("InteractionManagerException while setting up a session: " + e.getMessage(), e);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Session created for " + partner));
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void callBroker(ECIFacade.ECI_args_t args) throws ConsumerException {
        Session session;
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info((Object)("send context = " + (args.context == null ? "not initialized yet" : args.context.toString())));
            this.getLogger().info((Object)("send query = " + args.query));
        }
        try {
            session = this.getSession(new URI(ApplicationDiscovery.APPLICATION_TYPE_BROKER));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Internal Error creating Broker URI: " + e.getMessage(), e);
        }
        catch (ConsumerException e) {
            throw new ConsumerException("Unable to connect to any broker. Possible reason: Network problem (Hint: " + e.getMessage() + "). Check ping tool and log file for more information.", (Throwable)((Object)e));
        }
        if (session == null) {
            throw new ConsumerException("Unable to connect to any broker. Possible reason: Network problem. Check ping tool and log file for more information.");
        }
        try {
            EGSOContext queryContext = args.context;
            if (queryContext == null) {
                queryContext = args.context = Consumer.getContextFactory().createContext(1);
                this.getLogger().info((Object)("send new created context = " + (args.context == null ? "not initialized yet" : args.context.toString())));
            }
            Object monitor = new Object();
            String context = null;
            DataHandler results = null;
            QueryBroker queryBrokerAsync = null;
            QueryBrokerResponseImpl brokerResponseHandler = new QueryBrokerResponseImpl(monitor);
            try {
                queryBrokerAsync = (QueryBroker)session.getObject(class$org$egso$common$services$broker$QueryBroker == null ? (class$org$egso$common$services$broker$QueryBroker = ECIConnector.class$("org.egso.common.services.broker.QueryBroker")) : class$org$egso$common$services$broker$QueryBroker, (Object)brokerResponseHandler, class$org$egso$common$services$broker$ResponseQueryBroker == null ? (class$org$egso$common$services$broker$ResponseQueryBroker = ECIConnector.class$("org.egso.common.services.broker.ResponseQueryBroker")) : class$org$egso$common$services$broker$ResponseQueryBroker);
            }
            catch (Exception e) {
                this.getLogger().info((Object)e);
                throw new ConsumerException("Exception while getting a remote proxy object: " + e.getMessage(), e);
            }
            queryContext.addRoute("query issued", "new broker query");
            String brokerquery = args.query;
            long startTime = System.currentTimeMillis();
            Object object = monitor;
            synchronized (object) {
                try {
                    queryBrokerAsync.query(queryContext.toXML(true), brokerquery);
                }
                catch (UndeclaredThrowableException ute) {
                    this.getLogger().info((Object)ute);
                    Throwable cause = ute.getCause();
                    if (cause != null) throw new ConsumerException(cause.getMessage() != null ? cause.getMessage() : cause.getClass().getName() + " while executing a query.", cause);
                    cause = ute;
                    throw new ConsumerException(cause.getMessage() != null ? cause.getMessage() : cause.getClass().getName() + " while executing a query.", cause);
                }
                catch (Exception e) {
                    this.getLogger().info((Object)e);
                    throw new ConsumerException(e.getMessage() != null ? e.getMessage() : e.getClass().getName() + " while executing the query.", e);
                }
                try {
                    monitor.wait(1800000L);
                }
                catch (InterruptedException ex) {
                    this.getLogger().info((Object)ex);
                    throw new ConsumerException("could not wait for the broker's response: " + ex.getMessage(), ex);
                }
            }
            context = brokerResponseHandler.getContext();
            results = brokerResponseHandler.getResults();
            String theResult = null;
            if (results != null) {
                try {
                    theResult = IOUtils.toString((InputStream)results.getInputStream());
                }
                catch (IOException e) {
                    this.getLogger().info((Object)e);
                    throw new ConsumerException("Interal Error: " + e.getMessage(), e);
                }
            }
            args.answer = theResult;
            args.context = EGSOContextFactory.newInstance((int)1, (String)Consumer.getConsumerId(), (String)Consumer.getVersion(), (String)Consumer.getHostAddress()).createContext(context);
            args.context.addRoute("answer received", "The answer has arrived at the consumer.");
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info((Object)("call to ECI completed within " + (System.currentTimeMillis() - startTime) + " millisecs."));
            }
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info((Object)("received answer = " + args.answer));
                this.getLogger().info((Object)("result came along with context: " + args.context));
            }
            Object var17_21 = null;
            if (session == null) return;
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            if (session == null) throw throwable;
            InteractionManager interactionManager = InteractionManagerFactory.getInteractionManager();
            interactionManager.releaseSession(session);
            throw throwable;
        }
        InteractionManager interactionManager = InteractionManagerFactory.getInteractionManager();
        interactionManager.releaseSession(session);
    }

    public String callCosec(String startDate, String endDate, int type) throws ConsumerException {
        LinkedList<ConsumerException> exceptions = new LinkedList<ConsumerException>();
        List providers = this.getApps(3);
        Iterator it = providers.iterator();
        System.out.println("WARNING: Unsolved quickfix in ECIConnector.callCoSEC");
        while (it.hasNext()) {
            Application app = (Application)it.next();
            if (app.getId().matches(".*codem.*")) {
                try {
                    return this.callCosec(startDate, endDate, type, app);
                }
                catch (ConsumerException ex) {
                    exceptions.add(new ConsumerException((Throwable)((Object)ex)));
                    continue;
                }
                catch (Exception ex) {
                    exceptions.add(new ConsumerException(ex));
                    continue;
                }
            }
            String msg = "Provider " + app.getId() + " does not support CoSEC ";
            exceptions.add(new ConsumerException(msg));
            this.getLogger().warn((Object)msg);
        }
        throw new MultipleException("all " + providers.size() + " CoSEC providers have failed.", exceptions.toArray(new Throwable[exceptions.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String callCosec(String startDate, String endDate, int type, Application recipient) throws ConsumerException {
        String string;
        block20: {
            Session session = this.getSession(recipient);
            try {
                CoSECProvider provider;
                try {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)"getting (proxi for) QueryProvider ...");
                    }
                    provider = (CoSECProvider)session.getObject(class$org$egso$common$services$provider$CoSECProvider == null ? (class$org$egso$common$services$provider$CoSECProvider = ECIConnector.class$("org.egso.common.services.provider.CoSECProvider")) : class$org$egso$common$services$provider$CoSECProvider);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)"got (proxy for) CoSECProvider.");
                    }
                }
                catch (Exception ex) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("failed to get a CoSECProvider proxy object: " + ex.getMessage()), (Throwable)ex);
                    }
                    throw new CosecException("getCosecPlot unavailable", ex);
                }
                String url = null;
                try {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)"going to invoke cosec plot on provider ... ");
                    }
                    switch (type) {
                        case 1: {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug((Object)("call cosecPlotGoesProtons(" + startDate + ", " + endDate + ")"));
                            }
                            url = provider.cosecPlotGoesProtons(startDate, endDate);
                            if (!this.getLogger().isDebugEnabled()) break;
                            this.getLogger().debug((Object)("returned url = " + url));
                            break;
                        }
                        case 2: {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug((Object)("call cosecPlotGoesXrays(" + startDate + ", " + endDate + ")"));
                            }
                            url = provider.cosecPlotGoesXrays(startDate, endDate);
                            if (!this.getLogger().isDebugEnabled()) break;
                            this.getLogger().debug((Object)("returned url = " + url));
                            break;
                        }
                        default: {
                            throw new CosecException("illegal type argument in getCosecPlot");
                        }
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("invokation returned: got url = " + url));
                    }
                }
                catch (Exception ex) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("cosec service invokation failed: " + ex.getMessage()), (Throwable)ex);
                    }
                    throw new CosecException("getCosecPlot unavailable: " + ex.getMessage(), ex);
                }
                if (url.startsWith("no result:")) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("cosec service invokation failed: " + url));
                    }
                    throw new CosecException(url + " (CoSEC is probably currently out of order)");
                }
                string = url;
                Object var10_11 = null;
                if (session == null) break block20;
            }
            catch (Throwable throwable) {
                block21: {
                    Object var10_12 = null;
                    if (session == null) break block21;
                    InteractionManager interactionManager = InteractionManagerFactory.getInteractionManager();
                    interactionManager.releaseSession(session);
                }
                throw throwable;
            }
            InteractionManager interactionManager = InteractionManagerFactory.getInteractionManager();
            interactionManager.releaseSession(session);
        }
        return string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Consumer.getInstance();
    }
}

