/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import org.egso.consumer.ftp.FTPException;

public class FTPSocket {
    public static final String EOL = "\r\n";
    public static final int DEFAULT_PORT = 21;
    public static final String ASCII = "A";
    public static final String BINARY = "I";
    private boolean verbose = false;
    private Socket ftpSocket = null;
    private Writer writer = null;
    private BufferedReader reader = null;

    public FTPSocket(String server) throws IOException, FTPException {
        this(server, 21);
    }

    public FTPSocket(String server, int port) throws IOException, FTPException {
        this.ftpSocket = new Socket(server, port);
        this.initStreams();
        this.validateConnection();
    }

    public FTPSocket(InetAddress address) throws IOException, FTPException {
        this(address, 21);
    }

    public FTPSocket(InetAddress address, int port) throws IOException, FTPException {
        this.ftpSocket = new Socket(address, port);
        this.initStreams();
        this.validateConnection();
    }

    public void setVerbose(boolean verb) {
        this.verbose = verb;
    }

    private void validateConnection() throws IOException, FTPException {
        String response = this.readResponse();
        this.validateResponse(response, "220");
    }

    private void initStreams() throws IOException {
        InputStream is = this.ftpSocket.getInputStream();
        this.reader = new BufferedReader(new InputStreamReader(is));
        OutputStream os = this.ftpSocket.getOutputStream();
        this.writer = new OutputStreamWriter(os);
    }

    public String getRemoteHostName() {
        return this.ftpSocket.getInetAddress().getHostName();
    }

    public void logout() throws IOException {
        this.writer.close();
        this.reader.close();
        this.ftpSocket.close();
    }

    public Socket createDataSocket() throws IOException, FTPException {
        String response = this.sendCommand("PASV");
        this.validateResponse(response, "227");
        int a = response.indexOf(40);
        int b = response.indexOf(41);
        String ipData = response.substring(a + 1, b);
        int[] parts = new int[6];
        int taille = ipData.length();
        int pos = 0;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < taille && pos <= 6; ++i) {
            char c = ipData.charAt(i);
            if (Character.isDigit(c)) {
                sb.append(c);
            } else if (c != ',') {
                throw new FTPException("Malformed PASV reply: " + response);
            }
            if (c != ',' && i + 1 != taille) continue;
            try {
                parts[pos] = Integer.parseInt(sb.toString());
                ++pos;
                sb.setLength(0);
                continue;
            }
            catch (NumberFormatException e) {
                throw new FTPException("Malformed PASV reply: " + response);
            }
        }
        String ipAddress = parts[0] + "." + parts[1] + "." + parts[2] + "." + parts[3];
        int port = (parts[4] << 8) + parts[5];
        return new Socket(ipAddress, port);
    }

    public String sendCommand(String cmd) throws IOException {
        this.writer.write(cmd + EOL);
        this.writer.flush();
        return this.readResponse();
    }

    public String readResponse() throws IOException {
        StringBuffer response = new StringBuffer(this.reader.readLine());
        if (this.verbose) {
            System.out.println(response.toString());
        }
        String codeResponse = response.toString().substring(0, 3);
        if (response.charAt(3) == '-') {
            boolean complete = false;
            String line = null;
            while (!complete) {
                line = this.reader.readLine();
                if (line.length() == 0) continue;
                if (this.verbose) {
                    System.out.println(line);
                }
                if (line.substring(0, 3).equals(codeResponse) && line.charAt(3) == ' ') {
                    response.append(line.substring(3));
                    complete = true;
                    continue;
                }
                response.append(" ");
                response.append(line);
            }
        }
        return response.toString();
    }

    public void validateResponse(String response, String correctCodeResponse) throws FTPException {
        String codeResponse = response.substring(0, 3);
        if (!codeResponse.equals(correctCodeResponse)) {
            throw new FTPException(response.substring(4));
        }
    }

    public void validateResponse(String response, String[] correctCodesResponse) throws FTPException {
        String codeResponse = response.substring(0, 3);
        for (int i = 0; i < correctCodesResponse.length; ++i) {
            if (!codeResponse.equals(correctCodesResponse[i])) continue;
            return;
        }
        throw new FTPException(response.substring(4));
    }
}

