/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.model.DependencyResolver;
import org.egso.consumer.model.Mandatory;
import org.egso.consumer.model.Model;
import org.egso.consumer.process.PQuery;
import org.egso.consumer.valid.ParameterNameValidator;

public class CatalogueModel
implements Model {
    public static final String PARAM_PREFIX = "param-";
    public static final String RESULT_PREFIX = "result-";
    public static final Collection known_namespaces;
    private Map params = new HashMap();

    CMParam getByKey(String qualified_data_key) {
        return (CMParam)this.params.get(qualified_data_key);
    }

    CMParam getByKey(String prefix, String data_key) {
        return (CMParam)this.params.get(prefix + data_key);
    }

    CMParam getParam(String param_key) {
        return (CMParam)this.params.get(PARAM_PREFIX + param_key);
    }

    CMParam getResult(String result_key) {
        return (CMParam)this.params.get(RESULT_PREFIX + result_key);
    }

    public synchronized Map collectItems(PQuery query, String result_data_key) {
        HashMap queryBase = new HashMap();
        System.out.println("collect datas for result " + result_data_key);
        CMParam result_param = this.getByKey(result_data_key);
        queryBase.putAll(result_param.collectItems(query));
        return queryBase;
    }

    static {
        HashSet<String> nss = new HashSet<String>();
        nss.add(PARAM_PREFIX);
        nss.add(RESULT_PREFIX);
        known_namespaces = Collections.unmodifiableSet(nss);
    }

    public class CMResult
    extends CMParam {
        private Map dependencies = new HashMap();

        public CMResult(String result_key) throws ArgumentException {
            super(CatalogueModel.RESULT_PREFIX, result_key);
        }

        public CMResult(String result_key, CMParam[] contributors) throws ArgumentException {
            this(result_key);
            for (int i = 0; i < contributors.length; ++i) {
                new CMDependency(contributors[i]);
            }
        }

        Map collectItems(PQuery query) {
            HashMap collectedItems = new HashMap();
            Iterator it = this.dependencies.values().iterator();
            while (it.hasNext()) {
                CMDependency dependency = (CMDependency)it.next();
                collectedItems.putAll(dependency.collectItems(query));
            }
            return collectedItems;
        }

        public class CMDependency {
            private CMParam contributor;
            private DependencyResolver resolvingStrategy = new Mandatory();

            public CMDependency(CMParam contributor) {
                this.contributor = contributor;
                CMDependency previousDependencyMapping = CMResult.this.dependencies.put(contributor.getDataKey(), this);
                if (previousDependencyMapping != null) {
                    throw new RuntimeException("another dependency already exists to the same parameter '" + contributor.getDataKey() + "'");
                }
            }

            public CMDependency(CMParam contributor, DependencyResolver resolvingStrategy) {
                this(contributor);
                this.resolvingStrategy = resolvingStrategy;
            }

            synchronized CMParam getContributor() {
                return this.contributor;
            }

            Map collectItems(PQuery query) {
                return this.resolvingStrategy.resolve(query, this);
            }
        }
    }

    public class CMParam {
        private String param_key;
        private String namespace;

        protected CMParam(String prefix, String param_key) throws ArgumentException {
            if (!known_namespaces.contains(prefix)) {
                throw new ArgumentException("invalid parameter namespace: " + prefix);
            }
            ParameterNameValidator.validateParameterName(param_key);
            this.namespace = prefix;
            this.param_key = param_key;
            CMParam previousParamMapping = CatalogueModel.this.params.put(prefix + param_key, this);
            if (previousParamMapping != null) {
                throw new ArgumentException("another parameter already exists with the same name '" + param_key + "'");
            }
        }

        public CMParam(String param_key) throws ArgumentException {
            this(CatalogueModel.PARAM_PREFIX, param_key);
        }

        String getDataKey() {
            return this.namespace + this.param_key;
        }

        public String getParamName() {
            return this.param_key;
        }

        Map collectItems(PQuery query) {
            HashMap<String, String> collectedItems = new HashMap<String, String>();
            collectedItems.put(this.param_key, "query.get('" + this.param_key + "')");
            return collectedItems;
        }
    }
}

