/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.plot;

import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.eci.ECIFacade;
import org.egso.consumer.eci.ECIFactory;
import org.egso.consumer.plot.CosecAccess;
import org.egso.consumer.plot.CosecException;
import org.egso.consumer.util.Convert;

public class CosecAccessImpl
extends AbstractLogEnabled
implements CosecAccess {
    private final ECIFacade eci = new ECIFactory().create();

    public String getCosecPlot(String startDate, String endDate) throws ConsumerException {
        return this.getCosecPlot(startDate, endDate, 2);
    }

    public String getCosecPlot(String startDate, String endDate, int type) throws ConsumerException {
        Convert.str2date(startDate);
        Convert.str2date(endDate);
        switch (type) {
            case 1: 
            case 2: {
                if (!this.getLogger().isDebugEnabled()) break;
                this.getLogger().debug((Object)("plot type recognized (type=" + type + ")"));
                break;
            }
            default: {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("plot type not recognized (type=" + type + ")"));
                }
                throw new CosecException("illegal type argument in getCosecPlot");
            }
        }
        String url = this.eci.callCosec(startDate, endDate, type);
        return url;
    }
}

