/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.plot;

import java.net.MalformedURLException;
import java.net.URL;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.ImmutableException;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.eci.ECIFacade;
import org.egso.consumer.eci.ECIFactory;
import org.egso.consumer.types.ImageData;

public class LazyCosecImageData
extends ImageData {
    private CosecCallArguments args = null;
    private final ECIFacade eci = new ECIFactory().create();

    public LazyCosecImageData() throws ArgumentException, ConsumerException {
        this((LazyCosecImageType)null);
    }

    public LazyCosecImageData(LazyCosecImageType type) throws ArgumentException, ConsumerException {
        super(type != null ? type : new LazyCosecImageType());
    }

    public LazyCosecImageData(LazyCosecImageType type, Object value) throws ConsumerException {
        this(type);
        this.setValue(value);
    }

    public LazyCosecImageData(Object initialValue) throws ConsumerException {
        this(null, initialValue);
    }

    public void setValue(Object value) throws ConsumerException {
        if (value instanceof CosecCallArguments) {
            this.args = (CosecCallArguments)value;
        } else {
            this.args = null;
            this.put("url", null);
            super.setValue(value);
        }
    }

    public URL getImageURL() throws ConsumerException {
        if (this.get("url") == null && this.args != null) {
            String url = this.eci.callCosec(this.args.startDate, this.args.endDate, this.args.plotType);
            if (url == null) {
                return null;
            }
            if (url.indexOf("tashmetum") < 0) {
                this.setValue(url);
            } else {
                try {
                    return new URL(url);
                }
                catch (MalformedURLException ex) {
                    this.getLogger().warn((Object)ex);
                }
            }
        }
        return super.getImageURL();
    }

    public String toString() {
        return "LazyCosecImageData(from=" + this.args.startDate + " " + "to=" + this.args.endDate + " " + "type=" + this.args.plotType + " " + super.toString() + ")";
    }

    protected boolean equalsNr(GenericData otherData) {
        if (otherData instanceof LazyCosecImageData) {
            return this.equalsNr((LazyCosecImageData)otherData);
        }
        return false;
    }

    protected boolean equalsNr(LazyCosecImageData otherData) {
        return this.args.equals(otherData.args);
    }

    public static class CosecCallArguments {
        public final String startDate;
        public final String endDate;
        public final int plotType;

        public CosecCallArguments(String start, String end, int type) {
            this.startDate = start;
            this.endDate = end;
            this.plotType = type;
        }
    }

    public static class LazyCosecImageType
    extends ImageData.ImageType {
        public LazyCosecImageType(String typeName) throws ArgumentException, ConsumerException {
            super(typeName);
            try {
                this.setNeutralData(new LazyCosecImageData(this));
            }
            catch (ImmutableException ex) {
                this.getLogger().error((Object)ex);
            }
        }

        public LazyCosecImageType() throws ArgumentException, ConsumerException {
            this("image");
        }

        public synchronized String toString() {
            return "LazyCosecImageData.LazyCosecImageType(" + super.toString() + ")";
        }
    }
}

