/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.remotequery;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Interval;
import org.egso.consumer.api.ParameterRequiredException;
import org.egso.consumer.api.ScalarData;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.eci.ECIFacade;
import org.egso.consumer.eci.ECIFactory;
import org.egso.consumer.plot.LazyCosecImageData;
import org.egso.consumer.remotequery.FieldSelectorFactory;
import org.egso.consumer.remotequery.VOTableData;
import org.egso.consumer.types.DateData;
import org.egso.consumer.types.DoubleData;
import org.egso.consumer.types.IntegerData;
import org.egso.consumer.types.IntervalData;

public class BasicCatalogue
extends AbstractLogEnabled
implements EGSOLiterals {
    private final ECIFacade eci;
    protected final String catalogue;
    protected static GenericType dateType;
    protected static IntervalData.IntervalType dateIntervalType;
    protected static GenericType plotType;
    protected static GenericType itudeType;
    protected static GenericType complexitudeType;
    protected static GenericType narType;
    protected static GenericType xrayClassType;
    protected static GenericType uniqueIdType;
    protected static GenericType eventCatType;
    protected static GenericType plotTypeSelectorType;
    protected static FieldSelectorFactory fsFactory;

    protected BasicCatalogue(String catalogue_name) throws ConsumerException {
        this.catalogue = catalogue_name;
        this.eci = new ECIFactory().create();
    }

    protected final ECIFacade eci() {
        return this.eci;
    }

    public synchronized void initialize(GenericQuery q) throws ConsumerException {
        if (dateType == null && dateIntervalType == null && itudeType == null && complexitudeType == null && uniqueIdType == null && eventCatType == null && plotTypeSelectorType == null && narType == null) {
            dateType = DateData.getDateType();
            IntervalData.IntervalType.DefaultKeys intervalKeys = new IntervalData.IntervalType.DefaultKeys(){

                public String MIN() {
                    return "start-date";
                }

                public String MAX() {
                    return "end-date";
                }
            };
            dateIntervalType = new IntervalData.IntervalType("interval-of-date", dateType, intervalKeys);
            plotType = new LazyCosecImageData.LazyCosecImageType("plot-type");
            itudeType = new DoubleData.DoubleType("itude");
            complexitudeType = new GenericType("complexitude");
            complexitudeType.setNeutralData(new GenericData(complexitudeType){

                public void setValue(Object value) throws ConsumerException {
                    if (value instanceof Object[] && ((Object[])value).length == 2) {
                        ((GenericData)this.get("longitude")).setValue(((Object[])value)[0]);
                        ((GenericData)this.get("latitude")).setValue(((Object[])value)[1]);
                    } else {
                        super.setValue(value);
                    }
                }
            });
            complexitudeType.childrenTypes().put("longitude", itudeType);
            complexitudeType.childrenTypes().put("latitude", itudeType);
            uniqueIdType = new IntegerData.IntegerType("unique-id");
            eventCatType = new GenericType("event-type");
            GenericType eventCatListType = new GenericType("set-of-event-type");
            eventCatListType.setElemsType(eventCatType);
            Data eventCatDomain = eventCatListType.newData();
            eventCatType.setValueDomain((GenericData)eventCatDomain);
            plotTypeSelectorType = new GenericType("plottypetype");
            GenericType plotTypeSelectorListType = new GenericType("plottypelisttype");
            plotTypeSelectorListType.setElemsType(plotTypeSelectorType);
            GenericData plotTypeSelectorVD = (GenericData)plotTypeSelectorListType.newData();
            GenericData plotTypeXraySelector = (GenericData)plotTypeSelectorType.newData();
            plotTypeXraySelector.setId("goes-plot-xray");
            plotTypeSelectorVD.add(plotTypeXraySelector);
            GenericData plotTypeProtonSelector = (GenericData)plotTypeSelectorType.newData();
            plotTypeProtonSelector.setId("goes-plot-proton");
            plotTypeSelectorVD.add(plotTypeProtonSelector);
            plotTypeSelectorType.setValueDomain(plotTypeSelectorVD);
            IntegerData.IntegerType narValueType = new IntegerData.IntegerType("nar");
            narType = new IntervalData.IntervalType(narValueType);
        }
        if (!q.findAll().contains("date")) {
            GenericQuery genericQuery = q;
            genericQuery.getClass();
            genericQuery.new GenericQuery.QueryParameter(null, "date", dateIntervalType);
        }
        if (!q.findAll().contains("start-date")) {
            GenericQuery genericQuery = q;
            genericQuery.getClass();
            genericQuery.new GenericQuery.QueryParameter(null, "start-date", dateIntervalType);
        }
        if (!q.findAll().contains("end-date")) {
            GenericQuery genericQuery = q;
            genericQuery.getClass();
            genericQuery.new GenericQuery.QueryParameter(null, "end-date", dateIntervalType);
        }
        if (!q.findAll().contains("location")) {
            GenericQuery genericQuery = q;
            genericQuery.getClass();
            genericQuery.new GenericQuery.QueryParameter(null, "location", complexitudeType);
        }
        if (!q.findAll().contains("longitude")) {
            GenericQuery genericQuery = q;
            genericQuery.getClass();
            genericQuery.new GenericQuery.QueryParameter(null, "longitude", itudeType);
        }
        if (!q.findAll().contains("latitude")) {
            GenericQuery genericQuery = q;
            genericQuery.getClass();
            genericQuery.new GenericQuery.QueryParameter(null, "latitude", itudeType);
        }
        if (!q.findAll().contains("prefetch-plot-type")) {
            GenericQuery genericQuery = q;
            genericQuery.getClass();
            genericQuery.new GenericQuery.QueryParameter(null, "prefetch-plot-type", plotTypeSelectorType);
        }
        if (!q.findAll().contains("nar")) {
            GenericQuery genericQuery = q;
            genericQuery.getClass();
            genericQuery.new GenericQuery.QueryParameter(null, "nar", narType);
        }
        if (!q.findAll().contains("event-type")) {
            GenericQuery genericQuery = q;
            genericQuery.getClass();
            genericQuery.new GenericQuery.QueryParameter(null, "event-type", eventCatType);
        }
    }

    protected static void checkRequiredParameters(GenericQuery q, String data_key) throws ConsumerException {
        Collection missing = q.stillRequires(data_key);
        if (!missing.isEmpty()) {
            throw new ParameterRequiredException("event", missing, "parameter(s) " + missing + " is/are mandatory for an event query.");
        }
    }

    public boolean update(GenericQuery q, String data_key) throws ConsumerException {
        BasicCatalogue.checkRequiredParameters(q, data_key);
        String query = this.assembleQuery(q, data_key);
        ECIFacade.ECI_args_t args = new ECIFacade.ECI_args_t(query);
        this.eci().callBroker(args);
        String result = args.answer;
        ((GenericType)q.getType(data_key)).setValueDomain(null);
        VOTableData vod = new VOTableData((VOTableData.VOTableType)q.getType(data_key), result);
        vod = this.customizeReturnValue(q, data_key, vod);
        vod.setReadonly(true);
        q.applyUpdate(data_key, vod, query, args.context);
        return true;
    }

    protected VOTableData customizeReturnValue(GenericQuery q, String data_key, VOTableData vod) throws ConsumerException {
        data_key.equals(q);
        return vod;
    }

    protected void customQueryType(GenericQuery q, String data_key, PrintWriter out) throws ConsumerException {
        data_key.equals(q);
        out.print("");
    }

    protected String customCatalogueName(String cat_name) {
        return cat_name;
    }

    protected void customParamName(Data param, String param_name, PrintWriter out) {
        param_name.equals(param.id());
        out.print(param_name);
    }

    protected Data customFieldSelection(PrintWriter out, GenericQuery q, String data_key, Data fields) throws ConsumerException {
        data_key.equals(q);
        out.flush();
        return fields;
    }

    protected void customFieldSelector(GenericQuery q, String data_key, PrintWriter out) throws ConsumerException {
        String fsid = q.unResult(data_key) + "-fs";
        if (!q.findAllParameters().contains(fsid)) {
            return;
        }
        Data fs = q.get(fsid);
        fs = this.customFieldSelection(out, q, data_key, fs);
        Iterator it = fs.elements().iterator();
        out.println("  <select>");
        while (it.hasNext()) {
            Data field = (Data)it.next();
            String fieldid = field.id();
            out.println("    <field name=\"" + fieldid + "\"/>");
        }
        out.println("  </select>");
    }

    protected Collection customCatalogueSet(GenericQuery q, Collection cats) throws ConsumerException {
        return cats;
    }

    protected Collection customParamSetByCat(String cat, Collection params) {
        "".equals(cat);
        return params;
    }

    protected String assembleQuery(GenericQuery q, String data_key) throws ConsumerException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(outStream);
        out.println("<?xml version=\"1.0\"?>");
        out.print("<query");
        this.customQueryType(q, data_key, out);
        out.println(">");
        this.customFieldSelector(q, data_key, out);
        Collection<String> catalogues = new TreeSet(q.catalogues(q.getQueryData(data_key).getDependsOn()));
        TreeSet<String> dependants = new TreeSet<String>(q.getQueryData(data_key).getDependsOn());
        dependants.remove(q.unResult(data_key) + "-fs");
        Iterator etit = dependants.iterator();
        while (etit.hasNext()) {
            String dep_key = (String)etit.next();
            if (dep_key.equals("event-type") || q.isSet(dep_key)) continue;
            etit.remove();
        }
        Iterator eventListsIt = q.get("event-type").valueDomain().elements().iterator();
        while (eventListsIt.hasNext()) {
            Data eventList = (Data)eventListsIt.next();
            if (!q.isSet(eventList.id())) continue;
            dependants.add(eventList.id());
            catalogues.add(eventList.id());
        }
        catalogues = this.customCatalogueSet(q, catalogues);
        Iterator cit = catalogues.iterator();
        while (cit.hasNext()) {
            String cat = (String)cit.next();
            out.print("  <data ");
            String catName = this.customCatalogueName(cat);
            if (catName != null) {
                out.print("type=\"" + catName + "\" ");
            }
            out.print("default-relation=\"AND\" relation=\"AND\">");
            out.println();
            Collection myParamSet = this.customParamSetByCat(cat, dependants);
            Iterator dit = myParamSet.iterator();
            while (dit.hasNext()) {
                String dependant_key = (String)dit.next();
                if (!q.findByCatalogue(cat).contains(dependant_key)) continue;
                Data paramValue = q.getQueryData(dependant_key).getData();
                if (!dependant_key.equals("event-type")) {
                    if (!q.isSet(dependant_key)) {
                        continue;
                    }
                } else if (((Object)paramValue).equals(paramValue.newData())) {
                    Iterator it = q.getType("event-type").valueDomain().elements().iterator();
                    while (it.hasNext()) {
                        Data eventType = (Data)it.next();
                        if (!q.isSet(eventType.id())) continue;
                        paramValue = eventType;
                        break;
                    }
                }
                this.assembleParam(out, q, paramValue, dependant_key, "    ");
                dit.remove();
            }
            out.println("  </data>");
        }
        out.println("</query>");
        out.flush();
        String query = null;
        try {
            outStream.close();
            query = outStream.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new ConsumerException(ex);
        }
        catch (IOException ex) {
            throw new ConsumerException(ex);
        }
        return query;
    }

    protected void assembleParam(PrintWriter out, GenericQuery q, Data param, String param_name, String indent) throws ConsumerException {
        if (param == null) {
            return;
        }
        if (!param_name.equals("event-type") && ((Object)param).equals(param.newData())) {
            return;
        }
        if (indent == null) {
            indent = "";
        }
        out.print(indent);
        out.print("<param name=\"");
        this.customParamName(param, param_name, out);
        out.print("\">");
        out.println();
        if (param instanceof Interval) {
            IntervalData interval = (IntervalData)param;
            ScalarData min = interval.getMin();
            ScalarData max = interval.getMax();
            if (min != null || max != null) {
                out.print(indent);
                out.println("  <interval>");
                if (min != null) {
                    out.print(indent);
                    out.println("    <start>" + min.id() + "</start>");
                }
                if (max != null) {
                    out.print(indent);
                    out.println("    <end>" + max.id() + "</end>");
                }
                out.print(indent);
                out.println("  </interval>");
            }
        } else if (param.isList()) {
            Iterator it = param.elements().iterator();
            while (it.hasNext()) {
                Data element = (Data)it.next();
                if (element instanceof Interval) {
                    IntervalData interval = (IntervalData)element;
                    ScalarData min = interval.getMin();
                    ScalarData max = interval.getMax();
                    if (min == null && max == null) continue;
                    out.print(indent);
                    out.println("  <interval>");
                    if (min != null) {
                        out.print(indent);
                        out.println("    <start>" + min.id() + "</start>");
                    }
                    if (max != null) {
                        out.print(indent);
                        out.println("    <end>" + max.id() + "</end>");
                    }
                    out.print(indent);
                    out.println("  </interval>");
                    continue;
                }
                out.print(indent);
                out.print("  <value>");
                out.print(element.id());
                out.print("</value>");
                out.println();
            }
        } else {
            out.print(indent);
            out.print("  <value>");
            out.print(param.id());
            out.print("</value>");
            out.println();
        }
        out.print(indent);
        out.println("</param>");
    }

    static {
        fsFactory = FieldSelectorFactory.getInstance();
    }
}

