/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.remotequery;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.TreeSet;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.Updator;
import org.egso.consumer.types.FileHandleData;

public class Download
extends AbstractLogEnabled
implements Updator,
EGSOLiterals {
    GenericType fileHandleType = null;

    public synchronized void initialize(GenericQuery q) throws ConsumerException {
        this.fileHandleType = new FileHandleData.FileHandleType("ziparchive");
        GenericQuery genericQuery = q;
        genericQuery.getClass();
        GenericQuery.QueryResult downloadResult = genericQuery.new GenericQuery.QueryResult(null, "download", this.fileHandleType);
        downloadResult.addRequires("links");
        downloadResult.setUpdator(this);
    }

    public boolean update(GenericQuery q, String data_key) throws ConsumerException {
        GenericData links = q.getQueryData("links").getData();
        TreeSet<FileHandleData.FileWithNameMapping> linklist = new TreeSet<FileHandleData.FileWithNameMapping>();
        Iterator it = links.elements().iterator();
        while (it.hasNext()) {
            Data linkData = (Data)it.next();
            String url = linkData.get("link").id();
            if (url == null || "".equals(url)) continue;
            Data observatory = linkData.get("observatory");
            String observatoryName = observatory != null ? observatory.id() : "unknownobservatory";
            Data instrument = linkData.get("instrument");
            String instrumentName = instrument != null ? instrument.id() : "unknowninstrument";
            String path = null;
            try {
                path = new URL(url).getHost() + new URL(url).getPath();
            }
            catch (MalformedURLException ex) {
                path = url;
            }
            FileHandleData.FileWithNameMapping entry = new FileHandleData.FileWithNameMapping(url, observatoryName + "/" + instrumentName + "/" + path);
            linklist.add(entry);
        }
        q.applyUpdate(data_key, this.fileHandleType.newData(linklist));
        return true;
    }
}

