/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.remotequery;

import org.egso.common.context.EGSOContext;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.Updator;
import org.egso.consumer.remotequery.BasicCatalogue;
import org.egso.consumer.remotequery.GoesXrayFlare;
import org.egso.consumer.remotequery.NoaaProtonEventCatalogue;
import org.egso.consumer.remotequery.NoaaSrsArsCatalogue;

public class EventMux
extends AbstractLogEnabled
implements EGSOLiterals {
    public static final String EVENT_CATALOGUE = "event";

    public void initialize(GenericQuery q) throws ConsumerException {
        if (!q.catalogues().contains("goes_xray_flare")) {
            new GoesXrayFlare().initialize(q);
        }
        if (!q.catalogues().contains("noaa_proton_event")) {
            new NoaaProtonEventCatalogue().initialize(q);
        }
        if (!q.catalogues().contains("srs_list")) {
            new NoaaSrsArsCatalogue().initialize(q);
        }
        if (q.catalogues().contains(EVENT_CATALOGUE)) {
            return;
        }
        GenericQuery.QueryParameter eventCatParam = (GenericQuery.QueryParameter)q.getQueryData("event-type");
        eventCatParam.setUpdator(new Updator(){

            public boolean update(GenericQuery q, String data_key) throws ConsumerException {
                GenericData eventcat = q.getQueryData("event-type").getData();
                String eventcatid = eventcat != null ? eventcat.id() : null;
                try {
                    q.getQueryData(EventMux.EVENT_CATALOGUE).unput();
                    q.getQueryResultData(EventMux.EVENT_CATALOGUE).unput();
                }
                catch (ArgumentException aex) {
                    // empty catch block
                }
                if (eventcatid != null) {
                    GenericQuery.QueryData target = q.getQueryData(eventcatid);
                    GenericQuery.QueryData thisqd = q.getQueryData(data_key);
                    thisqd.setDependsOn(target.getDependsOn());
                    thisqd.setRequires(target.getRequires());
                    thisqd.setType(q.getType(eventcatid));
                    GenericQuery genericQuery = q;
                    genericQuery.getClass();
                    GenericQuery.QueryParameter eventParam = genericQuery.new GenericQuery.QueryParameter(null, EventMux.EVENT_CATALOGUE, (GenericType)q.getType(eventcatid));
                    eventParam.setUpdator(new Updator(this, eventcatid){
                        private final /* synthetic */ String val$eventcatid;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$eventcatid = val$eventcatid;
                        }

                        public boolean update(GenericQuery q, String data_key) throws ConsumerException {
                            q.set(this.val$eventcatid, q.get(data_key));
                            return true;
                        }
                    });
                    GenericQuery genericQuery2 = q;
                    genericQuery2.getClass();
                    GenericQuery.QueryResult eventResult = genericQuery2.new GenericQuery.QueryResult(EventMux.EVENT_CATALOGUE, EventMux.EVENT_CATALOGUE, (GenericType)q.getType(eventcatid));
                    eventResult.addRequires("event-type");
                    eventResult.setUpdator(new Updator(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public boolean update(GenericQuery q, String data_key) throws ConsumerException {
                            BasicCatalogue.checkRequiredParameters(q, data_key);
                            GenericData eventcat = q.getQueryData("event-type").getData();
                            Data result = q.getResult(eventcat.id());
                            String querySource = q.getQuerySource(null);
                            EGSOContext ctx = q.getContext(null);
                            q.applyUpdate(data_key, result, querySource, ctx);
                            return true;
                        }
                    });
                }
                return true;
            }
        });
    }
}

