/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.remotequery;

import java.util.Iterator;
import java.util.LinkedList;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.types.BooleanData;

public class FieldSelectorFactory
extends AbstractLogEnabled
implements EGSOLiterals {
    public static final int MODE_PRESELECTED = 1;
    public static final int MODE_MANDATORY = 3;
    public static final int MODE_AVAILABLE = 1;

    public GenericType createFieldSelectorType(String data_key, FSEntry[] fsEntries) throws ConsumerException {
        BooleanData.BooleanType mandatoryType = new BooleanData.BooleanType("mandatory");
        BooleanData.BooleanType defaultType = new BooleanData.BooleanType("default");
        GenericType fieldType = new GenericType(data_key + "-fs");
        fieldType.childrenTypes().put("mandatory", mandatoryType);
        fieldType.childrenTypes().put("default", defaultType);
        GenericType fieldListType = new GenericType("set-of-" + data_key + "-fs");
        fieldListType.setElemsType(fieldType);
        GenericData initial = (GenericData)fieldListType.newData();
        GenericData fieldValueDomain = (GenericData)fieldListType.newData();
        GenericType fieldListListType = new GenericType("set-of-set-of-" + data_key + "-fs");
        fieldListListType.setElemsType(fieldListType);
        GenericData fieldListValueDomain = (GenericData)fieldListListType.newData();
        fieldListValueDomain.add(fieldListType.newData());
        for (int i = 0; i < fsEntries.length; ++i) {
            GenericData field = (GenericData)fieldType.newData();
            field.put("mandatory", mandatoryType.newData(new Boolean((fsEntries[i].mode & 3) == 3)));
            field.put("default", defaultType.newData(new Boolean((fsEntries[i].mode & 1) == 1)));
            field.setId(fsEntries[i].fieldName);
            if ((fsEntries[i].mode & 1) == 1) {
                initial.add(field);
            }
            LinkedList<GenericData> newCobinations = new LinkedList<GenericData>();
            Iterator it = fieldListValueDomain.elements().iterator();
            while (it.hasNext()) {
                GenericData selectCombination = (GenericData)it.next();
                if ((fsEntries[i].mode & 3) == 3) {
                    selectCombination.add(field);
                    continue;
                }
                selectCombination = (GenericData)selectCombination.clone();
                selectCombination.add(field);
                newCobinations.add(selectCombination);
            }
            fieldListValueDomain.elements().addAll(newCobinations);
            fieldValueDomain.add(field);
        }
        fieldType.setValueDomain(fieldValueDomain);
        fieldListType.setNeutralData(initial);
        fieldListType.setValueDomain(fieldListValueDomain);
        fieldType.setEnum(true);
        fieldType.setDistinct(true);
        fieldListType.setEnum(true);
        fieldListType.setDistinct(true);
        fieldListListType.setDistinct(true);
        return fieldListType;
    }

    public static FieldSelectorFactory getInstance() {
        return new FieldSelectorFactory();
    }

    public static class FSEntry {
        String fieldName;
        int mode = 1;

        public FSEntry(String fieldName) {
            this.fieldName = fieldName;
        }

        public FSEntry(String fieldName, int mode) {
            this(fieldName);
            this.mode = mode;
        }
    }
}

