/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.remotequery;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.Updator;
import org.egso.consumer.plot.LazyCosecImageData;
import org.egso.consumer.remotequery.BasicCatalogue;
import org.egso.consumer.remotequery.FieldSelectorFactory;
import org.egso.consumer.remotequery.VOTableData;
import org.egso.consumer.ssr.SSR;
import org.egso.consumer.types.DoubleData;
import org.egso.consumer.types.IntegerData;
import org.egso.consumer.types.IntervalData;
import org.egso.consumer.types.egso.EGSOTypesFactory;

public class GoesXrayFlare
extends BasicCatalogue
implements Updator,
EGSOLiterals {
    public static final String FLARE_CATALOGUE = "goes_xray_flare";

    public GoesXrayFlare() throws ConsumerException {
        super(FLARE_CATALOGUE);
    }

    public void initialize(GenericQuery q) throws ConsumerException {
        if (!q.catalogues().contains("ssr")) {
            new SSR().initialize(q);
        }
        if (q.catalogues().contains(FLARE_CATALOGUE)) {
            return;
        }
        super.initialize(q);
        q.getQueryData("date").addCatalogue(FLARE_CATALOGUE);
        q.getQueryData("start-date").addCatalogue(FLARE_CATALOGUE);
        q.getQueryData("end-date").addCatalogue(FLARE_CATALOGUE);
        q.getQueryData("nar").addCatalogue(FLARE_CATALOGUE);
        q.getQueryData("location").addCatalogue(FLARE_CATALOGUE);
        q.getQueryData("longitude").addCatalogue(FLARE_CATALOGUE);
        q.getQueryData("latitude").addCatalogue(FLARE_CATALOGUE);
        q.getQueryData("event-type").addCatalogue(FLARE_CATALOGUE);
        xrayClassType = EGSOTypesFactory.getInstance().getXRayClassType();
        IntervalData.IntervalType xrayClassIntervalType = new IntervalData.IntervalType("xray_class-interval", xrayClassType);
        GenericQuery genericQuery = q;
        genericQuery.getClass();
        genericQuery.new GenericQuery.QueryParameter(FLARE_CATALOGUE, "xray_class", xrayClassIntervalType);
        IntegerData.IntegerType uniqueIdType = new IntegerData.IntegerType("unique-id");
        GenericType flareType = new GenericType(FLARE_CATALOGUE);
        flareType.childrenTypes().put("unique-id", uniqueIdType);
        flareType.childrenTypes().put("date", dateIntervalType);
        flareType.childrenTypes().put("start-date", dateType);
        flareType.childrenTypes().put("time_peak", dateType);
        flareType.childrenTypes().put("end-date", dateType);
        flareType.childrenTypes().put("nar", narType.elementsType());
        flareType.childrenTypes().put("xray_class", xrayClassType);
        flareType.childrenTypes().put("location", complexitudeType);
        flareType.childrenTypes().put("longitude", itudeType);
        flareType.childrenTypes().put("latitude", itudeType);
        flareType.childrenTypes().put("goes-plot-xray", plotType);
        flareType.childrenTypes().put("goes-plot-proton", plotType);
        flareType.setNeutralData(new GenericData(flareType){

            public String id() {
                try {
                    Data uid = this.get("unique-id");
                    if (uid != null) {
                        return uid.id();
                    }
                }
                catch (ConsumerException consumerException) {
                    // empty catch block
                }
                return super.id();
            }
        });
        VOTableData.VOTableType flareListType = new VOTableData.VOTableType("set-of-" + flareType.typeName());
        flareListType.setElemsType(flareType);
        flareListType.childrenTypes().put("goes-plot-proton", plotType);
        flareListType.childrenTypes().put("goes-plot-xray", plotType);
        flareListType.setEnum(true);
        flareListType.setValueDomain((GenericData)flareListType.newData());
        GenericQuery genericQuery2 = q;
        genericQuery2.getClass();
        GenericQuery.QueryParameter eventParam = genericQuery2.new GenericQuery.QueryParameter(FLARE_CATALOGUE, FLARE_CATALOGUE, flareListType);
        eventParam.setUpdator(new Updator(){

            public boolean update(GenericQuery q, String data_key) throws ConsumerException {
                ArrayList<String> typeSelection = new ArrayList<String>();
                typeSelection.add("event-type");
                Iterator iter = q.catalogues(typeSelection).iterator();
                while (iter.hasNext()) {
                    String catalog = (String)iter.next();
                    if (GoesXrayFlare.FLARE_CATALOGUE.equals(catalog)) continue;
                    q.makeDirty(catalog);
                    q.unset(catalog);
                }
                return true;
            }
        });
        GenericType fsType = fsFactory.createFieldSelectorType(FLARE_CATALOGUE, new FieldSelectorFactory.FSEntry[]{new FieldSelectorFactory.FSEntry("unique-id", 3), new FieldSelectorFactory.FSEntry("start-date", 3), new FieldSelectorFactory.FSEntry("time_peak", 3), new FieldSelectorFactory.FSEntry("end-date", 3), new FieldSelectorFactory.FSEntry("nar", 1), new FieldSelectorFactory.FSEntry("xray_class", 1), new FieldSelectorFactory.FSEntry("longitude", 1), new FieldSelectorFactory.FSEntry("latitude", 1)});
        GenericQuery genericQuery3 = q;
        genericQuery3.getClass();
        genericQuery3.new GenericQuery.QueryParameter(null, "goes_xray_flare-fs", fsType);
        DoubleData.DoubleType mnType = DoubleData.getDoubleType();
        GenericQuery genericQuery4 = q;
        genericQuery4.getClass();
        genericQuery4.new GenericQuery.QueryParameter(null, "event-plot-zoomout-lead", mnType);
        q.setValue("event-plot-zoomout-lead", "2");
        GenericQuery genericQuery5 = q;
        genericQuery5.getClass();
        genericQuery5.new GenericQuery.QueryParameter(null, "event-plot-zoomout-trail", mnType);
        q.setValue("event-plot-zoomout-trail", "6");
        Data eventCatFlare = eventCatType.newData();
        ((GenericData)eventCatFlare).setId(FLARE_CATALOGUE);
        eventCatType.valueDomain().add(eventCatFlare);
        q.getQueryData("event-type").addCatalogue(FLARE_CATALOGUE);
        GenericQuery genericQuery6 = q;
        genericQuery6.getClass();
        GenericQuery.QueryResult flareResult = genericQuery6.new GenericQuery.QueryResult(FLARE_CATALOGUE, FLARE_CATALOGUE, flareListType);
        flareResult.addRequires("date");
        flareResult.addDependsOn("nar");
        flareResult.addDependsOn("xray_class");
        flareResult.addDependsOn("location");
        flareResult.addDependsOn("event-type");
        flareResult.addDependsOn("goes_xray_flare-fs");
        flareResult.addRequires("event-plot-zoomout-lead");
        flareResult.addRequires("event-plot-zoomout-trail");
        flareResult.setUpdator(this);
    }

    protected Collection customCatalogueSet(GenericQuery q, Collection cats) {
        LinkedList<String> c = new LinkedList<String>();
        c.add(FLARE_CATALOGUE);
        return c;
    }

    protected String customCatalogueName(String cat_name) {
        if (cat_name.equals(FLARE_CATALOGUE)) {
            return "event";
        }
        return super.customCatalogueName(cat_name);
    }

    protected void assembleParam(PrintWriter out, GenericQuery q, Data param, String param_name, String indent) throws ConsumerException {
        if ("event-type".equals(param_name)) {
            super.assembleParam(out, q, q.getType("event-type").valueDomain().get(FLARE_CATALOGUE), param_name, indent);
        } else {
            super.assembleParam(out, q, param, param_name, indent);
        }
    }

    protected void customQueryType(GenericQuery q, String data_key, PrintWriter out) {
        data_key.equals(q);
        out.print(" type=\"query4\"");
    }

    protected VOTableData customizeReturnValue(GenericQuery q, String data_key, VOTableData vod) throws ConsumerException {
        data_key.equals(q);
        if (q.isSet("prefetch-plot-type")) {
            String plotSelect = q.get("prefetch-plot-type").id();
            vod.put(plotSelect, q.getResult(plotSelect));
        }
        Iterator it = vod.elements().iterator();
        while (it.hasNext()) {
            Data flare = (Data)it.next();
            Data date = flare.get("date");
            if (date == null) continue;
            Data startDate = date.get("start-date");
            Data endDate = date.get("end-date");
            if (startDate == null || endDate == null) continue;
            String startdateid = startDate.id();
            String enddateid = endDate.id();
            Data peakDate = flare.get("time_peak");
            Data nData = q.get("event-plot-zoomout-lead");
            Data mData = q.get("event-plot-zoomout-trail");
            if (peakDate != null && nData != null && mData != null) {
                Calendar startOld = (Calendar)startDate.getValue();
                Calendar peak = (Calendar)peakDate.getValue();
                Calendar endOld = (Calendar)endDate.getValue();
                int dYears = peak.get(1) - startOld.get(1);
                int dDays = peak.get(6) - startOld.get(6);
                int dHours = peak.get(11) - startOld.get(11);
                int dMinutes = peak.get(12) - startOld.get(12);
                int dSeconds = peak.get(13) - startOld.get(13);
                int dMillis = peak.get(14) - startOld.get(14);
                double n = (Double)nData.getValue();
                Calendar startZoom = (Calendar)startOld.clone();
                startZoom.add(1, (int)(-n * (double)dYears));
                dDays = (int)((double)dDays + (double)startOld.getMaximum(6) * (-n * (double)dYears - (double)((int)(-n * (double)dYears))));
                startZoom.add(6, (int)(-n * (double)dDays));
                dHours = (int)((double)dHours + (double)startOld.getMaximum(11) * (-n * (double)dDays - (double)((int)(-n * (double)dDays))));
                startZoom.add(11, (int)(-n * (double)dHours));
                dMinutes = (int)((double)dMinutes + (double)startOld.getMaximum(12) * (-n * (double)dHours - (double)((int)(-n * (double)dHours))));
                startZoom.add(12, (int)(-n * (double)dMinutes));
                dSeconds = (int)((double)dSeconds + (double)startOld.getMaximum(13) * (-n * (double)dMinutes - (double)((int)(-n * (double)dMinutes))));
                startZoom.add(13, (int)(-n * (double)dSeconds));
                dMillis = (int)((double)dMillis + (double)startOld.getMaximum(14) * (-n * (double)dSeconds - (double)((int)(-n * (double)dSeconds))));
                startZoom.add(14, (int)(-n * (double)dMillis));
                String newstartdateid = startDate.newData(startZoom).id();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("plot zoom moved startdate from " + startdateid + " to " + newstartdateid));
                }
                startdateid = newstartdateid;
                dYears = endOld.get(1) - peak.get(1);
                dDays = endOld.get(6) - peak.get(6);
                dHours = endOld.get(11) - peak.get(11);
                dMinutes = endOld.get(12) - peak.get(12);
                dSeconds = endOld.get(13) - peak.get(13);
                dMillis = endOld.get(14) - peak.get(14);
                double m = (Double)mData.getValue();
                Calendar endZoom = (Calendar)endOld.clone();
                endZoom.add(1, (int)(m * (double)dYears));
                dDays = (int)((double)dDays + (double)startOld.getMaximum(6) * (m * (double)dYears - (double)((int)(m * (double)dYears))));
                endZoom.add(6, (int)(m * (double)dDays));
                dHours = (int)((double)dHours + (double)startOld.getMaximum(11) * (m * (double)dDays - (double)((int)(m * (double)dDays))));
                endZoom.add(11, (int)(m * (double)dHours));
                dMinutes = (int)((double)dMinutes + (double)startOld.getMaximum(12) * (m * (double)dHours - (double)((int)(m * (double)dHours))));
                endZoom.add(12, (int)(m * (double)dMinutes));
                dSeconds = (int)((double)dSeconds + (double)startOld.getMaximum(13) * (m * (double)dMinutes - (double)((int)(m * (double)dMinutes))));
                endZoom.add(13, (int)(m * (double)dSeconds));
                dMillis = (int)((double)dMillis + (double)startOld.getMaximum(14) * (m * (double)dSeconds - (double)((int)(m * (double)dSeconds))));
                endZoom.add(14, (int)(m * (double)dMillis));
                String newenddateid = startDate.newData(endZoom).id();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("plot zoom moved enddate from " + enddateid + " to " + newenddateid));
                }
                enddateid = newenddateid;
            } else if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("could not zoom out for event '" + flare.id() + "' due to missing peak date or " + "relative offset information"));
            }
            Data xrayPlot = ((Type)flare.childrenTypes().get("goes-plot-xray")).newData();
            xrayPlot.setValue(new LazyCosecImageData.CosecCallArguments(startdateid, enddateid, 2));
            flare.put("goes-plot-xray", xrayPlot);
            Data protonPlot = ((Type)flare.childrenTypes().get("goes-plot-proton")).newData();
            protonPlot.setValue(new LazyCosecImageData.CosecCallArguments(startdateid, enddateid, 1));
            flare.put("goes-plot-proton", protonPlot);
        }
        GenericType flareListType = (GenericType)q.get(q.unResult(data_key)).type().elementsType();
        flareListType.setValueDomain(vod);
        return vod;
    }
}

