/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.remotequery;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.Updator;
import org.egso.consumer.remotequery.BasicCatalogue;
import org.egso.consumer.remotequery.FieldSelectorFactory;
import org.egso.consumer.remotequery.ObservationCatalogue;
import org.egso.consumer.remotequery.VOTableData;
import org.egso.consumer.types.IntegerData;

public class LinksCatalogue
extends BasicCatalogue
implements Updator,
EGSOLiterals {
    public static final String LINKS_CATALOGUE = "links";

    public LinksCatalogue() throws ConsumerException {
        super(LINKS_CATALOGUE);
    }

    public synchronized void initialize(GenericQuery q) throws ConsumerException {
        if (!q.catalogues().contains("observation")) {
            new ObservationCatalogue().initialize(q);
        }
        if (q.catalogues().contains(LINKS_CATALOGUE)) {
            return;
        }
        super.initialize(q);
        GenericType linkType = new GenericType("link");
        GenericType filenameType = new GenericType("filename");
        GenericType hrefType = new GenericType("link");
        GenericType idarchiveType = new GenericType("IDArchive");
        IntegerData.IntegerType filesizeType = new IntegerData.IntegerType("filesize");
        linkType.childrenTypes().put("date", dateIntervalType);
        linkType.childrenTypes().put("instrument", q.getType("instrument").elementsType());
        linkType.childrenTypes().put("observatory", q.getType("observatory").elementsType());
        linkType.childrenTypes().put("filename", filenameType);
        linkType.childrenTypes().put("filesize", filesizeType);
        linkType.childrenTypes().put("link", hrefType);
        linkType.childrenTypes().put("IDArchive", idarchiveType);
        VOTableData.VOTableType linkListType = new VOTableData.VOTableType("set-of-" + linkType.typeName());
        linkListType.setElemsType(linkType);
        linkListType.setEnum(true);
        linkListType.setValueDomain((GenericData)linkListType.newData());
        GenericQuery genericQuery = q;
        genericQuery.getClass();
        genericQuery.new GenericQuery.QueryParameter(LINKS_CATALOGUE, LINKS_CATALOGUE, linkListType);
        GenericType fsType = fsFactory.createFieldSelectorType("goes_xray_flare", new FieldSelectorFactory.FSEntry[]{new FieldSelectorFactory.FSEntry("observatory", 1), new FieldSelectorFactory.FSEntry("instrument", 1), new FieldSelectorFactory.FSEntry("IDArchive", 1), new FieldSelectorFactory.FSEntry("start-date", 1), new FieldSelectorFactory.FSEntry("end-date", 1), new FieldSelectorFactory.FSEntry("filename", 1), new FieldSelectorFactory.FSEntry("link", 3)});
        GenericQuery genericQuery2 = q;
        genericQuery2.getClass();
        genericQuery2.new GenericQuery.QueryParameter(null, "links-fs", fsType);
        q.getQueryData("observation").addCatalogue(LINKS_CATALOGUE);
        GenericQuery genericQuery3 = q;
        genericQuery3.getClass();
        GenericQuery.QueryResult linksResult = genericQuery3.new GenericQuery.QueryResult(LINKS_CATALOGUE, LINKS_CATALOGUE, linkListType);
        linksResult.addRequires("observation");
        linksResult.addDependsOn("links-fs");
        linksResult.setUpdator(this);
    }

    protected void customQueryType(GenericQuery q, String data_key, PrintWriter out) {
        "".equals(data_key);
        out.print(" type=\"query2\"");
    }

    protected Collection customCatalogueSet(GenericQuery q, Collection cats) throws ConsumerException {
        LinkedList<String> c = new LinkedList<String>();
        c.add(LINKS_CATALOGUE);
        return c;
    }

    protected void assembleParam(PrintWriter out, GenericQuery q, Data param, String param_name, String indent) throws ConsumerException {
        if (param_name.equals("observation")) {
            GenericType instrumentType = (GenericType)q.getType("instrument");
            instrumentType.setDistinct(false);
            Data instruments = q.getType("instrument").newData();
            GenericType dateIntListType = new GenericType("set-of-interval-of-date");
            dateIntListType.setDistinct(false);
            dateIntListType.setElemsType((GenericType)q.getType("date"));
            Data dates = dateIntListType.newData();
            Iterator it = q.get("observation").elements().iterator();
            while (it.hasNext()) {
                Data observation = (Data)it.next();
                instruments.add(observation.get("instrument"));
                dates.add(observation.get("date"));
            }
            super.assembleParam(out, q, instruments, "instrument", indent);
            super.assembleParam(out, q, dates, "date", indent);
            instrumentType.setDistinct(true);
        }
    }
}

