/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.remotequery;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.Updator;
import org.egso.consumer.plot.LazyCosecImageData;
import org.egso.consumer.remotequery.BasicCatalogue;
import org.egso.consumer.remotequery.FieldSelectorFactory;
import org.egso.consumer.remotequery.GoesXrayFlare;
import org.egso.consumer.remotequery.NoaaSrsArsCatalogue;
import org.egso.consumer.remotequery.VOTableData;
import org.egso.consumer.ssr.SSR;

public class NoaaProtonEventCatalogue
extends BasicCatalogue
implements Updator,
EGSOLiterals {
    public static final String PROTONEVENT_CATALOGUE = "noaa_proton_event";

    public NoaaProtonEventCatalogue() throws ConsumerException {
        super(PROTONEVENT_CATALOGUE);
    }

    public void initialize(GenericQuery q) throws ConsumerException {
        if (!q.catalogues().contains("ssr")) {
            new SSR().initialize(q);
        }
        if (!q.catalogues().contains("goes_xray_flare")) {
            new GoesXrayFlare().initialize(q);
        }
        if (!q.catalogues().contains("srs_list")) {
            new NoaaSrsArsCatalogue().initialize(q);
        }
        if (q.catalogues().contains(PROTONEVENT_CATALOGUE)) {
            return;
        }
        super.initialize(q);
        q.getQueryData("date").addCatalogue(PROTONEVENT_CATALOGUE);
        q.getQueryData("start-date").addCatalogue(PROTONEVENT_CATALOGUE);
        q.getQueryData("end-date").addCatalogue(PROTONEVENT_CATALOGUE);
        q.getQueryData("nar").addCatalogue(PROTONEVENT_CATALOGUE);
        q.getQueryData("location").addCatalogue(PROTONEVENT_CATALOGUE);
        q.getQueryData("longitude").addCatalogue(PROTONEVENT_CATALOGUE);
        q.getQueryData("latitude").addCatalogue(PROTONEVENT_CATALOGUE);
        q.getQueryData("prefetch-plot-type").addCatalogue(PROTONEVENT_CATALOGUE);
        q.getQueryData("event-type").addCatalogue(PROTONEVENT_CATALOGUE);
        GenericType protonEventType = new GenericType(PROTONEVENT_CATALOGUE);
        protonEventType.childrenTypes().put("unique-id", uniqueIdType);
        protonEventType.childrenTypes().put("date", dateIntervalType);
        protonEventType.childrenTypes().put("start-date", dateType);
        protonEventType.childrenTypes().put("time_peak", dateType);
        protonEventType.childrenTypes().put("end-date", dateType);
        protonEventType.childrenTypes().put("nar", narType.elementsType());
        protonEventType.childrenTypes().put("location", complexitudeType);
        protonEventType.childrenTypes().put("longitude", itudeType);
        protonEventType.childrenTypes().put("latitude", itudeType);
        protonEventType.childrenTypes().put("goes-plot-xray", plotType);
        protonEventType.childrenTypes().put("goes-plot-proton", plotType);
        protonEventType.setNeutralData(new GenericData(protonEventType){

            public String id() {
                try {
                    Data uid = this.get("unique-id");
                    if (uid != null) {
                        return uid.id();
                    }
                }
                catch (ConsumerException consumerException) {
                    // empty catch block
                }
                return super.id();
            }
        });
        VOTableData.VOTableType protonEventListType = new VOTableData.VOTableType("set-of-" + protonEventType.typeName());
        protonEventListType.setElemsType(protonEventType);
        protonEventListType.childrenTypes().put("goes-plot-proton", plotType);
        protonEventListType.childrenTypes().put("goes-plot-xray", plotType);
        protonEventListType.setEnum(true);
        protonEventListType.setValueDomain((GenericData)protonEventListType.newData());
        GenericQuery genericQuery = q;
        genericQuery.getClass();
        GenericQuery.QueryParameter eventParam = genericQuery.new GenericQuery.QueryParameter(PROTONEVENT_CATALOGUE, PROTONEVENT_CATALOGUE, protonEventListType);
        eventParam.setUpdator(new Updator(){

            public boolean update(GenericQuery q, String data_key) throws ConsumerException {
                ArrayList<String> typeSelection = new ArrayList<String>();
                typeSelection.add("event-type");
                Iterator iter = q.catalogues(typeSelection).iterator();
                while (iter.hasNext()) {
                    String catalog = (String)iter.next();
                    if (NoaaProtonEventCatalogue.PROTONEVENT_CATALOGUE.equals(catalog)) continue;
                    q.unset(catalog);
                }
                return true;
            }
        });
        GenericType fsType = fsFactory.createFieldSelectorType("srs_list", new FieldSelectorFactory.FSEntry[]{new FieldSelectorFactory.FSEntry("unique-id", 3), new FieldSelectorFactory.FSEntry("start-date", 3), new FieldSelectorFactory.FSEntry("time_peak", 3), new FieldSelectorFactory.FSEntry("end-date", 3), new FieldSelectorFactory.FSEntry("nar", 1), new FieldSelectorFactory.FSEntry("longitude", 1), new FieldSelectorFactory.FSEntry("latitude", 1)});
        GenericQuery genericQuery2 = q;
        genericQuery2.getClass();
        genericQuery2.new GenericQuery.QueryParameter(null, "noaa_proton_event-fs", fsType);
        Data eventCatSrs = eventCatType.newData();
        ((GenericData)eventCatSrs).setId(PROTONEVENT_CATALOGUE);
        eventCatType.valueDomain().add(eventCatSrs);
        GenericQuery genericQuery3 = q;
        genericQuery3.getClass();
        GenericQuery.QueryResult srsArResult = genericQuery3.new GenericQuery.QueryResult(PROTONEVENT_CATALOGUE, PROTONEVENT_CATALOGUE, protonEventListType);
        srsArResult.addRequires("date");
        srsArResult.addDependsOn("nar");
        srsArResult.addDependsOn("location");
        srsArResult.addDependsOn("srs_list-fs");
        srsArResult.addDependsOn("event-type");
        srsArResult.setUpdator(this);
    }

    protected Collection customCatalogueSet(GenericQuery q, Collection cats) {
        LinkedList<String> c = new LinkedList<String>();
        c.add(PROTONEVENT_CATALOGUE);
        return c;
    }

    protected String customCatalogueName(String cat_name) {
        if (cat_name.equals(PROTONEVENT_CATALOGUE)) {
            return "event";
        }
        return super.customCatalogueName(cat_name);
    }

    protected Collection customParamSetByCat(String cat, Collection params) {
        Collection x = super.customParamSetByCat(cat, params);
        if (!x.contains("event-type")) {
            x.add("event-type");
        }
        return x;
    }

    protected void assembleParam(PrintWriter out, GenericQuery q, Data param, String param_name, String indent) throws ConsumerException {
        if ("event-type".equals(param_name)) {
            super.assembleParam(out, q, q.getType("event-type").valueDomain().get(PROTONEVENT_CATALOGUE), param_name, indent);
        } else {
            super.assembleParam(out, q, param, param_name, indent);
        }
    }

    protected void customQueryType(GenericQuery q, String data_key, PrintWriter out) {
        data_key.equals(q);
        out.print(" type=\"query4\"");
    }

    protected VOTableData customizeReturnValue(GenericQuery q, String data_key, VOTableData vod) throws ConsumerException {
        data_key.equals(q);
        if (q.isSet("prefetch-plot-type")) {
            String plotSelect = q.get("prefetch-plot-type").id();
            vod.put(plotSelect, q.getResult(plotSelect));
        }
        Iterator it = vod.elements().iterator();
        while (it.hasNext()) {
            Data flare = (Data)it.next();
            Data date = flare.get("date");
            if (date == null) continue;
            Data startDate = date.get("start-date");
            Data peakDate = flare.get("time_peak");
            if (startDate == null || peakDate == null) continue;
            String startdateid = startDate.id();
            Calendar startOld = (Calendar)startDate.getValue();
            Calendar peak = (Calendar)peakDate.getValue();
            int dYears = peak.get(1) - startOld.get(1);
            int dDays = peak.get(6) - startOld.get(6);
            int dHours = peak.get(11) - startOld.get(11);
            int dMinutes = peak.get(12) - startOld.get(12);
            int dSeconds = peak.get(13) - startOld.get(13);
            int dMillis = peak.get(14) - startOld.get(14);
            double n = -2.0;
            Calendar startZoom = (Calendar)startOld.clone();
            startZoom.add(1, (int)(-n * (double)dYears));
            dDays = (int)((double)dDays + (double)startOld.getMaximum(6) * (-n * (double)dYears - (double)((int)(-n * (double)dYears))));
            startZoom.add(6, (int)(-n * (double)dDays));
            dHours = (int)((double)dHours + (double)startOld.getMaximum(11) * (-n * (double)dDays - (double)((int)(-n * (double)dDays))));
            startZoom.add(11, (int)(-n * (double)dHours));
            dMinutes = (int)((double)dMinutes + (double)startOld.getMaximum(12) * (-n * (double)dHours - (double)((int)(-n * (double)dHours))));
            startZoom.add(12, (int)(-n * (double)dMinutes));
            dSeconds = (int)((double)dSeconds + (double)startOld.getMaximum(13) * (-n * (double)dMinutes - (double)((int)(-n * (double)dMinutes))));
            startZoom.add(13, (int)(-n * (double)dSeconds));
            dMillis = (int)((double)dMillis + (double)startOld.getMaximum(14) * (-n * (double)dSeconds - (double)((int)(-n * (double)dSeconds))));
            startZoom.add(14, (int)(-n * (double)dMillis));
            String newendtimeid = startDate.newData(startZoom).id();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("plot end time for proton event assumed to be " + newendtimeid));
            }
            Data xrayPlot = ((Type)flare.childrenTypes().get("goes-plot-xray")).newData();
            xrayPlot.setValue(new LazyCosecImageData.CosecCallArguments(startdateid, newendtimeid, 2));
            flare.put("goes-plot-xray", xrayPlot);
            Data protonPlot = ((Type)flare.childrenTypes().get("goes-plot-proton")).newData();
            protonPlot.setValue(new LazyCosecImageData.CosecCallArguments(startdateid, newendtimeid, 1));
            flare.put("goes-plot-proton", protonPlot);
        }
        GenericType protonEventListType = (GenericType)q.get(q.unResult(data_key)).type().elementsType();
        protonEventListType.setValueDomain(vod);
        return vod;
    }
}

