/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.remotequery;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.Updator;
import org.egso.consumer.plot.LazyCosecImageData;
import org.egso.consumer.remotequery.BasicCatalogue;
import org.egso.consumer.remotequery.FieldSelectorFactory;
import org.egso.consumer.remotequery.GoesXrayFlare;
import org.egso.consumer.remotequery.VOTableData;
import org.egso.consumer.ssr.SSR;
import org.egso.consumer.types.IntegerData;

public class NoaaSrsArsCatalogue
extends BasicCatalogue
implements Updator,
EGSOLiterals {
    public static final String SRSARS_CATALOGUE = "srs_list";

    public NoaaSrsArsCatalogue() throws ConsumerException {
        super(SRSARS_CATALOGUE);
    }

    public void initialize(GenericQuery q) throws ConsumerException {
        if (!q.catalogues().contains("ssr")) {
            new SSR().initialize(q);
        }
        if (!q.catalogues().contains("goes_xray_flare")) {
            new GoesXrayFlare().initialize(q);
        }
        if (q.catalogues().contains(SRSARS_CATALOGUE)) {
            return;
        }
        super.initialize(q);
        q.getQueryData("date").addCatalogue(SRSARS_CATALOGUE);
        q.getQueryData("start-date").addCatalogue(SRSARS_CATALOGUE);
        q.getQueryData("nar").addCatalogue(SRSARS_CATALOGUE);
        q.getQueryData("location").addCatalogue(SRSARS_CATALOGUE);
        q.getQueryData("longitude").addCatalogue(SRSARS_CATALOGUE);
        q.getQueryData("latitude").addCatalogue(SRSARS_CATALOGUE);
        q.getQueryData("prefetch-plot-type").addCatalogue(SRSARS_CATALOGUE);
        q.getQueryData("event-type").addCatalogue(SRSARS_CATALOGUE);
        GenericType protonEventType = new GenericType(SRSARS_CATALOGUE);
        protonEventType.childrenTypes().put("unique-id", uniqueIdType);
        protonEventType.childrenTypes().put("date", dateIntervalType);
        protonEventType.childrenTypes().put("start-date", dateType);
        protonEventType.childrenTypes().put("nar", narType.elementsType());
        protonEventType.childrenTypes().put("location", complexitudeType);
        protonEventType.childrenTypes().put("longitude", itudeType);
        protonEventType.childrenTypes().put("latitude", itudeType);
        protonEventType.childrenTypes().put("goes-plot-xray", plotType);
        protonEventType.childrenTypes().put("goes-plot-proton", plotType);
        protonEventType.setNeutralData(new GenericData(protonEventType){

            public String id() {
                try {
                    Data uid = this.get("unique-id");
                    if (uid != null) {
                        return uid.id();
                    }
                }
                catch (ConsumerException consumerException) {
                    // empty catch block
                }
                return super.id();
            }
        });
        VOTableData.VOTableType protonEventListType = new VOTableData.VOTableType("set-of-" + protonEventType.typeName());
        protonEventListType.setElemsType(protonEventType);
        protonEventListType.childrenTypes().put("goes-plot-proton", plotType);
        protonEventListType.childrenTypes().put("goes-plot-xray", plotType);
        protonEventListType.setEnum(true);
        protonEventListType.setValueDomain((GenericData)protonEventListType.newData());
        GenericQuery genericQuery = q;
        genericQuery.getClass();
        GenericQuery.QueryParameter eventParam = genericQuery.new GenericQuery.QueryParameter(SRSARS_CATALOGUE, SRSARS_CATALOGUE, protonEventListType);
        eventParam.setUpdator(new Updator(){

            public boolean update(GenericQuery q, String data_key) throws ConsumerException {
                ArrayList<String> typeSelection = new ArrayList<String>();
                typeSelection.add("event-type");
                Iterator iter = q.catalogues(typeSelection).iterator();
                while (iter.hasNext()) {
                    String catalog = (String)iter.next();
                    if (NoaaSrsArsCatalogue.SRSARS_CATALOGUE.equals(catalog)) continue;
                    q.unset(catalog);
                }
                return true;
            }
        });
        GenericType fsType = fsFactory.createFieldSelectorType(SRSARS_CATALOGUE, new FieldSelectorFactory.FSEntry[]{new FieldSelectorFactory.FSEntry("unique-id", 3), new FieldSelectorFactory.FSEntry("start-date", 3), new FieldSelectorFactory.FSEntry("nar", 1), new FieldSelectorFactory.FSEntry("longitude", 1), new FieldSelectorFactory.FSEntry("latitude", 1)});
        IntegerData.IntegerType secondsType = IntegerData.getIntegerType();
        GenericQuery genericQuery2 = q;
        genericQuery2.getClass();
        genericQuery2.new GenericQuery.QueryParameter(null, "event-plot-srs_list-length", secondsType);
        q.setValue("event-plot-srs_list-length", "20000");
        GenericQuery genericQuery3 = q;
        genericQuery3.getClass();
        genericQuery3.new GenericQuery.QueryParameter(null, "srs_list-fs", fsType);
        Data eventCatSrs = eventCatType.newData();
        ((GenericData)eventCatSrs).setId(SRSARS_CATALOGUE);
        eventCatType.valueDomain().add(eventCatSrs);
        GenericQuery genericQuery4 = q;
        genericQuery4.getClass();
        GenericQuery.QueryResult srsArResult = genericQuery4.new GenericQuery.QueryResult(SRSARS_CATALOGUE, SRSARS_CATALOGUE, protonEventListType);
        srsArResult.addRequires("date");
        srsArResult.addDependsOn("nar");
        srsArResult.addDependsOn("location");
        srsArResult.addDependsOn("srs_list-fs");
        srsArResult.addDependsOn("event-type");
        srsArResult.addDependsOn("event-plot-srs_list-length");
        srsArResult.setUpdator(this);
    }

    protected Collection customCatalogueSet(GenericQuery q, Collection cats) {
        LinkedList<String> c = new LinkedList<String>();
        c.add(SRSARS_CATALOGUE);
        return c;
    }

    protected String customCatalogueName(String cat_name) {
        if (cat_name.equals(SRSARS_CATALOGUE)) {
            return "event";
        }
        return super.customCatalogueName(cat_name);
    }

    protected Collection customParamSetByCat(String cat, Collection params) {
        Collection x = super.customParamSetByCat(cat, params);
        if (!x.contains("event-type")) {
            x.add("event-type");
        }
        return x;
    }

    protected void assembleParam(PrintWriter out, GenericQuery q, Data param, String param_name, String indent) throws ConsumerException {
        if ("event-type".equals(param_name)) {
            super.assembleParam(out, q, q.getType("event-type").valueDomain().get(SRSARS_CATALOGUE), param_name, indent);
        } else {
            super.assembleParam(out, q, param, param_name, indent);
        }
    }

    protected void customQueryType(GenericQuery q, String data_key, PrintWriter out) {
        data_key.equals(q);
        out.print(" type=\"query4\"");
    }

    protected VOTableData customizeReturnValue(GenericQuery q, String data_key, VOTableData vod) throws ConsumerException {
        data_key.equals(q);
        if (q.isSet("prefetch-plot-type")) {
            String plotSelect = q.get("prefetch-plot-type").id();
            vod.put(plotSelect, q.getResult(plotSelect));
        }
        int nSecs = 20000;
        int nHours = 0;
        int nDays = 0;
        try {
            Data nData = q.get("event-plot-srs_list-length");
            nSecs = (Integer)nData.getValue();
        }
        catch (Exception ex) {
            // empty catch block
        }
        nHours = nSecs / 3600;
        nSecs -= nSecs % 3600;
        nDays = nHours / 24;
        nHours -= nHours % 24;
        Iterator it = vod.elements().iterator();
        while (it.hasNext()) {
            String startdateid;
            Data flare = (Data)it.next();
            Data startDate = flare.get("start-date");
            String enddateid = startdateid = startDate.id();
            Calendar startOld = (Calendar)startDate.getValue();
            startOld.add(13, nSecs);
            startOld.add(11, nHours);
            startOld.add(6, nDays);
            String newendtimeid = startDate.newData(startOld).id();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("plot end time for srs_list event plot assumed to be " + newendtimeid));
            }
            enddateid = newendtimeid;
            Data xrayPlot = ((Type)flare.childrenTypes().get("goes-plot-xray")).newData();
            xrayPlot.setValue(new LazyCosecImageData.CosecCallArguments(startdateid, enddateid, 2));
            flare.put("goes-plot-xray", xrayPlot);
            Data protonPlot = ((Type)flare.childrenTypes().get("goes-plot-proton")).newData();
            protonPlot.setValue(new LazyCosecImageData.CosecCallArguments(startdateid, enddateid, 1));
            flare.put("goes-plot-proton", protonPlot);
        }
        GenericType srsArListType = (GenericType)q.get(q.unResult(data_key)).type().elementsType();
        srsArListType.setValueDomain(vod);
        return vod;
    }
}

