/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.remotequery;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Interval;
import org.egso.consumer.api.ScalarData;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.Updator;
import org.egso.consumer.remotequery.BasicCatalogue;
import org.egso.consumer.remotequery.FieldSelectorFactory;
import org.egso.consumer.remotequery.GoesXrayFlare;
import org.egso.consumer.remotequery.VOTableData;
import org.egso.consumer.ssr.SSR;
import org.egso.consumer.types.IntervalData;

public class ObservationCatalogue
extends BasicCatalogue
implements Updator {
    public static final String OBSERVATION_CATALOGUE = "observation";
    private Collection queriesInProcess = Collections.synchronizedCollection(new LinkedList());

    public ObservationCatalogue() throws ConsumerException {
        super(OBSERVATION_CATALOGUE);
    }

    public synchronized void initialize(GenericQuery q) throws ConsumerException {
        if (!q.catalogues().contains("ssr")) {
            new SSR().initialize(q);
        }
        if (!q.catalogues().contains("goes_xray_flare")) {
            new GoesXrayFlare().initialize(q);
        }
        if (q.catalogues().contains(OBSERVATION_CATALOGUE)) {
            return;
        }
        super.initialize(q);
        GenericType obsType = new GenericType(OBSERVATION_CATALOGUE);
        obsType.childrenTypes().put("date", dateIntervalType);
        obsType.childrenTypes().put("end-date", dateType);
        obsType.childrenTypes().put("instrument", q.getType("instrument").elementsType());
        obsType.childrenTypes().put("observatory", q.getType("observatory").elementsType());
        obsType.childrenTypes().put("observingdomain", new GenericType("observingdomain"));
        obsType.childrenTypes().put("start-date", dateType);
        VOTableData.VOTableType obsListType = new VOTableData.VOTableType("set-of-observation");
        obsListType.setElemsType(obsType);
        GenericQuery genericQuery = q;
        genericQuery.getClass();
        genericQuery.new GenericQuery.QueryParameter(OBSERVATION_CATALOGUE, OBSERVATION_CATALOGUE, obsListType);
        q.getQueryData("date").addCatalogue(OBSERVATION_CATALOGUE);
        q.getQueryData("observable-entity").addCatalogue(OBSERVATION_CATALOGUE);
        GenericType fsType = fsFactory.createFieldSelectorType("goes_xray_flare", new FieldSelectorFactory.FSEntry[]{new FieldSelectorFactory.FSEntry("observatory", 1), new FieldSelectorFactory.FSEntry("instrument", 1), new FieldSelectorFactory.FSEntry("start-date", 3), new FieldSelectorFactory.FSEntry("end-date", 3), new FieldSelectorFactory.FSEntry("observingdomain", 1)});
        GenericQuery genericQuery2 = q;
        genericQuery2.getClass();
        genericQuery2.new GenericQuery.QueryParameter(null, "observation-fs", fsType);
        GenericQuery genericQuery3 = q;
        genericQuery3.getClass();
        GenericQuery.QueryResult obsResult = genericQuery3.new GenericQuery.QueryResult(OBSERVATION_CATALOGUE, OBSERVATION_CATALOGUE, obsListType);
        obsResult.addDependsOn("event-type");
        obsResult.addRequires("date");
        obsResult.addDependsOn("goes_xray_flare");
        obsResult.addDependsOn("noaa_proton_event");
        obsResult.addDependsOn("srs_list");
        obsResult.addDependsOn("instrument");
        obsResult.addDependsOn("observable-entity");
        obsResult.setUpdator(this);
    }

    protected void customQueryType(GenericQuery q, String data_key, PrintWriter out) throws ArgumentException, ConsumerException {
        if (this.queriesInProcess.contains(q)) {
            out.print(" type=\"queryx\"");
            return;
        }
        this.queriesInProcess.add(q);
        String query = this.assembleQuery(q, data_key);
        if (query.indexOf("unique-id") > 0) {
            out.print(" type=\"query5\"");
        } else if (query.indexOf("<data type=\"event\"") > 0) {
            out.print(" type=\"query1\"");
        } else {
            out.print(" type=\"query3\"");
        }
        this.queriesInProcess.remove(q);
    }

    protected Collection customCatalogueSet(GenericQuery q, Collection cats) throws ConsumerException {
        if (!(q.isSet("goes_xray_flare") || q.isSet("event-type") && !q.get("event-type").id().equals("goes_xray_flare"))) {
            cats.remove("goes_xray_flare");
        }
        if (!(q.isSet("noaa_proton_event") || q.isSet("event-type") && !q.get("event-type").id().equals("noaa_proton_event"))) {
            cats.remove("noaa_proton_event");
        }
        if (!(q.isSet("srs_list") || q.isSet("event-type") && !q.get("event-type").id().equals("srs_list"))) {
            cats.remove("srs_list");
        }
        boolean withFlares = false;
        if (q.isSet("goes_xray_flare")) {
            withFlares = true;
        } else if (q.isSet("event-type") && q.get("event-type").id().equals("goes_xray_flare")) {
            withFlares = true;
        }
        boolean withProtonEvents = false;
        if (q.isSet("noaa_proton_event")) {
            withProtonEvents = true;
        } else if (q.isSet("event-type") && q.get("event-type").id().equals("noaa_proton_event")) {
            withProtonEvents = true;
        }
        boolean withSrsList = false;
        if (q.isSet("srs_list")) {
            withSrsList = true;
        } else if (q.isSet("event-type") && q.get("event-type").id().equals("srs_list")) {
            withSrsList = true;
        }
        Iterator it = cats.iterator();
        while (it.hasNext()) {
            String cat = (String)it.next();
            if (cat.equals(OBSERVATION_CATALOGUE) || withFlares && cat.equals("goes_xray_flare") || withProtonEvents && cat.equals("noaa_proton_event") || withSrsList && cat.equals("srs_list")) continue;
            it.remove();
        }
        return cats;
    }

    protected String customCatalogueName(String cat_name) {
        if (cat_name.equals("goes_xray_flare")) {
            return "event";
        }
        if (cat_name.equals("noaa_proton_event")) {
            return "event";
        }
        if (cat_name.equals("srs_list")) {
            return "event";
        }
        return super.customCatalogueName(cat_name);
    }

    protected void customParamName(Data param, String param_name, PrintWriter out) {
        if ("goes_xray_flare".equals(param_name)) {
            out.print("unique-id");
        } else if ("noaa_proton_event".equals(param_name)) {
            out.print("unique-id");
        } else if ("srs_list".equals(param_name)) {
            out.print("unique-id");
        } else {
            super.customParamName(param, param_name, out);
        }
    }

    protected void assembleParam(PrintWriter out, GenericQuery q, Data param, String param_name, String indent) throws ConsumerException {
        if (!param_name.equals("observable-entity")) {
            super.assembleParam(out, q, param, param_name, indent);
            return;
        }
        if (indent == null) {
            indent = "";
        }
        out.print(indent);
        out.print("<param name=\"wavelength\" relation=\"OR\">");
        out.println();
        Iterator it = param.elements().iterator();
        while (it.hasNext()) {
            Data element = (Data)it.next();
            if (element instanceof Interval) {
                IntervalData interval = (IntervalData)element;
                ScalarData min = interval.getMin();
                ScalarData max = interval.getMax();
                if (min == null && max == null) continue;
                out.print(indent);
                out.println("  <interval>");
                if (min != null) {
                    out.print(indent);
                    out.println("    <start>" + min.id() + "</start>");
                }
                if (max != null) {
                    out.print(indent);
                    out.println("    <end>" + max.id() + "</end>");
                }
                out.print(indent);
                out.println("  </interval>");
                continue;
            }
            out.print(indent);
            out.print("  <value>");
            out.print(element.id());
            out.print("</value>");
            out.println();
        }
        out.print(indent);
        out.println("</param>");
    }
}

