/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.remotequery;

import java.util.LinkedList;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.ParameterRequiredException;
import org.egso.consumer.api.ScalarData;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.Updator;
import org.egso.consumer.plot.LazyCosecImageData;
import org.egso.consumer.remotequery.BasicCatalogue;
import org.egso.consumer.types.IntervalData;

public class PlotCatalogue
extends BasicCatalogue
implements Updator {
    public static final String PLOT_CATALOGUE = "cosec";

    public PlotCatalogue() throws ConsumerException {
        super(PLOT_CATALOGUE);
    }

    public void initialize(GenericQuery q) throws ConsumerException {
        super.initialize(q);
        GenericQuery genericQuery = q;
        genericQuery.getClass();
        GenericQuery.QueryResult plotXrayResult = genericQuery.new GenericQuery.QueryResult(PLOT_CATALOGUE, "goes-plot-xray", plotType);
        plotXrayResult.addRequires("date");
        plotXrayResult.setUpdator(this);
        GenericQuery genericQuery2 = q;
        genericQuery2.getClass();
        GenericQuery.QueryResult plotProtonResult = genericQuery2.new GenericQuery.QueryResult(PLOT_CATALOGUE, "goes-plot-proton", plotType);
        plotProtonResult.addRequires("date");
        plotProtonResult.setUpdator(this);
    }

    public boolean update(GenericQuery q, String data_key) throws ConsumerException {
        int plotType = 2;
        if (data_key.startsWith("goes-plot-proton")) {
            plotType = 1;
        }
        if (data_key.startsWith("goes-plot-xray")) {
            plotType = 2;
        }
        IntervalData date = (IntervalData)q.getQueryData("date").getData();
        ScalarData min = date.getMin();
        ScalarData max = date.getMax();
        if (min == null || max == null) {
            LinkedList<String> missingParams = new LinkedList<String>();
            missingParams.add("date");
            throw new ParameterRequiredException(data_key, missingParams, "NOTE: the '" + data_key + "' result requires a closed interval " + "of dates in the '" + "date" + "' parameter" + (min == null ? "; lower bounds of intervall missing" : "") + (max == null ? "; upper bounds of intervall missing" : ""));
        }
        String startDate = min.id();
        String endDate = max.id();
        Data plot = q.getType(data_key).newData(new LazyCosecImageData.CosecCallArguments(startDate, endDate, plotType));
        q.applyUpdate(data_key, plot, null, null);
        return true;
    }
}

