/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.remotequery;

import java.io.Reader;
import java.io.StringReader;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.ImmutableException;
import org.egso.consumer.api.Type;
import org.egso.consumer.api.VOTableReader;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.remotequery.VOTableDataHandler;
import org.egso.consumer.types.StringData;

public class VOTableData
extends GenericData
implements Data,
VOTableReader {
    private String votable = null;

    public VOTableData(VOTableType type, String VOTable) throws ConsumerException {
        super(type);
        this.setValue(VOTable);
    }

    public void setValue(Object value) throws ConsumerException {
        if (this.votable != null) {
            throw new ArgumentException("this VO table is readonly and has been initialized already.");
        }
        if (value == null) {
            throw new ArgumentException("illegal argument to initialize vo table: " + value);
        }
        if (!(value instanceof String)) {
            throw new ArgumentException("conversion from " + value.getClass() + " to String not supported yet.");
        }
        this.votable = (String)value;
        if (this.votable == null) {
            throw new ArgumentException("VOTableData must be initialized with valid vo table source but got: " + this.votable);
        }
        VOTableDataHandler.parse(this.votable, new VOTableDataHandler(this));
    }

    public String toString() {
        return "VOTableData(" + super.toString() + " votable='" + this.votable + "')";
    }

    public Reader readVOTable() {
        return new StringReader(this.votable);
    }

    protected final boolean equalsNr(GenericData otherData) {
        if (!(otherData instanceof VOTableData)) {
            return false;
        }
        return this.equalsNr((VOTableData)otherData);
    }

    protected boolean equalsNr(VOTableData votData) {
        if (this.votable == null || votData.votable == null) {
            return this.votable == votData.votable;
        }
        return this.votable.equals(votData.votable);
    }

    public static class VOTableType
    extends GenericType
    implements Type {
        public static final String DESCRIPTION = "description";

        public VOTableType(String typeName) throws ArgumentException {
            super(typeName);
            this.childrenTypes().put(DESCRIPTION, StringData.getStringType());
            try {
                this.setDistinct(false);
            }
            catch (ImmutableException ex) {
                this.getLogger().warn((Object)("UNEXPECTED: " + ex.getMessage()), (Throwable)((Object)ex));
            }
        }

        public VOTableType() throws ArgumentException {
            this("votable");
        }

        public synchronized String toString() {
            return "VOTableDataVOTableType(" + super.toString() + ")";
        }
    }
}

