/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.session;

import java.util.HashMap;
import java.util.Map;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.async.Session;
import org.egso.consumer.session.EGSOSession;
import org.egso.consumer.valid.SessionnameValidator;
import org.egso.consumer.valid.UsernameValidator;

public class EGSOSessionFactory {
    public static final String USERNAME = "username";
    public static final String SESSIONNAME = "sessionname";
    public static final String ANONYMOUS = "(anonymous)";
    public static final String DEFAULTSESSION = "(default)";
    static Map sessionStore = new HashMap();
    static final EGSOSessionFactory instance = new EGSOSessionFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session login2(Map sessionAtts) throws ArgumentException {
        Session theSession;
        if (sessionAtts.get(USERNAME) == null) {
            sessionAtts.put(USERNAME, ANONYMOUS);
        }
        if (sessionAtts.get(SESSIONNAME) == null) {
            sessionAtts.put(SESSIONNAME, DEFAULTSESSION);
        }
        if (!ANONYMOUS.equals(sessionAtts.get(USERNAME))) {
            UsernameValidator.validateUserName((String)sessionAtts.get(USERNAME));
        }
        if (!DEFAULTSESSION.equals(sessionAtts.get(SESSIONNAME))) {
            SessionnameValidator.validateSessionName((String)sessionAtts.get(SESSIONNAME));
        }
        String sessionRef = "/username=" + sessionAtts.get(USERNAME) + "/" + SESSIONNAME + "=" + sessionAtts.get(SESSIONNAME);
        Map map = sessionStore;
        synchronized (map) {
            theSession = (Session)sessionStore.get(sessionRef);
            if (theSession == null) {
                theSession = this.createSession(sessionRef);
                sessionStore.put(sessionRef, theSession);
            }
        }
        return theSession;
    }

    private Session createSession(String sessionid) {
        return new EGSOSession(sessionid);
    }

    public Session login(Object ignored) {
        try {
            if (ignored instanceof String[][]) {
                return this.login2((String[][])null);
            }
            if (ignored instanceof Map) {
                return this.login2((Map)null);
            }
        }
        catch (ArgumentException ex) {
            return null;
        }
        HashMap<String, String> argmap = new HashMap<String, String>();
        argmap.put(USERNAME, ANONYMOUS);
        argmap.put(SESSIONNAME, DEFAULTSESSION);
        try {
            return this.login2(argmap);
        }
        catch (ArgumentException ex) {
            return null;
        }
    }

    public Session login2(String[][] argarray) throws ArgumentException {
        if (argarray == null) {
            return this.login(null);
        }
        HashMap<String, String> argmap = new HashMap<String, String>();
        for (int i = 0; i < argarray.length; ++i) {
            argmap.put(argarray[0][i], argarray[1][i]);
        }
        return this.login2(argmap);
    }

    public static EGSOSessionFactory getInstance() {
        return instance;
    }
}

