/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.ssr;

import java.beans.XMLDecoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.configuration.Configuration;
import org.egso.common.configuration.NamedConfigurationFactory;
import org.egso.consumer.ConfigurationLiterals;
import org.egso.consumer.Consumer;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.Interval;
import org.egso.consumer.api.ScalarType;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericQuery;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.Updator;
import org.egso.consumer.remotequery.BasicCatalogue;
import org.egso.consumer.ssr.SSRHandler;
import org.egso.consumer.types.DoubleData;
import org.egso.consumer.types.IntervalData;

public class SSR
extends BasicCatalogue
implements Updator,
EGSOLiterals,
ConfigurationLiterals {
    public static final String SSR_CATALOGUE = "ssr";
    private Data instruments;
    private Data insitu_obsent;
    private Data insitu_obstype;
    private Data remote_obsent;
    private Data remote_obstype;

    public SSR() throws ConsumerException {
        super(SSR_CATALOGUE);
    }

    public void initialize(GenericQuery q) throws ConsumerException {
        SortedMap wlMap;
        if (q.catalogues().contains(SSR_CATALOGUE)) {
            return;
        }
        Map<String, IntervalData.IntervalType> ssrTypes = new HashMap();
        try {
            InputStream ssrIn = this.loadFileRelativeToConfiguration("consumer.ssr.resource", "data/ssr.xml");
            SSRHandler worker = new SSRHandler();
            SSRHandler.parse(ssrIn, worker);
            this.instruments = worker.getSSRInstruments();
            ssrTypes = worker.getSSRTypes();
        }
        catch (IOException ex) {
            throw new ConsumerException("SSR::initialize: IOException while parsing: " + ex.getMessage(), ex);
        }
        try {
            XMLDecoder d = new XMLDecoder(this.loadFileRelativeToConfiguration("consumer.ssr.oemapping", "data/wavelengthMap.xml"));
            wlMap = (SortedMap)d.readObject();
            d.close();
        }
        catch (IOException ex) {
            throw new ConsumerException(ex);
        }
        GenericType oldOeType = (GenericType)ssrTypes.get("observable-entity");
        IntervalData.IntervalType newOeType = new IntervalData.IntervalType("observable-entity", DoubleData.getDoubleType(), new IntervalData.IntervalType.DefaultKeys(){

            public String MIN() {
                return "start-wavelength";
            }

            public String MAX() {
                return "end-wavelength";
            }
        });
        if (oldOeType == null) {
            this.getLogger().error((Object)"type 'observable-entity' not found. cannot apply mapping to wavelengths");
        } else {
            GenericType newOeSetType = new GenericType("set-of-observable-entity");
            newOeSetType.setElemsType(newOeType);
            GenericData newOeVD = (GenericData)newOeSetType.newData();
            newOeType.setValueDomain(newOeVD);
            Iterator it = wlMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                Double[] boundary = (Double[])entry.getValue();
                if (boundary == null || boundary.length != 2) {
                    this.getLogger().error((Object)("the mapping target of a value domain needs exactly 2 values, but found " + (boundary == null ? "null" : "" + boundary.length)));
                    this.getLogger().error((Object)"the mapping of observable-entity to a wavelength interval will not work. continuing...");
                }
                IntervalData oeData = (IntervalData)newOeType.newData();
                oeData.setId(key);
                oeData.setMin(boundary[0]);
                oeData.setMax(boundary[1]);
                newOeType.valueDomain().add(oeData);
            }
            it = oldOeType.valueDomain().elements().iterator();
            while (it.hasNext()) {
                GenericData oldOeData = (GenericData)((Object)it.next());
                String id = oldOeData.id();
                if (newOeType.valueDomain().get(id) != null) continue;
                IntervalData newOeData = (IntervalData)newOeType.newData();
                newOeData.setId(id);
                newOeType.valueDomain().add(newOeData);
                this.getLogger().warn((Object)("no mapping found for observable-entity '" + id + "'. wavelength interval remains " + "uninitialized at null..null"));
            }
            newOeType.setEnum(true);
            ssrTypes.put("observable-entity", newOeType);
            ((GenericType)ssrTypes.get("instrument")).childrenTypes().put("observable-entity", newOeType);
            it = this.instruments.elements().iterator();
            while (it.hasNext()) {
                Data instrument = (Data)((Object)it.next());
                if (instrument.get("observable-entity") == null) continue;
                instrument.put("observable-entity", newOeType.valueDomain().get(instrument.get("observable-entity").id()));
            }
        }
        Iterator tit = ssrTypes.entrySet().iterator();
        while (tit.hasNext()) {
            Map.Entry entry = tit.next();
            String data_key = (String)entry.getKey();
            GenericType type = (GenericType)entry.getValue();
            if (type instanceof ScalarType) {
                try {
                    type = new IntervalData.IntervalType(type);
                }
                catch (ArgumentException ex) {
                    this.getLogger().error((Object)"this should not happen here.", (Throwable)((Object)ex));
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("add ssr field '" + type.typeName() + "' (which is of scalar type) as query parameter '" + data_key + "' (as an interval type)."));
                }
            } else if (type.isEnum()) {
                GenericType setType = new GenericType("set-of-" + type.typeName());
                setType.setElemsType(type);
                type = setType;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("add ssr field '" + type.typeName() + "' (which is of discrete/enum type) as query parameter '" + data_key + "' (as a set-of-values type)."));
                }
            } else if (!type.isList() && type.valueDomain() == null) {
                GenericType listType = new GenericType("set-of-" + type.typeName());
                listType.setElemsType(type);
                type = listType;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("add ssr field '" + type.typeName() + "' as query parameter '" + data_key + "' (which is of" + "type set-of-... any value)."));
                }
            } else if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("add ssr field '" + type.typeName() + "' as query parameter '" + data_key + "' (as far as " + "known here of type set-of-set-of-... or interval)."));
            }
            GenericQuery genericQuery = q;
            genericQuery.getClass();
            genericQuery.new GenericQuery.QueryParameter(SSR_CATALOGUE, data_key, type);
            GenericQuery genericQuery2 = q;
            genericQuery2.getClass();
            GenericQuery.QueryResult qResult = genericQuery2.new GenericQuery.QueryResult(SSR_CATALOGUE, data_key, type);
            qResult.setDependsOn(ssrTypes.keySet());
            qResult.setUpdator(this);
        }
        this.insitu_obsent = q.getType("observable-entity").newData();
        this.insitu_obsent.add("oe_magnetic");
        this.insitu_obsent.add("oe_charged");
        this.insitu_obsent.add("oe_neutral");
        this.insitu_obsent.add("oe_electrical");
        this.insitu_obsent.add("oe_gravitational");
        this.insitu_obsent.add("oe_energetic");
        this.insitu_obstype = q.getType("observing-type").newData();
        this.insitu_obstype.add("ot_irradiance");
        this.insitu_obstype.add("ot_polarimeter");
        this.insitu_obstype.add("ot_magnetometer");
        this.insitu_obstype.add("ot_vector_magnetograph");
        this.insitu_obstype.add("ot_oscillations");
        this.insitu_obstype.add("ot_magnetograph");
        this.remote_obsent = q.getType("observable-entity").newData();
        this.remote_obsent.add("oe_sxr");
        this.remote_obsent.add("oe_hxr");
        this.remote_obsent.add("oe_visible");
        this.remote_obsent.add("oe_gamma_rays");
        this.remote_obsent.add("oe_uv");
        this.remote_obsent.add("oe_euv");
        this.remote_obsent.add("oe_radiowaves");
        this.remote_obstype = q.getType("observing-type").newData();
        this.remote_obstype.add("ot_spectrometer");
        this.remote_obstype.add("ot_imager");
        this.remote_obstype.add("ot_coronagraph");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("ssr: mt-where-applicable: insitu_obsent = " + this.insitu_obsent));
            ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
            PrintStream ps1 = new PrintStream(new ByteArrayOutputStream());
            this.insitu_obsent.prettyPrint(ps1);
            ps1.close();
            this.getLogger().debug((Object)baos1.toString());
            this.getLogger().debug((Object)("ssr: mt-where-applicable: insitu_obstype = " + this.insitu_obstype));
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            PrintStream ps2 = new PrintStream(new ByteArrayOutputStream());
            this.insitu_obstype.prettyPrint(ps2);
            ps2.close();
            this.getLogger().debug((Object)baos2.toString());
            this.getLogger().debug((Object)("ssr: mt-where-applicable: remote_obsent = " + this.remote_obsent));
            ByteArrayOutputStream baos3 = new ByteArrayOutputStream();
            PrintStream ps3 = new PrintStream(new ByteArrayOutputStream());
            this.remote_obsent.prettyPrint(ps3);
            ps3.close();
            this.getLogger().debug((Object)baos3.toString());
            this.getLogger().debug((Object)("ssr: mt-where-applicable: remote_obstype = " + this.remote_obstype));
            ByteArrayOutputStream baos4 = new ByteArrayOutputStream();
            PrintStream ps4 = new PrintStream(new ByteArrayOutputStream());
            this.remote_obstype.prettyPrint(ps4);
            ps4.close();
            this.getLogger().debug((Object)baos4.toString());
        }
    }

    public boolean update(GenericQuery q, String data___key) throws ConsumerException {
        Data result = q.getType(data___key).newData();
        try {
            Iterator rit = this.instruments.elements().iterator();
            while (rit.hasNext()) {
                Data instrument = (Data)rit.next();
                boolean select = true;
                Iterator pit = q.affectedBy(data___key).iterator();
                while (pit.hasNext()) {
                    Data filter;
                    String data_key = (String)pit.next();
                    if (!q.isSet(data_key) || data___key.indexOf(data_key) > -1 && !q.getType(data_key).isList() || this.match(instrument, filter = (Data)q.get(data_key).clone())) continue;
                    select = false;
                    break;
                }
                if (!select) continue;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("found ssr entry: " + instrument));
                }
                if (instrument.typeName().equals(q.unResult(data___key))) {
                    result.add(instrument);
                    continue;
                }
                Data value = instrument.get(q.unResult(data___key));
                if (value == null) continue;
                if (value.isList() && !result.elementsType().isList()) {
                    Iterator it = value.elements().iterator();
                    while (it.hasNext()) {
                        Data element = (Data)it.next();
                        if (result.contains(element)) continue;
                        result.add(element);
                    }
                    continue;
                }
                if (result.contains(value)) continue;
                result.add(value);
            }
            q.applyUpdate(data___key, result);
            return true;
        }
        catch (ArgumentException ex) {
            this.getLogger().error((Object)"error in SSR: subsequent results may be wrong!", (Throwable)((Object)ex));
            throw ex;
        }
    }

    private boolean match(Data candidate, Data select) throws ArgumentException {
        if (select instanceof Interval) {
            if (candidate instanceof Interval ? ((Object)candidate.type()).equals(select.type()) && ((Interval)((Object)select)).overlaps((Interval)((Object)candidate)) : ((Object)select.type()).equals(candidate.type()) && select.contains(candidate)) {
                return true;
            }
        } else if (candidate.isList() && select.isList()) {
            if (((Object)candidate.type()).equals(select.type())) {
                boolean containsAll = true;
                Iterator lit = select.elements().iterator();
                while (lit.hasNext()) {
                    Data subelem = (Data)lit.next();
                    if (candidate.contains(subelem)) continue;
                    containsAll = false;
                    break;
                }
                if (containsAll) {
                    return true;
                }
            }
        } else if (((Object)select.elementsType()).equals(candidate.type()) && select.contains(candidate)) {
            return true;
        }
        if (candidate.isCompound()) {
            Iterator it = candidate.children().values().iterator();
            while (it.hasNext()) {
                candidate = (Data)it.next();
                if (!this.match(candidate, select)) continue;
                return true;
            }
        }
        return false;
    }

    private InputStream loadFileRelativeToConfiguration(String settingName, String defaultValue) throws IOException, ConsumerException {
        Configuration config = NamedConfigurationFactory.getConfigurationByName((String)"org.egso.consumer");
        String theFile = config.getString(settingName);
        if (theFile == null || "".equals(theFile)) {
            if (defaultValue == null) {
                this.getLogger().warn((Object)("could not find file for '" + settingName + "' and " + "no default value was specified."));
                return null;
            }
            theFile = defaultValue.charAt(0) == '/' ? defaultValue : "/" + this.getClass().getPackage().getName().replace('.', '/') + "/" + defaultValue;
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info((Object)("no configuration found for '" + settingName + "' " + "continuing with default value..."));
            }
        }
        URL theURL = null;
        if (theFile.indexOf(58) > 0) {
            try {
                theURL = new URL(theFile);
                theURL.openConnection().getInputStream().close();
            }
            catch (MalformedURLException ex) {
            }
            catch (IOException ex) {
                theURL = null;
            }
        }
        if (theURL == null) {
            theURL = this.getClass().getResource(theFile);
        }
        if (theURL == null) {
            throw new ConsumerException("SSR::initialize(): '" + settingName + "' file was not found " + "(tried to load " + theFile + ")");
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info((Object)("loading the '" + settingName + "' contents " + "from " + theURL));
        }
        return theURL.openStream();
    }

    static {
        Consumer.getInstance();
    }
}

