/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.ssr;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.ImmutableException;
import org.egso.consumer.api.ScalarData;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.UncheckedConsumerException;
import org.egso.consumer.types.DoubleData;
import org.egso.consumer.types.IntervalData;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SSRHandler
extends DefaultHandler
implements EGSOLiterals {
    public static final String NAMESPACE = "http://www.ivoa.net/xml/VOTable/v1.1";
    public static final boolean verbose = false;
    static final String INTERVAL = "egso:interval";
    final Map ssrTypes = new HashMap();
    Data instruments = null;
    LinkedList groups = new LinkedList();
    Group currentGroup = null;
    Map unitTypes = new HashMap();
    private GenericType currentType = null;
    private List separatorsinOrder = new LinkedList();
    LinkedList nullValuesInOrder = new LinkedList();
    private int colIndex = 0;
    private List colNamesInOrder = new LinkedList();
    private boolean intd = false;
    private StringBuffer tdc = null;
    private GenericData currentInstr = null;
    private GenericType instrType;
    private GenericType doubleType = DoubleData.getDoubleType();
    private Map fieldId2Name = new HashMap();
    private final Logger logger = new AbstractLogEnabled(){

        public Logger getLogger() {
            return super.getLogger();
        }
    }.getLogger();
    private String currentSeparator = null;
    private String currentNullValue = null;
    protected static SAXParser parser = null;

    SSRHandler() {
    }

    Data getSSRInstruments() {
        return this.instruments;
    }

    Map getSSRTypes() {
        return this.ssrTypes;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (NAMESPACE.equals(uri)) {
            if ("FIELD".equals(localName)) {
                String utype;
                String ucd;
                String unit;
                String name;
                String datatype;
                String arraysize;
                String id = attributes.getValue(NAMESPACE, "ID");
                if (id == null) {
                    id = attributes.getValue("ID");
                }
                if ((arraysize = attributes.getValue(NAMESPACE, "arraysize")) == null) {
                    arraysize = attributes.getValue("arraysize");
                }
                if ((datatype = attributes.getValue(NAMESPACE, "datatype")) == null) {
                    datatype = attributes.getValue("datatype");
                }
                if ((name = attributes.getValue(NAMESPACE, "name")) == null) {
                    name = attributes.getValue("name");
                }
                if ((unit = attributes.getValue(NAMESPACE, "unit")) == null) {
                    unit = attributes.getValue("unit");
                }
                if ((ucd = attributes.getValue(NAMESPACE, "ucd")) == null) {
                    ucd = attributes.getValue("ucd");
                }
                if ((utype = attributes.getValue(NAMESPACE, "utype")) == null) {
                    utype = attributes.getValue("utype");
                }
                if (id != null) {
                    if (this.fieldId2Name.containsKey(id)) {
                        ConsumerException cex = new ConsumerException("FIELD id '" + id + "' not unique.");
                        this.logger.error((Object)cex);
                        throw new UncheckedConsumerException(cex);
                    }
                    this.fieldId2Name.put(id, name);
                }
                this.colNamesInOrder.add(name);
                if (unit != null) {
                    this.currentType = (GenericType)this.unitTypes.get(unit);
                }
                if (this.currentType == null) {
                    int sepindex;
                    String tName = unit;
                    if (tName == null) {
                        tName = name;
                    }
                    if ("double".equals(datatype)) {
                        this.currentType = this.doubleType;
                    } else {
                        try {
                            this.currentType = new GenericType(tName);
                            try {
                                this.currentType.setDistinct(true);
                            }
                            catch (ImmutableException ex) {
                                this.logger.error((Object)"why is currentType mutable?", (Throwable)((Object)ex));
                                throw new UncheckedConsumerException(ex);
                            }
                        }
                        catch (ArgumentException ex) {
                            this.logger.error((Object)"SSR will not load correctly due to this error: ", (Throwable)((Object)ex));
                            throw new UncheckedConsumerException(ex);
                        }
                    }
                    try {
                        if (ucd != null) {
                            this.currentType.setUcd(ucd);
                        }
                    }
                    catch (ImmutableException ex) {
                        this.logger.error((Object)"why the hell is this type immutable already?", (Throwable)((Object)ex));
                    }
                    if (!("*".equals(arraysize) && "char".equals(datatype) || arraysize == null || !arraysize.startsWith("*") || (sepindex = arraysize.indexOf(115)) <= 0)) {
                        this.currentSeparator = arraysize.substring(sepindex + 1);
                        try {
                            GenericType currentSetType = new GenericType("set-of-" + tName);
                            currentSetType.setElemsType(this.currentType);
                            this.currentType = currentSetType;
                        }
                        catch (ArgumentException ex) {
                            this.logger.error((Object)"SSR will not load correctly due to this error: ", (Throwable)((Object)ex));
                            throw new UncheckedConsumerException(ex);
                        }
                        catch (ImmutableException ex) {
                            this.logger.error((Object)"why the hell is this type immutable already?", (Throwable)((Object)ex));
                        }
                    }
                    if (unit != null) {
                        this.unitTypes.put(unit, this.currentType);
                    }
                }
                this.ssrTypes.put(name, this.currentType);
            } else if ("VALUES".equals(localName)) {
                String nullVal = attributes.getValue(NAMESPACE, "null");
                if (nullVal == null) {
                    nullVal = attributes.getValue("null");
                }
                this.currentNullValue = nullVal;
            } else if ("MIN".equals(localName)) {
                if (this.currentType.valueDomain() == null) {
                    try {
                        this.currentType.setValueDomain(new IntervalData(this.currentType, null, null, false, false));
                    }
                    catch (ConsumerException ex) {
                        this.logger.error((Object)"this must not happen!", (Throwable)((Object)ex));
                        throw new UncheckedConsumerException(ex);
                    }
                }
                IntervalData vd = (IntervalData)this.currentType.valueDomain();
                String value = attributes.getValue(NAMESPACE, "value");
                if (value == null) {
                    value = attributes.getValue("value");
                }
                Data newmin = null;
                try {
                    newmin = vd.elementsType().newData(value);
                }
                catch (ConsumerException ex) {
                    this.logger.warn((Object)("could not apply interval value '" + value + "', " + "continuing without"), (Throwable)((Object)ex));
                }
                ScalarData oldmin = vd.getMin();
                if (oldmin != null && oldmin.compareTo(newmin) > 0) {
                    newmin = oldmin;
                }
                try {
                    vd.setMin(newmin);
                }
                catch (ConsumerException ex) {
                    this.logger.warn((Object)("could not apply interval value '" + value + "', " + "continuing without"), (Throwable)((Object)ex));
                }
                String incl = attributes.getValue(NAMESPACE, "inclusive");
                if (incl == null) {
                    incl = attributes.getValue("inclusive");
                }
                if (incl == null) {
                    incl = "yes";
                }
                if ("yes".equals(incl)) {
                    vd.setMinIncl(true);
                } else if (!"no".equals(incl)) {
                    this.logger.warn((Object)("illegal inclusive attr value in MIN tag: " + incl));
                }
            } else if ("MAX".equals(localName)) {
                if (this.currentType.valueDomain() == null) {
                    try {
                        this.currentType.setValueDomain(new IntervalData(this.currentType, null, null, false, false));
                    }
                    catch (ConsumerException ex) {
                        this.logger.error((Object)"this must not happen!", (Throwable)((Object)ex));
                        throw new UncheckedConsumerException(ex);
                    }
                }
                IntervalData vd = (IntervalData)this.currentType.valueDomain();
                String value = attributes.getValue(NAMESPACE, "value");
                if (value == null) {
                    value = attributes.getValue("value");
                }
                Data newmax = null;
                try {
                    newmax = vd.elementsType().newData(value);
                }
                catch (ConsumerException ex) {
                    this.logger.warn((Object)("could not apply interval value '" + value + "', " + "continuing without"), (Throwable)((Object)ex));
                }
                ScalarData oldmax = vd.getMax();
                if (oldmax != null && oldmax.compareTo(newmax) > 0) {
                    newmax = oldmax;
                }
                try {
                    vd.setMax(newmax);
                }
                catch (ConsumerException ex) {
                    this.logger.warn((Object)("could not apply interval value '" + value + "', " + "continuing without"), (Throwable)((Object)ex));
                }
                String incl = attributes.getValue(NAMESPACE, "inclusive");
                if (incl == null) {
                    incl = attributes.getValue("inclusive");
                }
                if (incl == null) {
                    incl = "yes";
                }
                if ("yes".equals(incl)) {
                    vd.setMaxIncl(true);
                } else if (!"no".equals(incl)) {
                    this.logger.warn((Object)("illegal inclusive attr value in MAX tag: " + incl));
                }
            } else if ("OPTION".equals(localName)) {
                String value = attributes.getValue(NAMESPACE, "value");
                if (value == null) {
                    value = attributes.getValue("value");
                }
                try {
                    Data vd;
                    if (this.currentType.isList()) {
                        vd = this.currentType.elementsType().valueDomain();
                        if (vd == null) {
                            vd = this.currentType.newData();
                            ((GenericType)this.currentType.elementsType()).setValueDomain((GenericData)vd);
                        }
                    } else {
                        vd = this.currentType.valueDomain();
                        if (vd == null) {
                            GenericType setOfCurrentType = new GenericType("set-of-" + this.currentType.typeName());
                            setOfCurrentType.setElemsType(this.currentType);
                            vd = setOfCurrentType.newData();
                            this.currentType.setValueDomain((GenericData)vd);
                        }
                    }
                    Data newElement = vd.elementsType().newData(value);
                    if (!vd.elements().contains(newElement)) {
                        vd.add(newElement);
                    }
                }
                catch (ConsumerException ex) {
                    this.logger.warn((Object)("ssr parser: illegal option value '" + value + "', continuing without it..."), (Throwable)((Object)ex));
                }
            } else if ("TABLEDATA".equals(localName)) {
                try {
                    this.instrType = (GenericType)this.ssrTypes.get("instrument");
                    GenericType instrsType = new GenericType("set-of-" + this.instrType.typeName());
                    instrsType.setElemsType(this.instrType);
                    this.instruments = instrsType.newData();
                }
                catch (ConsumerException ex) {
                    this.logger.error((Object)"this must not happen! ", (Throwable)((Object)ex));
                }
                Iterator it = this.ssrTypes.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    this.instrType.childrenTypes().put(entry.getKey(), entry.getValue());
                }
                it = this.ssrTypes.values().iterator();
                while (it.hasNext()) {
                    try {
                        GenericType type = (GenericType)((Object)it.next());
                        if (type.valueDomain() != null) {
                            type.setEnum(true);
                        }
                        if (type.elementsType() == null || ((GenericType)type.elementsType()).valueDomain() == null) continue;
                        ((GenericType)type.elementsType()).setEnum(true);
                    }
                    catch (ImmutableException ex) {
                        this.logger.error((Object)"this type was not expected to be immutable.", (Throwable)((Object)ex));
                        throw new UncheckedConsumerException(ex);
                    }
                }
            } else if ("TR".equals(localName)) {
                this.colIndex = 0;
            } else if ("TD".equals(localName)) {
                this.tdc = new StringBuffer();
                this.intd = true;
            } else if ("GROUP".equals(localName)) {
                String utype;
                String name = attributes.getValue(NAMESPACE, "name");
                if (name == null) {
                    name = attributes.getValue("name");
                }
                if ((utype = attributes.getValue(NAMESPACE, "utype")) == null) {
                    utype = attributes.getValue("utype");
                }
                this.currentGroup = new Group(name, utype);
            } else if ("FIELDref".equals(localName)) {
                String fieldName;
                String ref = attributes.getValue(NAMESPACE, "ref");
                if (ref == null) {
                    ref = attributes.getValue("ref");
                }
                if ((fieldName = (String)this.fieldId2Name.get(ref)) == null || this.ssrTypes.get(fieldName) == null) {
                    this.logger.warn((Object)("invalid FIELDref: " + ref));
                }
                this.currentGroup.fieldRefs.add(fieldName);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("the tag '" + localName + "' was ignored as " + "it was outside VO Table namespace."));
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.intd) {
            this.tdc.append(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (NAMESPACE.equals(uri)) {
            if ("FIELD".equals(localName)) {
                this.separatorsinOrder.add(this.currentSeparator);
                this.nullValuesInOrder.add(this.currentNullValue);
                this.currentSeparator = null;
                this.currentType = null;
                this.currentNullValue = null;
            } else if ("TD".equals(localName)) {
                GenericData cellVal;
                String colname;
                block35: {
                    String content = this.tdc.toString().trim();
                    String separator = (String)this.separatorsinOrder.get(this.colIndex);
                    this.intd = false;
                    this.tdc = null;
                    colname = (String)this.colNamesInOrder.get(this.colIndex);
                    GenericType colType = (GenericType)this.ssrTypes.get(colname);
                    cellVal = null;
                    try {
                        if (separator == null) {
                            cellVal = (GenericData)colType.newData(content);
                            break block35;
                        }
                        try {
                            cellVal = (GenericData)colType.newData();
                        }
                        catch (ConsumerException cex) {
                            this.logger.error((Object)("unexpected exception when creating a new data of type '" + colType.typeName() + "'"), (Throwable)((Object)cex));
                            throw new UncheckedConsumerException(cex);
                        }
                        StringTokenizer st = new StringTokenizer(content, separator);
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            if (token.equals(this.nullValuesInOrder.get(this.colIndex))) continue;
                            cellVal.add(cellVal.elementsType().newData(token));
                        }
                    }
                    catch (ConsumerException ex) {
                        if (!this.logger.isDebugEnabled()) break block35;
                        this.logger.debug((Object)("ssr parser: failed to set new Data to '" + content + "', continuing without it..."), (Throwable)((Object)ex));
                    }
                }
                if (this.colIndex == 0) {
                    this.currentInstr = cellVal;
                } else {
                    try {
                        this.currentInstr.put(colname, cellVal);
                    }
                    catch (ArgumentException ex) {
                        this.logger.error((Object)"could unexpectedly not store some value", (Throwable)((Object)ex));
                        throw new UncheckedConsumerException(ex);
                    }
                }
                Iterator it = this.groups.iterator();
                while (it.hasNext()) {
                    Group group = (Group)it.next();
                    if (!group.fieldRefs.contains(colname)) continue;
                    try {
                        Data groupChild = this.currentInstr.get(group.name);
                        if (groupChild == null) {
                            Type groupChildType = (Type)this.currentInstr.childrenTypes().get(group.name);
                            groupChild = groupChildType.newData();
                            this.currentInstr.put(group.name, groupChild);
                        }
                        groupChild.put(colname, cellVal);
                    }
                    catch (ConsumerException ex) {
                        this.logger.error((Object)("unexpected problem: " + (Object)((Object)ex)), (Throwable)((Object)ex));
                        throw new UncheckedConsumerException(ex);
                    }
                }
                ++this.colIndex;
            } else if ("TR".equals(localName)) {
                try {
                    this.instruments.add(this.currentInstr);
                }
                catch (ConsumerException ex) {
                    this.logger.warn((Object)"not expected", (Throwable)((Object)ex));
                }
                this.currentInstr = null;
            } else if ("GROUP".equals(localName)) {
                GenericType groupType = null;
                if (INTERVAL.equals(this.currentGroup.utype)) {
                    if (this.currentGroup.fieldRefs.size() != 2 || !this.ssrTypes.get(this.currentGroup.fieldRefs.get(0)).equals(this.ssrTypes.get(this.currentGroup.fieldRefs.get(1)))) {
                        this.logger.warn((Object)"expected exactly two GROUPrefs to the same type");
                    }
                    try {
                        final String minKey = (String)this.currentGroup.fieldRefs.get(0);
                        final String maxKey = (String)this.currentGroup.fieldRefs.get(1);
                        groupType = new IntervalData.IntervalType(this.currentGroup.name, (GenericType)this.ssrTypes.get(this.currentGroup.fieldRefs.get(0)), new IntervalData.IntervalType.DefaultKeys(){

                            public String MIN() {
                                return minKey;
                            }

                            public String MAX() {
                                return maxKey;
                            }
                        });
                    }
                    catch (ArgumentException ex) {
                        this.logger.warn((Object)ex);
                    }
                } else {
                    try {
                        groupType = new GenericType(this.currentGroup.name);
                        Iterator it = this.currentGroup.fieldRefs.iterator();
                        while (it.hasNext()) {
                            String member_key = (String)it.next();
                            groupType.childrenTypes().put(member_key, this.ssrTypes.get(member_key));
                        }
                    }
                    catch (ArgumentException ex) {
                        this.logger.warn((Object)ex);
                    }
                }
                this.colNamesInOrder.add(this.currentGroup.name);
                this.ssrTypes.put(this.currentGroup.name, groupType);
                if (groupType == null) {
                    this.logger.warn((Object)"something went wrong in GROUP tag");
                }
                this.groups.add(this.currentGroup);
                this.currentGroup = null;
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("the tag '/" + localName + "' was ignored as " + "it was outside VO Table namespace."));
        }
    }

    public static void parse(InputStream is, DefaultHandler handler) throws ConsumerException {
        if (parser == null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            try {
                parser = factory.newSAXParser();
            }
            catch (ParserConfigurationException ex) {
                throw new ConsumerException("SSR::initialize: internal problem with SAX parser configuration: " + ex.getMessage(), ex);
            }
            catch (SAXException ex) {
                throw new ConsumerException("SSR::initialize: internal problem with SAX parser: " + ex.getMessage(), ex);
            }
        }
        try {
            parser.parse(is, handler);
        }
        catch (SAXException ex) {
            throw new ConsumerException("SSR::initialize: internal problem with SAX parser: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new ConsumerException("SSR::initialize: problem while parsing with reading from stream: " + ex.getMessage(), ex);
        }
    }

    class Group {
        final String name;
        final String utype;
        LinkedList fieldRefs = new LinkedList();

        public Group(String name, String utype) {
            this.name = name;
            this.utype = utype;
        }
    }
}

