/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.types;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.ImmutableException;
import org.egso.consumer.api.ScalarData;
import org.egso.consumer.api.ScalarType;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.UncheckedConsumerException;
import org.egso.consumer.util.Convert;

public class DateData
extends GenericData
implements ScalarData,
Data {
    public static DateType dateType;
    private Calendar time = new GregorianCalendar();

    public static synchronized GenericType getDateType() {
        if (dateType == null) {
            try {
                dateType = new DateType("date");
            }
            catch (ArgumentException argumentException) {
                // empty catch block
            }
        }
        return dateType;
    }

    public DateData() throws ArgumentException {
        this((DateType)null);
    }

    protected DateData(DateType type) throws ArgumentException {
        super(type != null ? type : DateData.getDateType());
    }

    protected DateData(DateType type, Object value) throws ConsumerException {
        this(type);
        this.setValue(value);
    }

    public DateData(Object initialValue) throws ConsumerException {
        this(null, initialValue);
    }

    public synchronized void setValue(Object value) throws ConsumerException {
        if (value instanceof DateData) {
            this.time = ((DateData)value).getTime();
        } else if (value instanceof Long) {
            this.time.setTimeInMillis((Long)value);
        } else if (value instanceof Date) {
            this.time.setTime((Date)value);
        } else if (value instanceof Calendar) {
            this.time = (Calendar)value;
        } else if (value instanceof String) {
            boolean conversion_success = false;
            if (!conversion_success) {
                try {
                    long timeInMs = Long.parseLong((String)value);
                    this.time.setTimeInMillis(timeInMs);
                    conversion_success = true;
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if (!conversion_success) {
                try {
                    this.time = Convert.str2calendar((String)value);
                    conversion_success = true;
                }
                catch (IllegalArgumentException ex) {
                }
                catch (StringIndexOutOfBoundsException ex) {
                }
                catch (RuntimeException ex) {
                    // empty catch block
                }
            }
            if (!conversion_success) {
                try {
                    this.time.setTime(DateFormat.getDateInstance().parse((String)value));
                    conversion_success = true;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (!conversion_success) {
                throw new ArgumentException("could not convert '" + value + "' into a date");
            }
        } else {
            super.setValue(value);
        }
        this.checkInValueDomain();
    }

    public synchronized Calendar getTime() {
        return this.time;
    }

    protected synchronized void setTimeInMs(long timeInMs) {
        this.time.setTimeInMillis(timeInMs);
    }

    public synchronized String id() {
        String fmt = new DecimalFormat("0000").format(this.time.get(1)) + "-" + new DecimalFormat("00").format(this.time.get(2)) + "-" + new DecimalFormat("00").format(this.time.get(5)) + " " + new DecimalFormat("00").format(this.time.get(11)) + ":" + new DecimalFormat("00").format(this.time.get(12)) + ":" + new DecimalFormat("00").format(this.time.get(13));
        return fmt;
    }

    public synchronized String toString() {
        return "DateData(timevalue=" + this.id() + " " + super.toString() + ")";
    }

    public final boolean equalsNr(GenericData otherObject) {
        if (!(otherObject instanceof DateData)) {
            return false;
        }
        return this.equalsNr((DateData)otherObject);
    }

    protected boolean equalsNr(DateData otherDate) {
        if (this.time == null || otherDate.time == null) {
            return this.time == otherDate.time;
        }
        return this.time.equals(otherDate.time);
    }

    public int compareTo(Object o) {
        if (!(o instanceof DateData)) {
            throw new UncheckedConsumerException(new ArgumentException("wrong object to compare"));
        }
        try {
            return this.compareTo((DateData)o);
        }
        catch (ArgumentException ex) {
            throw new UncheckedConsumerException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compareTo(DateData other) throws ArgumentException {
        if (other == null) {
            throw new ArgumentException("error: other == null");
        }
        if (other.objectHashCode() < this.objectHashCode()) {
            return -other.compareTo(this);
        }
        DateData dateData = this;
        synchronized (dateData) {
            DateData dateData2 = other;
            synchronized (dateData2) {
                if (this.time.before(other)) {
                    return -1;
                }
                if (this.time.after(other)) {
                    return 1;
                }
            }
        }
        return 0;
    }

    public synchronized Object getValue() {
        return this.time;
    }

    public static class DateType
    extends GenericType
    implements ScalarType,
    Type {
        public DateType(String typeName) throws ArgumentException {
            super(typeName);
            try {
                this.setNeutralData(new DateData(this));
            }
            catch (ImmutableException ex) {
                this.getLogger().warn((Object)("unexpected " + (Object)((Object)ex)), (Throwable)((Object)ex));
            }
        }

        public synchronized String toString() {
            return "DateData.DateType(" + super.toString() + ")";
        }
    }
}

