/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.types;

import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.ImmutableException;
import org.egso.consumer.api.ScalarData;
import org.egso.consumer.api.ScalarType;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.UncheckedConsumerException;

public class DoubleData
extends GenericData
implements Data,
Comparable,
ScalarData {
    private double val = 0.0;
    private static DoubleType instance = null;

    public DoubleData() throws ArgumentException {
        this((DoubleType)null);
    }

    protected DoubleData(DoubleType type) throws ArgumentException {
        super(type != null ? type : DoubleData.getDoubleType());
    }

    protected DoubleData(DoubleType type, Object value) throws ConsumerException {
        this(type);
        this.setValue(value);
    }

    public DoubleData(Object initialValue) throws ConsumerException {
        this(null, initialValue);
    }

    public DoubleData(double initialValue) throws ConsumerException {
        this(null, (Object)new Double(initialValue));
    }

    public synchronized double getVal() {
        return this.val;
    }

    protected synchronized void setVal(double val) {
        this.val = val;
    }

    public synchronized void setValue(Object value) throws ConsumerException {
        if (value instanceof DoubleData) {
            this.val = ((DoubleData)value).getVal();
        } else if (value instanceof Double) {
            this.val = (Double)value;
        } else if (value instanceof Float) {
            this.val = ((Float)value).floatValue();
        } else if (value instanceof String) {
            try {
                this.val = Double.parseDouble((String)value);
            }
            catch (NumberFormatException ex) {
                throw new ArgumentException(ex);
            }
        } else {
            super.setValue(value);
        }
        this.checkInValueDomain();
    }

    public String id() {
        return "" + this.getVal();
    }

    public String toString() {
        return "DoubleData(val=" + this.getVal() + " " + super.toString() + ")";
    }

    public final boolean equalsNr(GenericData otherObject) {
        if (!(otherObject instanceof DoubleData)) {
            return false;
        }
        return this.equalsNr((DoubleData)otherObject);
    }

    public boolean equalsNr(DoubleData otherDouble) {
        return this.val == otherDouble.val;
    }

    public int compareTo(Object o) {
        if (!(o instanceof DoubleData)) {
            throw new UncheckedConsumerException(new ArgumentException("wrong type for comparison: " + (o == null ? "null" : o.getClass().getName())));
        }
        try {
            return this.compareTo((DoubleData)o);
        }
        catch (ArgumentException ex) {
            throw new UncheckedConsumerException(ex);
        }
    }

    public int compareTo(DoubleData dd) throws ArgumentException {
        double vo;
        if (dd == null) {
            throw new ArgumentException("invalid argument: null");
        }
        double vt = this.getVal();
        if (vt < (vo = dd.getVal())) {
            return -1;
        }
        if (vt > vo) {
            return 1;
        }
        return 0;
    }

    public synchronized Object getValue() {
        return new Double(this.val);
    }

    public static synchronized DoubleType getDoubleType() {
        if (instance == null) {
            try {
                instance = new DoubleType();
            }
            catch (ArgumentException argumentException) {
                // empty catch block
            }
        }
        return instance;
    }

    public static class DoubleType
    extends GenericType
    implements Type,
    ScalarType {
        public DoubleType(String typeName) throws ArgumentException {
            super(typeName);
            try {
                this.setNeutralData(new DoubleData(this));
            }
            catch (ImmutableException ex) {
                this.getLogger().warn((Object)("unexpected " + (Object)((Object)ex)), (Throwable)((Object)ex));
            }
        }

        public DoubleType() throws ArgumentException {
            this("double");
        }

        public synchronized String toString() {
            return "DoubleData.DoubleType(" + super.toString() + ")";
        }
    }
}

