/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.FileHandle;
import org.egso.consumer.api.ImmutableException;
import org.egso.consumer.api.MultipleException;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.ftp.FTPConnection;

public class FileHandleData
extends GenericData
implements FileHandle,
Data {
    private List listOfFiles = null;

    public FileHandleData() throws ArgumentException {
        this((FileHandleType)null);
    }

    protected FileHandleData(FileHandleType type) throws ArgumentException {
        super(type != null ? type : new FileHandleType());
    }

    protected FileHandleData(FileHandleType type, FileHandle value) throws ConsumerException {
        this(type);
        this.setValue(value);
    }

    public FileHandleData(FileHandle initialValue) throws ConsumerException {
        this(null, initialValue);
    }

    public void setValue(Object value) throws ArgumentException {
        if (!(value instanceof Collection)) {
            throw new ArgumentException("only a collection of string accepted.");
        }
        Iterator it = ((Collection)value).iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (element instanceof String || element instanceof FileWithNameMapping) continue;
            throw new ArgumentException("only a collection of string or FileWithNameMapping accepted but got " + (element == null ? "null" : element.getClass().getName()));
        }
        this.listOfFiles = new LinkedList((Collection)value);
        this.checkInValueDomain();
    }

    public String toString() {
        return "FileHandleData(fileset=" + this.listOfFiles + " " + super.toString() + ")";
    }

    /*
     * WARNING - void declaration
     */
    public void openFile(OutputStream out) throws ConsumerException, IOException {
        LinkedList<Throwable> exceptions = new LinkedList<Throwable>();
        ZipOutputStream zipOut = new ZipOutputStream(out);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"start zipping...");
        }
        byte[] buf = new byte[1024];
        for (int i = 0; i < this.listOfFiles.size(); ++i) {
            void var8_10;
            URL url;
            String entryName;
            Object listEntry = this.listOfFiles.get(i);
            if (listEntry instanceof String) {
                entryName = new URL((String)listEntry).getFile();
                url = new URL((String)listEntry);
            } else if (listEntry instanceof FileWithNameMapping) {
                entryName = ((FileWithNameMapping)listEntry).zipFileName;
                url = new URL(((FileWithNameMapping)listEntry).originalURL);
            } else {
                throw new ArgumentException("unexpected entry in list");
            }
            if (entryName.startsWith("/")) {
                entryName = entryName.substring(1);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("transferring " + var8_10.toExternalForm()));
            }
            try {
                int len;
                InputStream in = null;
                FTPConnection ftp = null;
                if (var8_10.getProtocol().equals("ftp")) {
                    ftp = new FTPConnection(var8_10.getHost());
                    ftp.login("ftp", "ftp");
                    in = ftp.get(var8_10.getPath());
                } else {
                    in = var8_10.openStream();
                }
                zipOut.putNextEntry(new ZipEntry(entryName));
                while ((len = in.read(buf)) > 0) {
                    zipOut.write(buf, 0, len);
                }
                zipOut.closeEntry();
                in.close();
                if (!var8_10.getProtocol().equals("ftp")) continue;
                ftp.quit();
                ftp = null;
                continue;
            }
            catch (Throwable ex) {
                this.getLogger().debug((Object)ex);
                exceptions.add(ex);
            }
        }
        zipOut.close();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"finished zipping...");
        }
        if (exceptions.size() > 0) {
            String msg = "some exceptions occurred while downloading the files";
            for (int i = 0; i < exceptions.size(); ++i) {
                msg = msg + "; " + ((Throwable)exceptions.get(i)).getMessage();
            }
            throw new MultipleException(msg, exceptions.toArray(new Throwable[exceptions.size()]));
        }
    }

    protected final boolean equalsNr(GenericData otherData) {
        if (!(otherData instanceof FileHandleData)) {
            return false;
        }
        return this.equalsNr((FileHandleData)otherData);
    }

    protected boolean equalsNr(FileHandleData otherData) {
        if (this.listOfFiles == null || otherData.listOfFiles == null) {
            return this.listOfFiles == otherData.listOfFiles;
        }
        return ((Object)this.listOfFiles).equals(otherData.listOfFiles);
    }

    public static class FileHandleType
    extends GenericType
    implements Type {
        public FileHandleType(String typeName) throws ArgumentException {
            super(typeName);
            try {
                this.setNeutralData(new FileHandleData(this));
            }
            catch (ImmutableException ex) {
                this.getLogger().warn((Object)("unexpected " + (Object)((Object)ex)), (Throwable)((Object)ex));
            }
        }

        public FileHandleType() throws ArgumentException {
            this("filehandle");
        }

        public synchronized String toString() {
            return "FileHandleData.FileHandleType(" + super.toString() + ")";
        }
    }

    public static class FileWithNameMapping
    implements Comparable {
        public final String originalURL;
        public final String zipFileName;

        public FileWithNameMapping(String url, String zipEntry) {
            this.originalURL = url;
            this.zipFileName = zipEntry;
        }

        public int compareTo(Object o) {
            return this.zipFileName.compareTo(((FileWithNameMapping)o).zipFileName);
        }
    }
}

