/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.types;

import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.ImmutableException;
import org.egso.consumer.api.ScalarData;
import org.egso.consumer.api.ScalarType;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.UncheckedConsumerException;

public class IntegerData
extends GenericData
implements Data,
Comparable,
ScalarData {
    private long val = 0L;
    private static IntegerType instance = null;

    public IntegerData() throws ArgumentException {
        this((IntegerType)null);
    }

    protected IntegerData(IntegerType type) throws ArgumentException {
        super(type != null ? type : new IntegerType());
    }

    protected IntegerData(IntegerType type, Object value) throws ConsumerException {
        this(type);
        this.setValue(value);
    }

    public IntegerData(Object initialValue) throws ConsumerException {
        this(null, initialValue);
    }

    public IntegerData(long initialValue) throws ConsumerException {
        this(null, (Object)new Long(initialValue));
    }

    public synchronized long getVal() {
        return this.val;
    }

    protected synchronized void setVal(long val) {
        this.val = val;
    }

    public synchronized void setValue(Object value) throws ConsumerException {
        if (value instanceof IntegerData) {
            this.val = ((IntegerData)value).getVal();
        } else if (value instanceof Integer) {
            this.val = ((Integer)value).intValue();
        } else if (value instanceof Long) {
            this.val = (Long)value;
        } else if (value instanceof Float) {
            this.val = (long)((Float)value).floatValue();
        } else if (value instanceof String) {
            try {
                this.val = Long.parseLong((String)value);
            }
            catch (NumberFormatException ex) {
                throw new ArgumentException(ex);
            }
        } else {
            super.setValue(value);
        }
        this.checkInValueDomain();
    }

    public String id() {
        return "" + this.getVal();
    }

    public String toString() {
        return "IntegerData(val=" + this.getVal() + " " + super.toString() + ")";
    }

    protected final boolean equalsNr(GenericData otherObject) {
        if (!(otherObject instanceof IntegerData)) {
            return false;
        }
        return this.equalsNr((IntegerData)otherObject);
    }

    protected boolean equalsNr(IntegerData otherInteger) {
        return this.val == otherInteger.val;
    }

    public int compareTo(Object o) {
        if (!(o instanceof IntegerData)) {
            throw new UncheckedConsumerException(new ArgumentException("wrong type for comparison: " + (o == null ? "null" : o.getClass().getName())));
        }
        try {
            return this.compareTo((IntegerData)o);
        }
        catch (ArgumentException ex) {
            throw new UncheckedConsumerException(ex);
        }
    }

    public int compareTo(IntegerData dd) throws ArgumentException {
        long vo;
        if (dd == null) {
            throw new ArgumentException("invalid argument: null");
        }
        long vt = this.getVal();
        if (vt < (vo = dd.getVal())) {
            return -1;
        }
        if (vt > vo) {
            return 1;
        }
        return 0;
    }

    public synchronized Object getValue() {
        return new Long(this.val);
    }

    public static synchronized IntegerType getIntegerType() {
        if (instance == null) {
            try {
                instance = new IntegerType();
            }
            catch (ArgumentException argumentException) {
                // empty catch block
            }
        }
        return instance;
    }

    public static class IntegerType
    extends GenericType
    implements Type,
    ScalarType {
        public IntegerType(String typeName) throws ArgumentException {
            super(typeName);
            try {
                this.setNeutralData(new IntegerData(this));
            }
            catch (ImmutableException ex) {
                this.getLogger().warn((Object)("unexpected " + (Object)((Object)ex)), (Throwable)((Object)ex));
            }
        }

        public IntegerType() throws ArgumentException {
            this("type::Integer");
        }

        public synchronized String toString() {
            return "IntegerData.IntegerType(" + super.toString() + ")";
        }
    }
}

