/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.types;

import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.api.Data;
import org.egso.consumer.api.ImmutableException;
import org.egso.consumer.api.ScalarData;
import org.egso.consumer.api.ScalarType;
import org.egso.consumer.api.Type;
import org.egso.consumer.core.GenericData;
import org.egso.consumer.core.GenericType;
import org.egso.consumer.core.UncheckedConsumerException;

public class StringData
extends GenericData
implements Data,
Comparable,
ScalarData {
    private String val = null;
    public static StringType stringType;

    public StringData() throws ArgumentException {
        this((StringType)null);
    }

    public StringData(StringType type) throws ArgumentException {
        super(type != null ? type : StringData.getStringType());
    }

    public StringData(StringType type, Object value) throws ConsumerException {
        this(type);
        this.setValue(value);
    }

    public StringData(Object initialValue) throws ConsumerException {
        this(null, initialValue);
    }

    public StringData(String initialValue) throws ConsumerException {
        this(null, (Object)new String(initialValue));
    }

    public synchronized String getVal() {
        return this.val;
    }

    protected synchronized void setVal(String val) {
        this.val = val;
    }

    public synchronized void setValue(Object value) throws ConsumerException {
        if (value instanceof StringData) {
            this.set(((StringData)value).getVal());
        } else if (value instanceof String) {
            this.set((String)value);
        } else if (value instanceof Float) {
            this.set("" + ((Float)value).floatValue());
        } else {
            super.setValue(value);
        }
        this.checkInValueDomain();
    }

    public synchronized void set(String value) throws ConsumerException {
        this.val = value;
    }

    public String id() {
        return "" + this.getVal();
    }

    public String toString() {
        return "StringData(val=" + this.getVal() + " " + super.toString() + ")";
    }

    public boolean equalsNr(GenericData otherObject) {
        if (!(otherObject instanceof StringData)) {
            return false;
        }
        return this.equalsNr((StringData)otherObject);
    }

    public boolean equalsNr(StringData otherString) {
        if (this.val == otherString.val) {
            return true;
        }
        if (this.val == null) {
            return otherString.val == null;
        }
        return this.val.equals(otherString.val);
    }

    public int compareTo(Object o) {
        if (!(o instanceof StringData)) {
            throw new UncheckedConsumerException(new ArgumentException("wrong type for comparison: " + (o == null ? "null" : o.getClass().getName())));
        }
        try {
            return this.compareTo((StringData)o);
        }
        catch (ArgumentException ex) {
            throw new UncheckedConsumerException(ex);
        }
    }

    public int compareTo(StringData dd) throws ArgumentException {
        if (dd == null) {
            throw new ArgumentException("invalid argument: null");
        }
        String vt = this.getVal();
        String vo = dd.getVal();
        return vt.compareTo(vo);
    }

    public synchronized Object getValue() {
        return this.val;
    }

    public static synchronized GenericType getStringType() {
        if (stringType == null) {
            try {
                stringType = new StringType("string");
            }
            catch (ArgumentException argumentException) {
                // empty catch block
            }
        }
        return stringType;
    }

    public static class StringType
    extends GenericType
    implements Type,
    ScalarType {
        public StringType(String typeName) throws ArgumentException {
            super(typeName);
            try {
                this.setNeutralData(new StringData(this));
            }
            catch (ImmutableException ex) {
                this.getLogger().warn((Object)("unexpected " + (Object)((Object)ex)), (Throwable)((Object)ex));
            }
        }

        public StringType() throws ArgumentException {
            this("string");
        }

        public synchronized String toString() {
            return "StringData.StringType(" + super.toString() + ")";
        }
    }
}

