/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.types.egso;

import org.egso.consumer.EGSOLiterals;
import org.egso.consumer.api.ArgumentException;
import org.egso.consumer.api.ConsumerException;
import org.egso.consumer.types.StringData;

public class XRayClassData
extends StringData
implements EGSOLiterals {
    private static XRayClassType instance = null;

    public XRayClassData() throws ArgumentException {
        this((StringData.StringType)null);
    }

    public XRayClassData(StringData.StringType type) throws ArgumentException {
        super(type != null ? type : XRayClassData.getXRayClassType());
    }

    public XRayClassData(StringData.StringType type, Object value) throws ConsumerException {
        this(type);
        this.setValue(value);
    }

    public XRayClassData(Object initialValue) throws ConsumerException {
        this(null, initialValue);
    }

    public XRayClassData(String initialValue) throws ConsumerException {
        this(null, (Object)new String(initialValue));
    }

    public synchronized void set(String value) throws ConsumerException {
        char[] xray1char = new char[]{'A', 'B', 'C', 'M', 'X'};
        if (value == null) {
            throw new ArgumentException("xray class value must not be null.");
        }
        if (value.length() < 2) {
            throw new ArgumentException("xray class value incomplete: " + value + " (expected at least 2 characters");
        }
        char first = value.charAt(0);
        boolean ok = false;
        for (int i = 0; i < xray1char.length; ++i) {
            ok |= xray1char[i] == first;
        }
        if (!ok) {
            throw new ArgumentException("expected first character of an xray value to be one of A, B, C, M, or X; but got " + first);
        }
        if (first != 'X') {
            char second = value.charAt(1);
            if ("0123456789".indexOf(second) < 0) {
                throw new ArgumentException("expected a digit at position 2 but got: '" + second + "'");
            }
            char third = value.charAt(2);
            if (".".indexOf(third) < 0) {
                throw new ArgumentException("expected a period at position 3 but got: '" + third + "'");
            }
            char fourth = value.charAt(3);
            if ("0123456789".indexOf(fourth) < 0) {
                throw new ArgumentException("expected a digit at position 4 but got: '" + fourth + "'");
            }
        } else {
            try {
                Double.parseDouble(value.substring(1));
            }
            catch (NumberFormatException ex) {
                throw new ArgumentException(ex);
            }
        }
        super.set(value);
    }

    public int compareTo(StringData otherString) {
        if (((Object)this.type()).equals(otherString.type())) {
            String o1;
            String t1 = this.getVal().substring(0, 1);
            int c = t1.compareTo(o1 = this.getVal().substring(0, 1));
            if (c != 0) {
                return c;
            }
            String trest = this.getVal().substring(1);
            String orest = this.getVal().substring(1);
            double t2 = Double.parseDouble(trest);
            double o2 = Double.parseDouble(orest);
            return Double.compare(t2, o2);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("comparison of " + this.typeName() + " to " + otherString.typeName() + " returns always false."));
        }
        return super.compareTo((Object)otherString);
    }

    public static synchronized XRayClassType getXRayClassType() {
        if (instance == null) {
            try {
                instance = new XRayClassType();
            }
            catch (ArgumentException argumentException) {
                // empty catch block
            }
        }
        return instance;
    }

    public static class XRayClassType
    extends StringData.StringType {
        XRayClassType(String typeName) throws ArgumentException {
            super(typeName);
        }

        XRayClassType() throws ArgumentException {
            this("xray_class");
        }

        public synchronized String toString() {
            return "XRayClassData.XRayType(" + super.toString() + ")";
        }
    }
}

