/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class Compare {
    public static final boolean EQUAL = true;
    public static final boolean DIFFERENT = false;

    public static boolean compareCollections(Collection c1, Collection c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null != (c2 == null)) {
            return false;
        }
        return c1.containsAll(c2) && c2.containsAll(c1);
    }

    public static boolean compareCollectionsCountAware(Collection c1, Collection c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null != (c2 == null)) {
            return false;
        }
        if (!c1.containsAll(c2) || !c2.containsAll(c1)) {
            return false;
        }
        c1 = new LinkedList(c1);
        c2 = new LinkedList(c2);
        Iterator it1 = c1.iterator();
        block0: while (it1.hasNext()) {
            Object e1 = it1.next();
            Iterator it2 = c2.iterator();
            while (it2.hasNext()) {
                Object e2 = it2.next();
                if (!e1.equals(e2)) continue;
                it1.remove();
                it2.remove();
                continue block0;
            }
            return false;
        }
        if (c1.size() > 0) {
            return false;
        }
        return c2.size() <= 0;
    }

    public static boolean compareMaps(Map m1, Map m2) {
        Set k2;
        if (m1 == m2) {
            return true;
        }
        Set k1 = m1.keySet();
        if (!k1.containsAll(k2 = m2.keySet()) || !k2.containsAll(k1)) {
            return false;
        }
        Iterator key_it = m1.keySet().iterator();
        while (key_it.hasNext()) {
            Object key = key_it.next();
            Object val1 = m1.get(key);
            Object val2 = m2.get(key);
            if (val1 == null ? val2 != null : val2 == null) {
                return false;
            }
            if (!val1.equals(val2)) {
                return false;
            }
            if (val2.equals(val1)) continue;
            return false;
        }
        return true;
    }
}

