/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.util;

import java.util.Calendar;

public class Convert {
    public static long str2date(String date) throws IllegalArgumentException {
        return Convert.str2calendar(date).getTimeInMillis();
    }

    public static Calendar str2calendarFixedFormat(String date) throws IllegalArgumentException {
        int year = Integer.parseInt(date.substring(0, 4));
        if (date.charAt(4) != '-') {
            throw new IllegalArgumentException("'-' expected at position 4 of " + date);
        }
        int month = Integer.parseInt(date.substring(5, 7));
        if (date.charAt(7) != '-') {
            throw new IllegalArgumentException("'-' expected at position 7 of " + date);
        }
        int day = Integer.parseInt(date.substring(8, 10));
        if (date.charAt(10) != ' ') {
            throw new IllegalArgumentException("' ' expected at position 10 of " + date);
        }
        int hour = Integer.parseInt(date.substring(11, 13));
        if (date.charAt(13) != ':') {
            throw new IllegalArgumentException("':' expected at position 13 of " + date);
        }
        int minute = Integer.parseInt(date.substring(14, 16));
        if (date.charAt(16) != ':') {
            throw new IllegalArgumentException("':' expected at position 16 of " + date);
        }
        int second = Integer.parseInt(date.substring(17, 19));
        if (date.length() != 19) {
            throw new IllegalArgumentException("end of string expected at position 19 of " + date);
        }
        Calendar t = Calendar.getInstance();
        t.set(15, 0);
        t.setTimeInMillis(0L);
        t.set(1, year);
        t.set(2, month);
        t.set(5, day);
        t.set(11, hour);
        t.set(12, minute);
        t.set(13, second);
        return t;
    }

    public static Calendar str2calendar(String date) throws IllegalArgumentException {
        String[] frags = date.trim().split("\\s|-|/|:", 7);
        if (frags.length != 6) {
            throw new IllegalArgumentException("expected a date with format YYYY-MM-DD HH:MM:SS: " + date);
        }
        int year = Integer.parseInt(frags[0]);
        int month = Integer.parseInt(frags[1]);
        int day = Integer.parseInt(frags[2]);
        int hour = Integer.parseInt(frags[3]);
        int minute = Integer.parseInt(frags[4]);
        int second = Integer.parseInt(frags[5]);
        Calendar t = Calendar.getInstance();
        t.set(15, 0);
        t.setTimeInMillis(0L);
        t.set(1, year);
        t.set(2, month);
        t.set(5, day);
        t.set(11, hour);
        t.set(12, minute);
        t.set(13, second);
        return t;
    }
}

