/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.egso.consumer.api.Query;
import org.egso.consumer.api.async.Event;
import org.egso.consumer.api.async.EventSource;
import org.egso.consumer.util.AbstractEvent;
import org.egso.consumer.util.AbstractEventSource;

public class ObservableHashMap
extends AbstractEventSource
implements EventSource,
Map,
Cloneable {
    private HashMap theHashMap;
    private Map theMap;

    public ObservableHashMap() {
        this.theHashMap = new HashMap();
        this.theMap = Collections.synchronizedMap(this.theHashMap);
    }

    public ObservableHashMap(boolean recordEvents) {
        this();
        this.initEventLog(recordEvents);
    }

    public ObservableHashMap(Map m) {
        this.theHashMap = m == null ? new HashMap() : new HashMap(m);
        this.theMap = Collections.synchronizedMap(this.theHashMap);
    }

    public int size() {
        return this.theMap.size();
    }

    public synchronized void clear() {
        Iterator it = new HashMap(this.theMap).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry anentry = it.next();
            this.remove(anentry.getKey());
            this.update(new RemoveEvent(anentry.getKey(), anentry.getValue()));
        }
    }

    public boolean isEmpty() {
        return this.theMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.theMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.theMap.containsValue(value);
    }

    public Collection values() {
        return Collections.unmodifiableCollection(this.theMap.values());
    }

    public synchronized void putAll(Map t) {
        Iterator it = t.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry anentry = it.next();
            this.put(anentry.getKey(), anentry.getValue());
        }
    }

    public Set entrySet() {
        return Collections.unmodifiableSet(this.theMap.entrySet());
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this.theMap.keySet());
    }

    public Object get(Object key) {
        return this.theMap.get(key);
    }

    public synchronized Object remove(Object key) {
        Object ret = this.theMap.remove(key);
        this.update(new RemoveEvent(key, ret));
        return ret;
    }

    public synchronized Object put(Object key, Object value) {
        Object ret = this.theMap.put(key, value);
        this.update(new PutEvent(key, value));
        return ret;
    }

    public synchronized Object clone() {
        ObservableHashMap clone = (ObservableHashMap)super.clone();
        clone.theHashMap = (HashMap)this.theHashMap.clone();
        clone.theMap = Collections.synchronizedMap(clone.theHashMap);
        return clone;
    }

    public Map toHashMap() {
        return new HashMap(this.theHashMap);
    }

    public String toString() {
        return this.theMap.toString();
    }

    public class RemoveEvent
    extends AbstractMapEvent
    implements Event {
        public RemoveEvent() {
        }

        public RemoveEvent(Object map_key, Object value) {
            super(map_key, value);
        }

        public RemoveEvent(String data_key, Query query, long time, Object map_key, Object value) {
            super(data_key, query, time, map_key, value);
        }
    }

    public class PutEvent
    extends AbstractMapEvent
    implements Event {
        public PutEvent() {
        }

        public PutEvent(Object map_key, Object value) {
            super(map_key, value);
        }

        public PutEvent(String data_key, Query query, long time, Object map_key, Object value) {
            super(data_key, query, time, map_key, value);
        }
    }

    private class AbstractMapEvent
    extends AbstractEvent
    implements MapEvent,
    Event {
        private Object map_key;
        private Object value;

        public AbstractMapEvent() {
            this.map_key = null;
            this.value = null;
        }

        public AbstractMapEvent(Object map_key, Object value) {
            this.map_key = map_key;
            this.value = value;
        }

        public AbstractMapEvent(String data_key, Query query, long time, Object map_key, Object value) {
            super(data_key, query, time);
            this.map_key = map_key;
            this.value = value;
        }

        public Object getKey() {
            return this.map_key;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static interface MapEvent
    extends Event {
        public Object getKey();

        public Object getValue();
    }
}

