/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.egso.consumer.api.Query;
import org.egso.consumer.api.async.Event;
import org.egso.consumer.api.async.EventSource;
import org.egso.consumer.util.AbstractEvent;
import org.egso.consumer.util.AbstractEventSource;

public class ObservableList
extends AbstractEventSource
implements EventSource,
List,
Cloneable {
    private LinkedList theLinkedList;
    private List theList;

    public ObservableList() {
        this.theLinkedList = new LinkedList();
        this.theList = Collections.synchronizedList(this.theLinkedList);
    }

    public ObservableList(boolean recordEvents) {
        this();
        this.initEventLog(recordEvents);
    }

    public ObservableList(Collection l) {
        this.theLinkedList = l == null ? new LinkedList() : new LinkedList(l);
        this.theList = Collections.synchronizedList(this.theLinkedList);
    }

    public synchronized boolean add(Object element) {
        boolean ret = this.theList.add(element);
        this.update(new AddEvent(element));
        return ret;
    }

    public synchronized boolean remove(Object element) {
        boolean ret = this.theList.remove(element);
        this.update(new RemoveEvent(element));
        return ret;
    }

    public int size() {
        return this.theList.size();
    }

    public boolean isEmpty() {
        return this.theList.isEmpty();
    }

    public boolean contains(Object o) {
        return this.theList.contains(o);
    }

    public Iterator iterator() {
        return this.theList.iterator();
    }

    public Object[] toArray() {
        return this.theList.toArray();
    }

    public Object[] toArray(Object[] arg0) {
        return this.theList.toArray(arg0);
    }

    public boolean containsAll(Collection set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection arg0) {
        boolean ret = false;
        Iterator it = arg0.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (this.contains(element)) continue;
            ret |= this.add(element);
        }
        return ret;
    }

    public boolean removeAll(Collection arg0) {
        boolean ret = false;
        Iterator it = arg0.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.contains(element)) continue;
            ret |= this.remove(element);
        }
        return false;
    }

    public synchronized boolean retainAll(Collection arg0) {
        boolean ret = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (arg0.contains(element)) continue;
            it.remove();
            ret = true;
        }
        return ret;
    }

    public synchronized void clear() {
        Iterator it = new LinkedList(this).iterator();
        while (it.hasNext()) {
            Object element = it.next();
            this.remove(element);
            this.update(new RemoveEvent(element));
        }
    }

    public boolean addAll(int arg0, Collection arg1) {
        throw new UnsupportedOperationException("ObservableList.addAll(int, Collection) is not supported.");
    }

    public Object get(int index) {
        return this.theList.get(index);
    }

    public Object set(int arg0, Object arg1) {
        throw new UnsupportedOperationException("ObservableList.set(int, Object) is not supported.");
    }

    public void add(int arg0, Object arg1) {
        throw new UnsupportedOperationException("ObservableList.add(int, Object) is not supported.");
    }

    public synchronized Object remove(int index) {
        Object ret = this.get(index);
        if (ret != null) {
            this.remove(ret);
        }
        return ret;
    }

    public int indexOf(Object o) {
        return this.theList.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.theList.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.theList.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.theList.listIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.theList.subList(fromIndex, toIndex);
    }

    public synchronized Object clone() {
        ObservableList clone = (ObservableList)super.clone();
        clone.theLinkedList = (LinkedList)this.theLinkedList.clone();
        clone.theList = Collections.synchronizedList(clone.theLinkedList);
        return clone;
    }

    public List toLinkedList() {
        return new LinkedList(this.theLinkedList);
    }

    public String toString() {
        return this.theList.toString();
    }

    public class RemoveEvent
    extends AbstractListEvent
    implements Event {
        public RemoveEvent() {
        }

        public RemoveEvent(Object element) {
            super(element);
        }

        public RemoveEvent(String data_key, Query query, long time, Object element) {
            super(data_key, query, time, element);
        }
    }

    public class AddEvent
    extends AbstractListEvent
    implements Event {
        public AddEvent() {
        }

        public AddEvent(Object element) {
            super(element);
        }

        public AddEvent(String data_key, Query query, long time, Object element) {
            super(data_key, query, time, element);
        }
    }

    private class AbstractListEvent
    extends AbstractEvent
    implements ListEvent,
    Event {
        private Object element;

        public AbstractListEvent() {
            this.element = null;
        }

        public AbstractListEvent(Object element) {
            this.element = element;
        }

        public AbstractListEvent(String data_key, Query query, long time, Object element) {
            super(data_key, query, time);
            this.element = element;
        }

        public Object getElement() {
            return this.element;
        }
    }

    public static interface ListEvent
    extends Event {
        public Object getElement();
    }
}

