/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.valid;

import org.apache.log4j.Logger;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.api.ArgumentException;

public class ChildNameValidator
extends AbstractLogEnabled {
    public static final int MAX_TYPENAME_LENGTH = 63;
    private static Logger theLogger = new ChildNameValidator().getLogger();

    private ChildNameValidator() {
    }

    public static void validateChildAttributeName(Object childname) throws ArgumentException {
        if (childname == null) {
            ArgumentException aex = new ArgumentException("a child attribute name must never be null");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if (!(childname instanceof String)) {
            ArgumentException aex = new ArgumentException("expected String for a type's child attribute name, but got: " + childname.getClass());
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if ("".equals(childname)) {
            ArgumentException aex = new ArgumentException("a child attribute name must not be emtpy");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if (!((String)childname).matches("[a-zA-Z0-9_:/.\\-]*")) {
            ArgumentException aex = new ArgumentException("illegal child attribute name '" + childname + "'");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if (((String)childname).length() > 63) {
            ArgumentException aex = new ArgumentException("child attribute name '" + childname + "' too long " + "(max " + 63 + " characters allowed)");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
    }
}

