/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.valid;

import org.apache.log4j.Logger;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.api.ArgumentException;

public class ParameterNameValidator
extends AbstractLogEnabled {
    public static final int MAX_PARAMNAME_LENGTH = 63;
    private static Logger theLogger = new ParameterNameValidator().getLogger();

    private ParameterNameValidator() {
    }

    public static void validateParameterName(String paramname) throws ArgumentException {
        if (paramname == null) {
            ArgumentException aex = new ArgumentException("a parameter name must not be null");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if ("".equals(paramname)) {
            ArgumentException aex = new ArgumentException("a parameter name must not be emtpy");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if (!paramname.matches("[a-zA-Z0-9_:/.\\-]*")) {
            ArgumentException aex = new ArgumentException("illegal parameter name '" + paramname + "'");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if (paramname.length() > 63) {
            ArgumentException aex = new ArgumentException("parameter name '" + paramname + "' too long " + "(max " + 63 + " characters allowed)");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
    }
}

